/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.jigsaw;

import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.betterstrongholds.BetterStrongholds;
import com.yungnickyoung.minecraft.betterstrongholds.config.BSConfig;
import com.yungnickyoung.minecraft.betterstrongholds.world.jigsaw.JigsawConfig;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.JigsawBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.EmptyJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.commons.lang3.mutable.MutableObject;

public class JigsawManager {
    public static void assembleJigsawStructure(DynamicRegistries dynamicRegistryManager, JigsawConfig jigsawConfig, ChunkGenerator chunkGenerator, TemplateManager templateManager, BlockPos startPos, List<? super AbstractVillagePiece> components, Random random, boolean doBoundaryAdjustments, boolean useHeightmap) {
        MutableRegistry jigsawPoolRegistry = dynamicRegistryManager.func_243612_b(Registry.field_243555_ax);
        Rotation rotation = Rotation.func_222466_a((Random)random);
        JigsawPattern startPool = jigsawConfig.getStartPoolSupplier().get();
        JigsawPiece startPieceBlueprint = startPool.func_214944_a(random);
        AbstractVillagePiece startPiece = new AbstractVillagePiece(templateManager, startPieceBlueprint, startPos, startPieceBlueprint.func_214850_d(), rotation, startPieceBlueprint.func_214852_a(templateManager, startPos, rotation));
        MutableBoundingBox pieceBoundingBox = startPiece.func_74874_b();
        int pieceCenterX = (pieceBoundingBox.field_78893_d + pieceBoundingBox.field_78897_a) / 2;
        int pieceCenterZ = (pieceBoundingBox.field_78892_f + pieceBoundingBox.field_78896_c) / 2;
        int pieceCenterY = useHeightmap ? startPos.func_177956_o() + chunkGenerator.func_222532_b(pieceCenterX, pieceCenterZ, Heightmap.Type.WORLD_SURFACE_WG) : startPos.func_177956_o();
        int yAdjustment = pieceBoundingBox.field_78895_b + startPiece.func_214830_d();
        startPiece.func_181138_a(0, pieceCenterY - yAdjustment, 0);
        components.add((AbstractVillagePiece)startPiece);
        if (jigsawConfig.getMaxChainPieceLength() > 0) {
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)(pieceCenterX - 80), (double)(pieceCenterY - 80), (double)(pieceCenterZ - 80), (double)(pieceCenterX + 80 + 1), (double)(pieceCenterY + 80 + 1), (double)(pieceCenterZ + 80 + 1));
            Assembler assembler = new Assembler((Registry<JigsawPattern>)jigsawPoolRegistry, jigsawConfig.getMaxChainPieceLength(), chunkGenerator, templateManager, components, random);
            Entry startPieceEntry = new Entry(startPiece, (MutableObject<VoxelShape>)new MutableObject((Object)VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)axisAlignedBB), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)AxisAlignedBB.func_216363_a((MutableBoundingBox)pieceBoundingBox)), (IBooleanFunction)IBooleanFunction.field_223234_e_)), pieceCenterY + 80, 0);
            assembler.availablePieces.addLast(startPieceEntry);
            while (!assembler.availablePieces.isEmpty()) {
                Entry entry = assembler.availablePieces.removeFirst();
                assembler.processPiece(entry.villagePiece, entry.voxelShape, entry.boundsTop, entry.depth, doBoundaryAdjustments);
            }
        }
    }

    public static final class Entry {
        public final AbstractVillagePiece villagePiece;
        public final MutableObject<VoxelShape> voxelShape;
        public final int boundsTop;
        public final int depth;

        public Entry(AbstractVillagePiece villagePiece, MutableObject<VoxelShape> voxelShape, int boundsTop, int depth) {
            this.villagePiece = villagePiece;
            this.voxelShape = voxelShape;
            this.boundsTop = boundsTop;
            this.depth = depth;
        }
    }

    public static final class Assembler {
        private final Registry<JigsawPattern> patternRegistry;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final TemplateManager templateManager;
        private final List<? super AbstractVillagePiece> structurePieces;
        private final Random rand;
        public final Deque<Entry> availablePieces = Queues.newArrayDeque();
        private final Map<ResourceLocation, Integer> pieceCounts;
        private final int maxY;

        public Assembler(Registry<JigsawPattern> patternRegistry, int maxDepth, ChunkGenerator chunkGenerator, TemplateManager templateManager, List<? super AbstractVillagePiece> structurePieces, Random rand) {
            this.patternRegistry = patternRegistry;
            this.maxDepth = maxDepth;
            this.chunkGenerator = chunkGenerator;
            this.templateManager = templateManager;
            this.structurePieces = structurePieces;
            this.rand = rand;
            this.pieceCounts = new HashMap<ResourceLocation, Integer>();
            this.pieceCounts.put(new ResourceLocation("betterstrongholds", "rooms/grand_library"), (Integer)BSConfig.pieceSettings.grandLibraryMaxCount.get());
            this.pieceCounts.put(new ResourceLocation("betterstrongholds", "rooms/library_md"), (Integer)BSConfig.pieceSettings.smallLibraryMaxCount.get());
            this.pieceCounts.put(new ResourceLocation("betterstrongholds", "rooms/prison_lg"), (Integer)BSConfig.pieceSettings.prisonMaxCount.get());
            this.pieceCounts.put(new ResourceLocation("betterstrongholds", "rooms/cmd_acarii"), (Integer)BSConfig.pieceSettings.cmdAcariiMaxCount.get());
            this.pieceCounts.put(new ResourceLocation("betterstrongholds", "rooms/cmd_yung"), (Integer)BSConfig.pieceSettings.cmdYungMaxCount.get());
            this.pieceCounts.put(new ResourceLocation("betterstrongholds", "rooms/treasure_room_lg"), (Integer)BSConfig.pieceSettings.treasureRoomMaxCount.get());
            this.pieceCounts.put(new ResourceLocation("betterstrongholds", "portal_rooms/portal_room"), (Integer)BSConfig.pieceSettings.portalRoomMaxCount.get());
            this.pieceCounts.put(new ResourceLocation("betterstrongholds", "rooms/armoury_md"), (Integer)BSConfig.pieceSettings.armouryLargeRoomMaxCount.get());
            this.pieceCounts.put(new ResourceLocation("betterstrongholds", "rooms/armoury_sm"), (Integer)BSConfig.pieceSettings.armourySmallRoomMaxCount.get());
            this.maxY = (Integer)BSConfig.general.strongholdMaxY.get();
        }

        public void processPiece(AbstractVillagePiece piece, MutableObject<VoxelShape> voxelShape, int boundsTop, int depth, boolean doBoundaryAdjustments) {
            JigsawPiece pieceBlueprint = piece.func_214826_b();
            BlockPos piecePos = piece.func_214828_c();
            Rotation pieceRotation = piece.func_214809_Y_();
            MutableBoundingBox pieceBoundingBox = piece.func_74874_b();
            int pieceMinY = pieceBoundingBox.field_78895_b;
            MutableObject<VoxelShape> tempNewPieceVoxelShape = new MutableObject<VoxelShape>();
            List pieceJigsawBlocks = pieceBlueprint.func_214849_a(this.templateManager, piecePos, pieceRotation, this.rand);
            for (Template.BlockInfo jigsawBlock : pieceJigsawBlocks) {
                JigsawPiece generatedPiece;
                int targetPieceBoundsTop;
                MutableObject<VoxelShape> pieceVoxelShape;
                Direction direction = JigsawBlock.func_235508_h_((BlockState)jigsawBlock.field_186243_b);
                BlockPos jigsawBlockPos = jigsawBlock.field_186242_a;
                BlockPos jigsawBlockTargetPos = jigsawBlockPos.func_177972_a(direction);
                ResourceLocation jigsawBlockPool = new ResourceLocation(jigsawBlock.field_186244_c.func_74779_i("pool"));
                Optional poolOptional = this.patternRegistry.func_241873_b(jigsawBlockPool);
                if (!poolOptional.isPresent() || ((JigsawPattern)poolOptional.get()).func_214946_c() == 0 && !Objects.equals(jigsawBlockPool, JigsawPatternRegistry.field_244091_a.func_240901_a_())) {
                    BetterStrongholds.LOGGER.warn("Empty or nonexistent pool: {}", (Object)jigsawBlockPool);
                    continue;
                }
                ResourceLocation jigsawBlockFallback = ((JigsawPattern)poolOptional.get()).func_214948_a();
                Optional fallbackOptional = this.patternRegistry.func_241873_b(jigsawBlockFallback);
                if (!fallbackOptional.isPresent() || ((JigsawPattern)fallbackOptional.get()).func_214946_c() == 0 && !Objects.equals(jigsawBlockFallback, JigsawPatternRegistry.field_244091_a.func_240901_a_())) {
                    BetterStrongholds.LOGGER.warn("Empty or nonexistent fallback pool: {}", (Object)jigsawBlockFallback);
                    continue;
                }
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.func_175898_b((Vector3i)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    pieceVoxelShape = tempNewPieceVoxelShape;
                    targetPieceBoundsTop = pieceMinY;
                    if (tempNewPieceVoxelShape.getValue() == null) {
                        tempNewPieceVoxelShape.setValue((Object)VoxelShapes.func_197881_a((AxisAlignedBB)AxisAlignedBB.func_216363_a((MutableBoundingBox)pieceBoundingBox)));
                    }
                } else {
                    pieceVoxelShape = voxelShape;
                    targetPieceBoundsTop = boundsTop;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<JigsawPiece, Integer>>(((JigsawPattern)poolOptional.get()).field_214952_d), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, pieceVoxelShape, piece, depth, targetPieceBoundsTop)) != null) continue;
                this.processList(new ArrayList<Pair<JigsawPiece, Integer>>(((JigsawPattern)fallbackOptional.get()).field_214952_d), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, pieceVoxelShape, piece, depth, targetPieceBoundsTop);
            }
        }

        private JigsawPiece processList(List<Pair<JigsawPiece, Integer>> candidatePieces, boolean doBoundaryAdjustments, Template.BlockInfo jigsawBlock, BlockPos jigsawBlockTargetPos, int pieceMinY, BlockPos jigsawBlockPos, MutableObject<VoxelShape> pieceVoxelShape, AbstractVillagePiece piece, int depth, int targetPieceBoundsTop) {
            JigsawPattern.PlacementBehaviour piecePlacementBehavior = piece.func_214826_b().func_214854_c();
            boolean isPieceRigid = piecePlacementBehavior == JigsawPattern.PlacementBehaviour.RIGID;
            int jigsawBlockRelativeY = jigsawBlockPos.func_177956_o() - pieceMinY;
            int surfaceHeight = -1;
            int totalCount = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0) {
                JigsawPiece candidatePiece;
                Object chosenPiecePair = null;
                if (this.pieceCounts.get(new ResourceLocation("betterstrongholds", "portal_rooms/portal_room")) > 0) {
                    for (int i = 0; i < candidatePieces.size(); ++i) {
                        Pair<JigsawPiece, Integer> candidatePiecePair = candidatePieces.get(i);
                        JigsawPiece jigsawPiece = (JigsawPiece)candidatePiecePair.getFirst();
                        if (!((ResourceLocation)((SingleJigsawPiece)jigsawPiece).field_236839_c_.left().get()).equals((Object)new ResourceLocation("betterstrongholds", "portal_rooms/portal_room"))) continue;
                        if (depth >= this.maxDepth / 2) {
                            chosenPiecePair = candidatePiecePair;
                            break;
                        }
                        totalCount -= ((Integer)candidatePiecePair.getSecond()).intValue();
                        candidatePieces.remove(candidatePiecePair);
                        break;
                    }
                }
                if (chosenPiecePair == null) {
                    int chosenWeight = this.rand.nextInt(totalCount) + 1;
                    for (Pair pair : candidatePieces) {
                        if ((chosenWeight -= ((Integer)pair.getSecond()).intValue()) > 0) continue;
                        chosenPiecePair = pair;
                        break;
                    }
                }
                if ((candidatePiece = (JigsawPiece)chosenPiecePair.getFirst()) == EmptyJigsawPiece.field_214856_a) {
                    return null;
                }
                ResourceLocation pieceName = (ResourceLocation)((SingleJigsawPiece)candidatePiece).field_236839_c_.left().get();
                if (this.pieceCounts.containsKey(pieceName) && this.pieceCounts.get(pieceName) <= 0) {
                    totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                    candidatePieces.remove(chosenPiecePair);
                    continue;
                }
                for (Rotation rotation : Rotation.func_222467_b((Random)this.rand)) {
                    List candidateJigsawBlocks = candidatePiece.func_214849_a(this.templateManager, BlockPos.field_177992_a, rotation, this.rand);
                    MutableBoundingBox tempCandidateBoundingBox = candidatePiece.func_214852_a(this.templateManager, BlockPos.field_177992_a, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.func_78882_c() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.func_175898_b((Vector3i)pieceCandidateJigsawBlock.field_186242_a.func_177972_a(JigsawBlock.func_235508_h_((BlockState)pieceCandidateJigsawBlock.field_186243_b)))) {
                            return 0;
                        }
                        ResourceLocation candidateTargetPool = new ResourceLocation(pieceCandidateJigsawBlock.field_186244_c.func_74779_i("pool"));
                        Optional candidateTargetPoolOptional = this.patternRegistry.func_241873_b(candidateTargetPool);
                        Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(p_242843_1_ -> this.patternRegistry.func_241873_b(p_242843_1_.func_214948_a()));
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(p_242842_1_ -> p_242842_1_.func_214945_a(this.templateManager)).orElse(0);
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(p_242840_1_ -> p_242840_1_.func_214945_a(this.templateManager)).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    for (Template.BlockInfo candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!JigsawBlock.func_220171_a((Template.BlockInfo)jigsawBlock, (Template.BlockInfo)candidateJigsawBlock)) continue;
                        BlockPos candidateJigsawBlockPos = candidateJigsawBlock.field_186242_a;
                        BlockPos candidateJigsawBlockRelativePos = new BlockPos(jigsawBlockTargetPos.func_177958_n() - candidateJigsawBlockPos.func_177958_n(), jigsawBlockTargetPos.func_177956_o() - candidateJigsawBlockPos.func_177956_o(), jigsawBlockTargetPos.func_177952_p() - candidateJigsawBlockPos.func_177952_p());
                        MutableBoundingBox candidateBoundingBox = candidatePiece.func_214852_a(this.templateManager, candidateJigsawBlockRelativePos, rotation);
                        JigsawPattern.PlacementBehaviour candidatePlacementBehavior = candidatePiece.func_214854_c();
                        boolean isCandidateRigid = candidatePlacementBehavior == JigsawPattern.PlacementBehaviour.RIGID;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.func_177956_o();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + JigsawBlock.func_235508_h_((BlockState)jigsawBlock.field_186243_b).func_96559_d();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.func_222532_b(jigsawBlockPos.func_177958_n(), jigsawBlockPos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.field_78895_b;
                        MutableBoundingBox adjustedCandidateBoundingBox = candidateBoundingBox.func_215127_b(0, candidatePieceYOffsetNeeded, 0);
                        BlockPos adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.func_177982_a(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.field_78894_e - adjustedCandidateBoundingBox.field_78895_b);
                            adjustedCandidateBoundingBox.field_78894_e = adjustedCandidateBoundingBox.field_78895_b + k2;
                        }
                        if (adjustedCandidateBoundingBox.field_78894_e > this.maxY || VoxelShapes.func_197879_c((VoxelShape)((VoxelShape)pieceVoxelShape.getValue()), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)AxisAlignedBB.func_216363_a((MutableBoundingBox)adjustedCandidateBoundingBox).func_186664_h(0.25)), (IBooleanFunction)IBooleanFunction.field_223232_c_)) continue;
                        pieceVoxelShape.setValue((Object)VoxelShapes.func_197882_b((VoxelShape)((VoxelShape)pieceVoxelShape.getValue()), (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)AxisAlignedBB.func_216363_a((MutableBoundingBox)adjustedCandidateBoundingBox)), (IBooleanFunction)IBooleanFunction.field_223234_e_));
                        int newPieceGroundLevelDelta = piece.func_214830_d();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.func_214850_d();
                        AbstractVillagePiece newPiece = new AbstractVillagePiece(this.templateManager, candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.func_222532_b(jigsawBlockPos.func_177958_n(), jigsawBlockPos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.func_214831_a(new JigsawJunction(jigsawBlockTargetPos.func_177958_n(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.func_177952_p(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.func_214831_a(new JigsawJunction(jigsawBlockPos.func_177958_n(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.func_177952_p(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.structurePieces.add((AbstractVillagePiece)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.availablePieces.addLast(new Entry(newPiece, pieceVoxelShape, targetPieceBoundsTop, depth + 1));
                        }
                        if (this.pieceCounts.containsKey(pieceName)) {
                            this.pieceCounts.put(pieceName, this.pieceCounts.get(pieceName) - 1);
                        }
                        return candidatePiece;
                    }
                }
                totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }
}

