/*
 * Decompiled with CFR 0.152.
 */
package com.vanyabaou.betterspartanarchery;

import com.google.common.collect.Lists;
import com.vanyabaou.betterspartanarchery.Utils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class BSAConfig {
    public static final ForgeConfigSpec.Builder SERVER_CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec serverSpec;
    public static final Predicate<Object> sp;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> longbowSpartanWeaponry;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> crossbowSpartanWeaponry;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> customEntries;
    public static ForgeConfigSpec.BooleanValue bonusIsFlat;

    protected static boolean badEntry(Object obj) {
        Utils.LOGGER.warn("Invalid Config Entry: '{}'", obj);
        return false;
    }

    private BSAConfig() {
    }

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register(BSAConfig.class);
        BSAConfig.genServerConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec, "betterspartanarchery-server.toml");
    }

    private static void genServerConfig() {
        BSAConfig.genMaterialConfig();
        serverSpec = SERVER_CONFIG.build();
    }

    private static void genMaterialConfig() {
        SERVER_CONFIG.push("Other Settings");
        bonusIsFlat = SERVER_CONFIG.comment("False for Multiplicative, I don't know why you would want Flat but here it is").define("Bonus is Flat", false);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Spartan Weaponry");
        longbowSpartanWeaponry = SERVER_CONFIG.comment("Set to 0 for no bonus").defineList("Longbows", (List)Lists.newArrayList((Object[])new String[]{"wood*0", "leather*0", "iron*2", "gold*0", "diamond*3", "netherite*4", "copper*1.5", "tin*1.75", "bronze*2", "steel*2.5", "silver*1.5", "invar*2.2", "platinum*3.5", "electrum*2", "nickel*2", "lead*2"}), sp);
        crossbowSpartanWeaponry = SERVER_CONFIG.comment("Set to 0 for no bonus").defineList("Heavy Crossbows", (List)Lists.newArrayList((Object[])new String[]{"wood*0", "leather*0", "iron*2", "gold*0", "diamond*3", "netherite*4", "copper*1.5", "tin*1.75", "bronze*2", "steel*2.5", "silver*1.5", "invar*2.2", "platinum*3.5", "electrum*2", "nickel*2", "lead*2"}), sp);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Custom Entries");
        customEntries = SERVER_CONFIG.comment("'material*amount'").defineList("Custom Longbows/Crossbows", (List)Lists.newArrayList((Object[])new String[]{"ironwood*2", "fiery*4", "steeleaf*3", "knightly*3"}), sp);
        SERVER_CONFIG.pop();
    }

    static {
        sp = str -> {
            double mult;
            if (!(str instanceof String) || !((String)str).contains("*") || ((String)str).substring(((String)str).indexOf("*") + 1).equals("")) {
                return BSAConfig.badEntry(str);
            }
            String value = ((String)str).substring(((String)str).indexOf("*") + 1);
            try {
                mult = Double.parseDouble(value);
            }
            catch (Exception e) {
                return BSAConfig.badEntry(str);
            }
            return mult != 0.0;
        };
    }
}

