/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.tile.fusion;

import igentuman.bfr.common.BfrLang;
import igentuman.bfr.common.base.IReactorLogic;
import igentuman.bfr.common.base.IReactorLogicMode;
import igentuman.bfr.common.content.fusion.FusionReactorMultiblockData;
import igentuman.bfr.common.registries.BfrBlocks;
import igentuman.bfr.common.tile.fusion.TileEntityFusionReactorBlock;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TileEntityFusionReactorLogicAdapter
extends TileEntityFusionReactorBlock
implements IReactorLogic<FusionReactorLogic>,
IHasMode {
    public FusionReactorLogic logicType = FusionReactorLogic.READY;
    private boolean activeCooled;
    protected int prevRedstoneLevel;
    protected ArrayList<FusionReactorLogic> inLogicModes;
    protected ArrayList<FusionReactorLogic> outLogicModes;

    public TileEntityFusionReactorLogicAdapter() {
        super((IBlockProvider)BfrBlocks.FUSION_REACTOR_LOGIC_ADAPTER);
    }

    protected boolean onUpdateServer(FusionReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        int redstone = this.getRedstoneLevel();
        if (redstone != this.prevRedstoneLevel) {
            World world = this.func_145831_w();
            if (world != null) {
                world.func_195593_d(this.func_174877_v(), this.getBlockType());
            }
            this.prevRedstoneLevel = redstone;
        }
        return needsPacket;
    }

    public void onPowerChange() {
        if (this.isPowered() && !this.wasPowered()) {
            int power = this.getTileWorld().func_175687_A(this.func_174877_v());
            FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
            if (multiblock == null || !((FusionReactorMultiblockData)this.getMultiblock()).isFormed()) {
                return;
            }
            switch (this.logicType) {
                case INJECTION_DOWN: {
                    multiblock.setInjectionRate(multiblock.getInjectionRate() - 2);
                    break;
                }
                case INJECTION_UP: {
                    multiblock.setInjectionRate(multiblock.getInjectionRate() + 2);
                    break;
                }
                case REACTIVITY_UP: {
                    multiblock.adjustReactivity(power);
                    break;
                }
                case REACTIVITY_DOWN: {
                    multiblock.adjustReactivity(-power);
                    break;
                }
                default: {
                    return;
                }
            }
            this.markDirty(false);
        }
    }

    public int getRedstoneLevel() {
        if (this.isRemote()) {
            return this.prevRedstoneLevel;
        }
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
        if (multiblock == null || !((FusionReactorMultiblockData)this.getMultiblock()).isFormed()) {
            return 0;
        }
        switch (this.logicType) {
            case READY: {
                return multiblock.getLastPlasmaTemp() >= multiblock.getIgnitionTemperature(this.activeCooled) ? 15 : 0;
            }
            case CAPACITY: {
                return multiblock.getLastPlasmaTemp() >= multiblock.getMaxPlasmaTemperature(this.activeCooled) ? 15 : 0;
            }
            case ERROR_LEVEL: {
                return (int)(multiblock.getErrorLevel() / 6.0f);
            }
            case EFFICIENCY: {
                return (int)(multiblock.getEfficiency() / 6.0f);
            }
            case DEPLETED: {
                return multiblock.deuteriumTank.getStored() < (long)(multiblock.getInjectionRate() / 2) || multiblock.tritiumTank.getStored() < (long)(multiblock.getInjectionRate() / 2) ? 15 : 0;
            }
        }
        return 0;
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        NBTUtils.setEnumIfPresent((CompoundNBT)nbtTags, (String)"logicType", FusionReactorLogic::byIndexStatic, logicType -> {
            this.logicType = logicType;
        });
        this.activeCooled = nbtTags.func_74767_n("activeCooled");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("logicType", this.logicType.getId());
        nbtTags.func_74757_a("activeCooled", this.activeCooled);
        return nbtTags;
    }

    @Override
    public boolean canBeMaster() {
        return false;
    }

    public void nextMode() {
        this.activeCooled = !this.activeCooled;
        this.markDirty(false);
    }

    @ComputerMethod(nameOverride="isActiveCooledLogic")
    public boolean isActiveCooled() {
        return this.activeCooled;
    }

    @Override
    @ComputerMethod(nameOverride="getLogicMode")
    public FusionReactorLogic getMode() {
        return this.logicType;
    }

    public FusionReactorLogic[] getModes() {
        return FusionReactorLogic.values();
    }

    public FusionReactorLogic[] getInputModes() {
        if (this.inLogicModes == null) {
            this.inLogicModes = new ArrayList();
            for (int i = 0; i < FusionReactorLogic.values().length; ++i) {
                if (!Objects.equals(FusionReactorLogic.byIndexStatic(i).direction, "in")) continue;
                this.inLogicModes.add(FusionReactorLogic.values()[i]);
            }
        }
        return this.inLogicModes.toArray(new FusionReactorLogic[0]);
    }

    public FusionReactorLogic[] getOutputModes() {
        if (this.outLogicModes == null) {
            this.outLogicModes = new ArrayList();
            for (int i = 0; i < FusionReactorLogic.values().length; ++i) {
                if (!Objects.equals(FusionReactorLogic.byIndexStatic(i).direction, "out")) continue;
                this.outLogicModes.add(FusionReactorLogic.values()[i]);
            }
        }
        return this.outLogicModes.toArray(new FusionReactorLogic[0]);
    }

    @ComputerMethod(nameOverride="setLogicMode")
    public void setLogicTypeFromPacket(FusionReactorLogic logicType) {
        if (this.logicType != logicType) {
            this.logicType = logicType;
            this.markDirty(false);
        }
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(FusionReactorLogic::byIndexStatic, (Enum)FusionReactorLogic.READY, this::getMode, value -> {
            this.logicType = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isActiveCooled, value -> {
            this.activeCooled = value;
        }));
        container.track((ISyncableData)SyncableInt.create(() -> this.prevRedstoneLevel, value -> {
            this.prevRedstoneLevel = value;
        }));
    }

    @ComputerMethod
    private void setActiveCooledLogic(boolean active) {
        if (this.activeCooled != active) {
            this.nextMode();
        }
    }

    public static enum FusionReactorLogic implements IReactorLogicMode<FusionReactorLogic>,
    IHasTranslationKey
    {
        READY(0, BfrLang.REACTOR_LOGIC_READY, BfrLang.DESCRIPTION_REACTOR_READY, new ItemStack((IItemProvider)Items.field_151137_ax), "out"),
        CAPACITY(1, BfrLang.REACTOR_LOGIC_CAPACITY, BfrLang.DESCRIPTION_REACTOR_CAPACITY, new ItemStack((IItemProvider)Items.field_151137_ax), "out"),
        DEPLETED(2, BfrLang.REACTOR_LOGIC_DEPLETED, BfrLang.DESCRIPTION_REACTOR_DEPLETED, new ItemStack((IItemProvider)Items.field_151137_ax), "out"),
        EFFICIENCY(3, BfrLang.REACTOR_LOGIC_EFFICIENCY, BfrLang.DESCRIPTION_REACTOR_EFFICIENCY, new ItemStack((IItemProvider)Items.field_151137_ax), "out"),
        ERROR_LEVEL(4, BfrLang.REACTOR_LOGIC_ERROR_LEVEL, BfrLang.DESCRIPTION_REACTOR_ERROR_LEVEL, new ItemStack((IItemProvider)Items.field_151137_ax), "out"),
        INJECTION_UP(5, BfrLang.REACTOR_LOGIC_INJECTION_UP, BfrLang.DESCRIPTION_REACTOR_INJECTION_UP, new ItemStack((IItemProvider)Items.field_151137_ax), "in"),
        INJECTION_DOWN(6, BfrLang.REACTOR_LOGIC_INJECTION_DOWN, BfrLang.DESCRIPTION_REACTOR_INJECTION_DOWN, new ItemStack((IItemProvider)Items.field_151137_ax), "in"),
        REACTIVITY_UP(7, BfrLang.REACTOR_LOGIC_REACTIVITY_UP, BfrLang.DESCRIPTION_REACTOR_REACTIVITY_UP, new ItemStack((IItemProvider)Items.field_151137_ax), "in"),
        REACTIVITY_DOWN(8, BfrLang.REACTOR_LOGIC_REACTIVITY_DOWN, BfrLang.DESCRIPTION_REACTOR_REACTIVITY_DOWN, new ItemStack((IItemProvider)Items.field_151137_ax), "in");

        private static final FusionReactorLogic[] MODES;
        private final int id;
        private final ILangEntry name;
        private final ILangEntry description;
        private final ItemStack renderStack;
        private final String direction;

        private FusionReactorLogic(int id, ILangEntry name, ILangEntry description, ItemStack stack, String dir) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.renderStack = stack;
            this.direction = dir;
        }

        @Override
        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        @Override
        public ITextComponent getDescription() {
            return this.description.translate(new Object[0]);
        }

        @Override
        public EnumColor getColor() {
            return EnumColor.RED;
        }

        @Override
        public int getId() {
            return this.id;
        }

        public static FusionReactorLogic byIndexStatic(int index) {
            return (FusionReactorLogic)MathUtils.getByIndexMod((Object[])MODES, (int)index);
        }

        static {
            MODES = FusionReactorLogic.values();
        }
    }
}

