/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.tile.fusion;

import igentuman.bfr.common.BetterFusionReactor;
import igentuman.bfr.common.content.fusion.FusionReactorMultiblockData;
import igentuman.bfr.common.registries.BfrBlocks;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.dynamic.SyncMapper;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.tile.prefab.TileEntityMultiblock;

public class TileEntityFusionReactorBlock
extends TileEntityMultiblock<FusionReactorMultiblockData> {
    public TileEntityFusionReactorBlock() {
        this((IBlockProvider)BfrBlocks.FUSION_REACTOR_FRAME);
    }

    public TileEntityFusionReactorBlock(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    public FusionReactorMultiblockData createMultiblock() {
        return new FusionReactorMultiblockData(this);
    }

    public MultiblockManager<FusionReactorMultiblockData> getManager() {
        return BetterFusionReactor.fusionReactorManager;
    }

    public boolean canBeMaster() {
        return false;
    }

    public void setInjectionRateFromPacket(int rate) {
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            multiblock.setInjectionRate(Math.min(98, Math.max(0, rate - rate % 2)));
            this.markDirty(false);
        }
    }

    public void adjustReactivityFromPacket(float val) {
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed() && multiblock.isBurning()) {
            multiblock.adjustReactivity(val);
            this.markDirty(false);
        }
    }

    public void addFuelTabContainerTrackers(MekanismContainer container) {
        SyncMapper.INSTANCE.setup(container, FusionReactorMultiblockData.class, () -> ((TileEntityFusionReactorBlock)this).getMultiblock(), "fuel");
    }

    public void addHeatTabContainerTrackers(MekanismContainer container) {
        SyncMapper.INSTANCE.setup(container, FusionReactorMultiblockData.class, () -> ((TileEntityFusionReactorBlock)this).getMultiblock(), "heat");
    }
}

