/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.network.to_server;

import igentuman.bfr.common.tile.fusion.TileEntityFusionReactorBlock;
import igentuman.bfr.common.tile.fusion.TileEntityFusionReactorController;
import igentuman.bfr.common.tile.fusion.TileEntityFusionReactorLogicAdapter;
import mekanism.api.functions.TriConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketBfrGuiInteract
implements IMekanismPacket {
    private final BfrGuiInteraction interaction;
    private final BlockPos tilePosition;
    private final double extra;

    public PacketBfrGuiInteract(BfrGuiInteraction interaction, TileEntity tile) {
        this(interaction, tile.func_174877_v());
    }

    public PacketBfrGuiInteract(BfrGuiInteraction interaction, TileEntity tile, double extra) {
        this(interaction, tile.func_174877_v(), extra);
    }

    public PacketBfrGuiInteract(BfrGuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0.0);
    }

    public PacketBfrGuiInteract(BfrGuiInteraction interaction, BlockPos tilePosition, double extra) {
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public void handle(NetworkEvent.Context context) {
        TileEntityMekanism tile;
        ServerPlayerEntity player = context.getSender();
        if (player != null && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, (BlockPos)this.tilePosition)) != null) {
            this.interaction.consume(tile, (PlayerEntity)player, this.extra);
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.interaction);
        buffer.func_179255_a(this.tilePosition);
        buffer.writeDouble(this.extra);
    }

    public static PacketBfrGuiInteract decode(PacketBuffer buffer) {
        return new PacketBfrGuiInteract((BfrGuiInteraction)buffer.func_179257_a(BfrGuiInteraction.class), buffer.func_179259_c(), buffer.readDouble());
    }

    public static enum BfrGuiInteraction {
        INJECTION_RATE((TriConsumer<TileEntityMekanism, PlayerEntity, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFusionReactorBlock) {
                ((TileEntityFusionReactorController)((Object)tile)).setInjectionRateFromPacket((int)Math.round(extra));
            }
        })),
        LOGIC_TYPE((TriConsumer<TileEntityMekanism, PlayerEntity, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFusionReactorLogicAdapter) {
                ((TileEntityFusionReactorLogicAdapter)tile).setLogicTypeFromPacket(TileEntityFusionReactorLogicAdapter.FusionReactorLogic.byIndexStatic((int)Math.round(extra)));
            }
        })),
        REACTIVITY_UP((TriConsumer<TileEntityMekanism, PlayerEntity, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFusionReactorBlock) {
                ((TileEntityFusionReactorBlock)((Object)tile)).adjustReactivityFromPacket(5.0f);
            }
        })),
        REACTIVITY_DOWN((TriConsumer<TileEntityMekanism, PlayerEntity, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFusionReactorBlock) {
                ((TileEntityFusionReactorBlock)((Object)tile)).adjustReactivityFromPacket(-5.0f);
            }
        }));

        private final TriConsumer<TileEntityMekanism, PlayerEntity, Double> consumerForTile;

        private BfrGuiInteraction(TriConsumer<TileEntityMekanism, PlayerEntity, Double> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, PlayerEntity player, double extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }
    }
}

