/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.network.to_server;

import igentuman.bfr.common.BfrLang;
import igentuman.bfr.common.registries.BfrContainerTypes;
import igentuman.bfr.common.tile.fusion.TileEntityFusionReactorController;
import igentuman.bfr.common.tile.fusion.TileEntityFusionReactorLogicAdapter;
import java.util.function.BiFunction;
import mekanism.api.text.ILangEntry;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class PacketBfrGuiButtonPress
implements IMekanismPacket {
    private final ClickedGeneratorsTileButton tileButton;
    private final int extra;
    private final BlockPos tilePosition;

    public PacketBfrGuiButtonPress(ClickedGeneratorsTileButton buttonClicked, BlockPos tilePosition) {
        this(buttonClicked, tilePosition, 0);
    }

    public PacketBfrGuiButtonPress(ClickedGeneratorsTileButton buttonClicked, BlockPos tilePosition, int extra) {
        this.tileButton = buttonClicked;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public void handle(NetworkEvent.Context context) {
        INamedContainerProvider provider;
        TileEntityMekanism tile;
        ServerPlayerEntity player = context.getSender();
        if (player != null && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, (BlockPos)this.tilePosition)) != null && (provider = this.tileButton.getProvider(tile, this.extra)) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)provider, buf -> {
                buf.func_179255_a(this.tilePosition);
                buf.func_150787_b(this.extra);
            });
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.tileButton);
        buffer.func_179255_a(this.tilePosition);
        buffer.func_150787_b(this.extra);
    }

    public static PacketBfrGuiButtonPress decode(PacketBuffer buffer) {
        return new PacketBfrGuiButtonPress((ClickedGeneratorsTileButton)buffer.func_179257_a(ClickedGeneratorsTileButton.class), buffer.func_179259_c(), buffer.func_150792_a());
    }

    public static enum ClickedGeneratorsTileButton {
        TAB_HEAT((tile, extra) -> BfrContainerTypes.FUSION_REACTOR_HEAT.getProvider((ILangEntry)BfrLang.HEAT_TAB, tile)),
        TAB_FUEL((tile, extra) -> BfrContainerTypes.FUSION_REACTOR_FUEL.getProvider((ILangEntry)BfrLang.FUEL_TAB, tile)),
        TAB_EFFICIENCY((tile, extra) -> {
            if (tile instanceof TileEntityFusionReactorController) {
                return BfrContainerTypes.FUSION_REACTOR_EFFICIENCY.getProvider((ILangEntry)BfrLang.EFFICIENCY_TAB, tile);
            }
            return null;
        }),
        TAB_STATS((tile, extra) -> {
            if (tile instanceof TileEntityFusionReactorController) {
                return BfrContainerTypes.FUSION_REACTOR_STATS.getProvider((ILangEntry)BfrLang.STATS_TAB, tile);
            }
            return null;
        }),
        TAB_LOGIC_GENERAL((tile, extra) -> {
            if (tile instanceof TileEntityFusionReactorLogicAdapter) {
                return BfrContainerTypes.FUSION_REACTOR_LOGIC_GENERAL.getProvider((ILangEntry)BfrLang.LOGIC_GENERAL_TAB, tile);
            }
            return null;
        }),
        TAB_LOGIC_INPUT((tile, extra) -> {
            if (tile instanceof TileEntityFusionReactorLogicAdapter) {
                return BfrContainerTypes.FUSION_REACTOR_LOGIC_IN.getProvider((ILangEntry)BfrLang.LOGIC_IN_TAB, tile);
            }
            return null;
        }),
        TAB_LOGIC_OUTPUT((tile, extra) -> {
            if (tile instanceof TileEntityFusionReactorLogicAdapter) {
                return BfrContainerTypes.FUSION_REACTOR_LOGIC_OUT.getProvider((ILangEntry)BfrLang.LOGIC_OUT_TAB, tile);
            }
            return null;
        });

        private final BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile;

        private ClickedGeneratorsTileButton(BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile) {
            this.providerFromTile = providerFromTile;
        }

        public INamedContainerProvider getProvider(TileEntityMekanism tile, int extra) {
            return this.providerFromTile.apply(tile, extra);
        }
    }
}

