/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen.tag;

import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeRegistryTagBuilder<TYPE extends IForgeRegistryEntry<TYPE>> {
    private final ITag.Builder builder;
    private final String modID;

    public ForgeRegistryTagBuilder(ITag.Builder builder, String modID) {
        this.builder = builder;
        this.modID = modID;
    }

    public ForgeRegistryTagBuilder<TYPE> add(TYPE element) {
        this.builder.func_232961_a_(element.getRegistryName(), this.modID);
        return this;
    }

    @SafeVarargs
    public final ForgeRegistryTagBuilder<TYPE> add(TYPE ... elements) {
        for (TYPE element : elements) {
            this.add(element);
        }
        return this;
    }

    public ForgeRegistryTagBuilder<TYPE> add(ITag.INamedTag<TYPE> tag) {
        this.builder.func_232964_b_(tag.func_230234_a_(), this.modID);
        return this;
    }

    @SafeVarargs
    public final ForgeRegistryTagBuilder<TYPE> add(ITag.INamedTag<TYPE> ... tags) {
        for (ITag.INamedTag<TYPE> tag : tags) {
            this.add(tag);
        }
        return this;
    }

    public ForgeRegistryTagBuilder<TYPE> add(ITag.ITagEntry tag) {
        this.builder.func_232955_a_(tag, this.modID);
        return this;
    }

    @SafeVarargs
    public final ForgeRegistryTagBuilder<TYPE> add(RegistryKey<TYPE> ... keys) {
        for (RegistryKey<TYPE> key : keys) {
            this.builder.func_232961_a_(key.func_240901_a_(), this.modID);
        }
        return this;
    }

    public ForgeRegistryTagBuilder<TYPE> replace() {
        return this.replace(true);
    }

    public ForgeRegistryTagBuilder<TYPE> replace(boolean value) {
        this.builder.replace(value);
        return this;
    }

    public ForgeRegistryTagBuilder<TYPE> addOptional(ResourceLocation ... locations) {
        for (ResourceLocation location : locations) {
            this.add((ITag.ITagEntry)new ITag.OptionalItemEntry(location));
        }
        return this;
    }

    public ForgeRegistryTagBuilder<TYPE> addOptionalTag(ResourceLocation ... locations) {
        for (ResourceLocation location : locations) {
            this.add((ITag.ITagEntry)new ITag.OptionalTagEntry(location));
        }
        return this;
    }
}

