/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen.tag;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import igentuman.bfr.common.datagen.tag.ForgeRegistryTagBuilder;
import igentuman.bfr.common.datagen.tag.TagType;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.providers.IEntityTypeProvider;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeRegistryTagsProvider;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class BaseTagProvider
implements IDataProvider {
    private final Map<TagType<?>, Map<ITag.INamedTag<?>, ITag.Builder>> supportedTagTypes = new Object2ObjectLinkedOpenHashMap();
    private final ExistingFileHelper existingFileHelper;
    private final DataGenerator gen;
    private final String modid;

    protected BaseTagProvider(DataGenerator gen, String modid, @Nullable ExistingFileHelper existingFileHelper) {
        this.gen = gen;
        this.modid = modid;
        this.existingFileHelper = existingFileHelper;
        this.addTagType(TagType.BLOCK);
        this.addTagType(TagType.ENTITY_TYPE);
        this.addTagType(TagType.TILE_ENTITY_TYPE);
    }

    @Nonnull
    public String func_200397_b() {
        return "Tags: " + this.modid;
    }

    protected <TYPE extends IForgeRegistryEntry<TYPE>> void addTagType(TagType<TYPE> tagType) {
        this.supportedTagTypes.computeIfAbsent(tagType, type -> new Object2ObjectLinkedOpenHashMap());
    }

    protected abstract void registerTags();

    public void func_200398_a(@Nonnull DirectoryCache cache) {
        this.supportedTagTypes.values().forEach(Map::clear);
        this.registerTags();
        this.supportedTagTypes.forEach((tagType, tagTypeMap) -> this.act(cache, (TagType)tagType, (Map<ITag.INamedTag<?>, ITag.Builder>)tagTypeMap));
    }

    private <TYPE extends IForgeRegistryEntry<TYPE>> void act(@Nonnull DirectoryCache cache, final TagType<TYPE> tagType, final Map<ITag.INamedTag<?>, ITag.Builder> tagTypeMap) {
        if (!tagTypeMap.isEmpty()) {
            new ForgeRegistryTagsProvider<TYPE>(this.gen, tagType.getRegistry(), this.modid, this.existingFileHelper){

                protected void func_200432_c() {
                    tagTypeMap.forEach((tag, tagBuilder) -> {
                        ITag.Builder cfr_ignored_0 = this.field_200434_b.put(tag.func_230234_a_(), new ITag.Builder((ITag.Builder)tagBuilder){
                            final /* synthetic */ ITag.Builder val$tagBuilder;
                            {
                                this.val$tagBuilder = builder;
                            }

                            @Nonnull
                            public JsonObject func_232965_c_() {
                                return BaseTagProvider.this.cleanJsonTag(this.val$tagBuilder.func_232965_c_());
                            }

                            @Nonnull
                            public <T> Stream<ITag.Proxy> func_232963_b_(@Nonnull Function<ResourceLocation, ITag<T>> resourceTagFunction, @Nonnull Function<ResourceLocation, T> resourceElementFunction) {
                                return this.val$tagBuilder.func_232963_b_(resourceTagFunction, resourceElementFunction);
                            }
                        });
                    });
                }

                @Nonnull
                public String func_200397_b() {
                    return tagType.getName() + " Tags: " + BaseTagProvider.this.modid;
                }
            }.func_200398_a(cache);
        }
    }

    private JsonObject cleanJsonTag(JsonObject tagAsJson) {
        JsonPrimitive replace;
        if (tagAsJson.has("replace") && (replace = tagAsJson.getAsJsonPrimitive("replace")).isBoolean() && !replace.getAsBoolean()) {
            tagAsJson.remove("replace");
        }
        return tagAsJson;
    }

    protected <TYPE extends IForgeRegistryEntry<TYPE>> ForgeRegistryTagBuilder<TYPE> getBuilder(TagType<TYPE> tagType, ITag.INamedTag<TYPE> tag) {
        return new ForgeRegistryTagBuilder(this.supportedTagTypes.get(tagType).computeIfAbsent(tag, ignored -> ITag.Builder.func_200047_a()), this.modid);
    }

    protected ForgeRegistryTagBuilder<Item> getItemBuilder(ITag.INamedTag<Item> tag) {
        return this.getBuilder(TagType.ITEM, tag);
    }

    protected ForgeRegistryTagBuilder<Block> getBlockBuilder(ITag.INamedTag<Block> tag) {
        return this.getBuilder(TagType.BLOCK, tag);
    }

    protected ForgeRegistryTagBuilder<EntityType<?>> getEntityTypeBuilder(ITag.INamedTag<EntityType<?>> tag) {
        return this.getBuilder(TagType.ENTITY_TYPE, tag);
    }

    protected ForgeRegistryTagBuilder<TileEntityType<?>> getTileEntityTypeBuilder(ITag.INamedTag<TileEntityType<?>> tag) {
        return this.getBuilder(TagType.TILE_ENTITY_TYPE, tag);
    }

    protected void addToTag(ITag.INamedTag<Item> tag, IItemProvider ... itemProviders) {
        ForgeRegistryTagBuilder<Item> tagBuilder = this.getItemBuilder(tag);
        for (IItemProvider itemProvider : itemProviders) {
            tagBuilder.add(itemProvider.func_199767_j());
        }
    }

    protected void addToTag(ITag.INamedTag<Block> tag, IBlockProvider ... blockProviders) {
        ForgeRegistryTagBuilder<Block> tagBuilder = this.getBlockBuilder(tag);
        for (IBlockProvider blockProvider : blockProviders) {
            tagBuilder.add(blockProvider.getBlock());
        }
    }

    protected void addToTags(ITag.INamedTag<Item> itemTag, ITag.INamedTag<Block> blockTag, IBlockProvider ... blockProviders) {
        ForgeRegistryTagBuilder<Item> itemTagBuilder = this.getItemBuilder(itemTag);
        ForgeRegistryTagBuilder<Block> blockTagBuilder = this.getBlockBuilder(blockTag);
        for (IBlockProvider blockProvider : blockProviders) {
            itemTagBuilder.add(blockProvider.getItem());
            blockTagBuilder.add(blockProvider.getBlock());
        }
    }

    protected void addToTag(ITag.INamedTag<EntityType<?>> tag, IEntityTypeProvider ... entityTypeProviders) {
        ForgeRegistryTagBuilder<EntityType<?>> tagBuilder = this.getEntityTypeBuilder(tag);
        for (IEntityTypeProvider entityTypeProvider : entityTypeProviders) {
            tagBuilder.add(entityTypeProvider.getEntityType());
        }
    }

    protected void addToTag(ITag.INamedTag<TileEntityType<?>> tag, TileEntityTypeRegistryObject<?> ... tileEntityTypeRegistryObjects) {
        ForgeRegistryTagBuilder<TileEntityType<?>> tagBuilder = this.getTileEntityTypeBuilder(tag);
        for (TileEntityTypeRegistryObject<?> tileEntityTypeRO : tileEntityTypeRegistryObjects) {
            tagBuilder.add((TileEntityType<?>)tileEntityTypeRO.get());
        }
    }

    @SafeVarargs
    protected final <CHEMICAL extends Chemical<CHEMICAL>> void addToTag(ForgeRegistryTagBuilder<CHEMICAL> tagBuilder, IChemicalProvider<CHEMICAL> ... providers) {
        for (IChemicalProvider<CHEMICAL> provider : providers) {
            tagBuilder.add((CHEMICAL)provider.getChemical());
        }
    }
}

