/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.bfr.common.datagen.recipe.builder.BaseRecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ExtendedShapelessRecipeBuilder
extends BaseRecipeBuilder<ExtendedShapelessRecipeBuilder> {
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

    private ExtendedShapelessRecipeBuilder(IItemProvider result, int count) {
        super(IRecipeSerializer.field_222158_b, result, count);
    }

    public static ExtendedShapelessRecipeBuilder shapelessRecipe(IItemProvider result) {
        return ExtendedShapelessRecipeBuilder.shapelessRecipe(result, 1);
    }

    public static ExtendedShapelessRecipeBuilder shapelessRecipe(IItemProvider result, int count) {
        return new ExtendedShapelessRecipeBuilder(result, count);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(ITag<Item> tag) {
        return this.addIngredient(tag, 1);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(ITag<Item> tag, int quantity) {
        return this.addIngredient(Ingredient.func_199805_a(tag), quantity);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(IItemProvider item) {
        return this.addIngredient(item, 1);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(IItemProvider item, int quantity) {
        return this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), quantity);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("Shapeless recipe '" + id + "' must have at least one ingredient!");
        }
    }

    protected MekanismRecipeBuilder.RecipeResult getResult(ResourceLocation id) {
        return new Result(id);
    }

    public class Result
    extends BaseRecipeBuilder.BaseRecipeResult {
        public Result(ResourceLocation id) {
            super(id);
        }

        @Override
        public void func_218610_a(JsonObject json) {
            super.func_218610_a(json);
            JsonArray jsonIngredients = new JsonArray();
            for (Ingredient ingredient : ExtendedShapelessRecipeBuilder.this.ingredients) {
                jsonIngredients.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)jsonIngredients);
        }
    }
}

