/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.bfr.common.datagen.recipe.builder.BaseRecipeBuilder;
import igentuman.bfr.common.datagen.recipe.pattern.RecipePattern;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ExtendedShapedRecipeBuilder
extends BaseRecipeBuilder<ExtendedShapedRecipeBuilder> {
    private final Char2ObjectMap<Ingredient> key = new Char2ObjectArrayMap(9);
    private final List<String> pattern = new ArrayList<String>();

    protected ExtendedShapedRecipeBuilder(IRecipeSerializer<?> serializer, IItemProvider result, int count) {
        super(serializer, result, count);
    }

    private ExtendedShapedRecipeBuilder(IItemProvider result, int count) {
        this(IRecipeSerializer.field_222157_a, result, count);
    }

    public static ExtendedShapedRecipeBuilder shapedRecipe(IItemProvider result) {
        return ExtendedShapedRecipeBuilder.shapedRecipe(result, 1);
    }

    public static ExtendedShapedRecipeBuilder shapedRecipe(IItemProvider result, int count) {
        return new ExtendedShapedRecipeBuilder(result, count);
    }

    public ExtendedShapedRecipeBuilder pattern(RecipePattern pattern) {
        if (!this.pattern.isEmpty()) {
            throw new IllegalArgumentException("Recipe pattern has already been set!");
        }
        this.pattern.add(pattern.row1);
        if (pattern.row2 != null) {
            this.pattern.add(pattern.row2);
            if (pattern.row3 != null) {
                this.pattern.add(pattern.row3);
            }
        }
        return this;
    }

    public ExtendedShapedRecipeBuilder key(char symbol, ITag<Item> tag) {
        return this.key(symbol, Ingredient.func_199805_a(tag));
    }

    public ExtendedShapedRecipeBuilder key(char symbol, IItemProvider item) {
        return this.key(symbol, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    public ExtendedShapedRecipeBuilder key(char symbol, Ingredient ingredient) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, (Object)ingredient);
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        CharOpenHashSet set = new CharOpenHashSet((CharCollection)this.key.keySet());
        set.remove(' ');
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (!this.key.containsKey(c) && c != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c + "'");
                }
                set.remove(c);
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item, and should probably be a shapeless recipe instead");
        }
    }

    protected MekanismRecipeBuilder.RecipeResult getResult(ResourceLocation id) {
        return new Result(id);
    }

    public class Result
    extends BaseRecipeBuilder.BaseRecipeResult {
        protected Result(ResourceLocation id) {
            super(id);
        }

        @Override
        public void func_218610_a(JsonObject json) {
            super.func_218610_a(json);
            JsonArray jsonPattern = new JsonArray();
            for (String s : ExtendedShapedRecipeBuilder.this.pattern) {
                jsonPattern.add(s);
            }
            json.add("pattern", (JsonElement)jsonPattern);
            JsonObject jsonobject = new JsonObject();
            for (Char2ObjectMap.Entry entry : ExtendedShapedRecipeBuilder.this.key.char2ObjectEntrySet()) {
                jsonobject.add(String.valueOf(entry.getCharKey()), ((Ingredient)entry.getValue()).func_200304_c());
            }
            json.add("key", (JsonElement)jsonobject);
        }
    }
}

