/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen.recipe.builder;

import com.google.gson.JsonObject;
import igentuman.bfr.common.datagen.recipe.builder.BaseRecipeBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ExtendedCookingRecipeBuilder
extends BaseRecipeBuilder<ExtendedCookingRecipeBuilder> {
    private final Ingredient ingredient;
    private final int cookingTime;
    private float experience;

    private ExtendedCookingRecipeBuilder(CookingRecipeSerializer<?> serializer, IItemProvider result, int count, Ingredient ingredient, int cookingTime) {
        super((IRecipeSerializer<?>)serializer, result, count);
        this.ingredient = ingredient;
        this.cookingTime = cookingTime;
    }

    public static ExtendedCookingRecipeBuilder blasting(IItemProvider result, Ingredient ingredient, int cookingTime) {
        return ExtendedCookingRecipeBuilder.blasting(result, 1, ingredient, cookingTime);
    }

    public static ExtendedCookingRecipeBuilder blasting(IItemProvider result, int count, Ingredient ingredient, int cookingTime) {
        return new ExtendedCookingRecipeBuilder(IRecipeSerializer.field_222172_p, result, count, ingredient, cookingTime);
    }

    public static ExtendedCookingRecipeBuilder campfire(IItemProvider result, Ingredient ingredient, int cookingTime) {
        return ExtendedCookingRecipeBuilder.campfire(result, 1, ingredient, cookingTime);
    }

    public static ExtendedCookingRecipeBuilder campfire(IItemProvider result, int count, Ingredient ingredient, int cookingTime) {
        return new ExtendedCookingRecipeBuilder(IRecipeSerializer.field_222174_r, result, count, ingredient, cookingTime);
    }

    public static ExtendedCookingRecipeBuilder smelting(IItemProvider result, Ingredient ingredient, int cookingTime) {
        return ExtendedCookingRecipeBuilder.smelting(result, 1, ingredient, cookingTime);
    }

    public static ExtendedCookingRecipeBuilder smelting(IItemProvider result, int count, Ingredient ingredient, int cookingTime) {
        return new ExtendedCookingRecipeBuilder(IRecipeSerializer.field_222171_o, result, count, ingredient, cookingTime);
    }

    public static ExtendedCookingRecipeBuilder smoking(IItemProvider result, Ingredient ingredient, int cookingTime) {
        return ExtendedCookingRecipeBuilder.smoking(result, 1, ingredient, cookingTime);
    }

    public static ExtendedCookingRecipeBuilder smoking(IItemProvider result, int count, Ingredient ingredient, int cookingTime) {
        return new ExtendedCookingRecipeBuilder(IRecipeSerializer.field_222173_q, result, count, ingredient, cookingTime);
    }

    public ExtendedCookingRecipeBuilder experience(float experience) {
        if (experience < 0.0f) {
            throw new IllegalArgumentException("Experience cannot be negative.");
        }
        this.experience = experience;
        return this;
    }

    protected MekanismRecipeBuilder.RecipeResult getResult(ResourceLocation id) {
        return new Result(id);
    }

    public class Result
    extends BaseRecipeBuilder.BaseRecipeResult {
        public Result(ResourceLocation id) {
            super(id);
        }

        @Override
        public void func_218610_a(JsonObject json) {
            super.func_218610_a(json);
            json.add("ingredient", ExtendedCookingRecipeBuilder.this.ingredient.func_200304_c());
            json.addProperty("cookingtime", (Number)ExtendedCookingRecipeBuilder.this.cookingTime);
            if (ExtendedCookingRecipeBuilder.this.experience > 0.0f) {
                json.addProperty("experience", (Number)Float.valueOf(ExtendedCookingRecipeBuilder.this.experience));
            }
        }

        @Override
        protected void serializeResult(JsonObject json) {
            if (ExtendedCookingRecipeBuilder.this.count == 1) {
                json.addProperty("result", ExtendedCookingRecipeBuilder.this.result.getRegistryName().toString());
            } else {
                super.serializeResult(json);
            }
        }
    }
}

