/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class BaseRecipeBuilder<BUILDER extends BaseRecipeBuilder<BUILDER>>
extends MekanismRecipeBuilder<BUILDER> {
    protected final Item result;
    protected final int count;
    private String group;

    protected BaseRecipeBuilder(IRecipeSerializer<?> serializer, IItemProvider result, int count) {
        super(serializer.getRegistryName());
        this.result = result.func_199767_j();
        this.count = count;
    }

    public BUILDER setGroup(String group) {
        this.group = group;
        return (BUILDER)((Object)this);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.result.getRegistryName());
    }

    protected abstract class BaseRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected BaseRecipeResult(ResourceLocation id) {
            super((MekanismRecipeBuilder)BaseRecipeBuilder.this, id);
        }

        public void func_218610_a(JsonObject json) {
            if (BaseRecipeBuilder.this.group != null && !BaseRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", BaseRecipeBuilder.this.group);
            }
            this.serializeResult(json);
        }

        protected void serializeResult(JsonObject json) {
            JsonObject jsonResult = new JsonObject();
            jsonResult.addProperty("item", BaseRecipeBuilder.this.result.getRegistryName().toString());
            if (BaseRecipeBuilder.this.count > 1) {
                jsonResult.addProperty("count", (Number)BaseRecipeBuilder.this.count);
            }
            json.add("result", (JsonElement)jsonResult);
        }
    }
}

