/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen.recipe;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.datagen.recipe.builder.SawmillRecipeBuilder;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.block.Blocks;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.conditions.ICondition;

@ParametersAreNonnullByDefault
public class RecipeProviderUtil {
    private RecipeProviderUtil() {
    }

    private static void build(Consumer<IFinishedRecipe> consumer, MekanismRecipeBuilder<?> builder, String path, @Nullable ICondition condition) {
        if (condition != null) {
            builder.addCondition(condition);
        }
        builder.build(consumer, Mekanism.rl((String)path));
    }

    public static void addPrecisionSawmillBedRecipe(Consumer<IFinishedRecipe> consumer, String basePath, IItemProvider bed, DyeColor color) {
        RecipeProviderUtil.addPrecisionSawmillBedRecipe(consumer, basePath, bed, (IItemProvider)Blocks.field_196662_n, color, null);
    }

    public static void addPrecisionSawmillBedRecipe(Consumer<IFinishedRecipe> consumer, String basePath, IItemProvider bed, IItemProvider planks, DyeColor color, @Nullable ICondition condition) {
        SawmillRecipeBuilder bedRecipeBuilder = SawmillRecipeBuilder.sawing((ItemStackIngredient)ItemStackIngredient.from((IItemProvider)bed), (ItemStack)new ItemStack(planks, 3), (ItemStack)new ItemStack(RecipeProviderUtil.getWool(color), 3), (double)1.0);
        if (condition != null) {
            bedRecipeBuilder.addCondition(condition);
        }
        bedRecipeBuilder.build(consumer, Mekanism.rl((String)(basePath + color)));
    }

    private static IItemProvider getWool(DyeColor color) {
        switch (color) {
            default: {
                return Items.field_221603_aE;
            }
            case ORANGE: {
                return Items.field_221604_aF;
            }
            case MAGENTA: {
                return Items.field_221605_aG;
            }
            case LIGHT_BLUE: {
                return Items.field_221606_aH;
            }
            case YELLOW: {
                return Items.field_221607_aI;
            }
            case LIME: {
                return Items.field_221608_aJ;
            }
            case PINK: {
                return Items.field_221609_aK;
            }
            case GRAY: {
                return Items.field_221610_aL;
            }
            case LIGHT_GRAY: {
                return Items.field_221611_aM;
            }
            case CYAN: {
                return Items.field_221612_aN;
            }
            case PURPLE: {
                return Items.field_221613_aO;
            }
            case BLUE: {
                return Items.field_221614_aP;
            }
            case BROWN: {
                return Items.field_221615_aQ;
            }
            case GREEN: {
                return Items.field_221616_aR;
            }
            case RED: {
                return Items.field_221617_aS;
            }
            case BLACK: 
        }
        return Items.field_221618_aT;
    }
}

