/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen.recipe;

import igentuman.bfr.common.datagen.recipe.ISubRecipeProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

@ParametersAreNonnullByDefault
public abstract class BaseRecipeProvider
extends RecipeProvider {
    private final ExistingFileHelper existingFileHelper;
    private final String modid;

    protected BaseRecipeProvider(DataGenerator gen, ExistingFileHelper existingFileHelper, String modid) {
        super(gen);
        this.existingFileHelper = existingFileHelper;
        this.modid = modid;
    }

    @Nonnull
    public String func_200397_b() {
        return super.func_200397_b() + ": " + this.modid;
    }

    protected final void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        Consumer<IFinishedRecipe> trackingConsumer = consumer.andThen(recipe -> this.existingFileHelper.trackGenerated(recipe.func_200442_b(), ResourcePackType.SERVER_DATA, ".json", "recipes"));
        this.addRecipes(trackingConsumer);
        this.getSubRecipeProviders().forEach(subRecipeProvider -> subRecipeProvider.addRecipes(trackingConsumer));
    }

    protected abstract void addRecipes(Consumer<IFinishedRecipe> var1);

    protected List<ISubRecipeProvider> getSubRecipeProviders() {
        return Collections.emptyList();
    }

    public static Ingredient createIngredient(ITag<Item> itemTag, IItemProvider ... items) {
        return BaseRecipeProvider.createIngredient(Collections.singleton(itemTag), items);
    }

    public static Ingredient createIngredient(Collection<ITag<Item>> itemTags, IItemProvider ... items) {
        return Ingredient.func_209357_a(Stream.concat(itemTags.stream().map(Ingredient.TagList::new), Arrays.stream(items).map(item -> new Ingredient.SingleItemList(new ItemStack(item)))));
    }
}

