/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen.lang;

import igentuman.bfr.common.datagen.lang.ConvertibleLanguageProvider;
import igentuman.bfr.common.datagen.lang.FormatSplitter;
import java.text.ChoiceFormat;
import java.util.List;
import mekanism.common.Mekanism;
import net.minecraft.data.DataGenerator;

public class UpsideDownLanguageProvider
extends ConvertibleLanguageProvider {
    private static final String normal = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789,.?!;\"'`&_^()[]{}<>";
    private static final char[] upside_down = "\u0250q\u0254p\u01dd\u025f\u1d77\u0265\u1d09\u027e\u029e\ua781\u026fuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u0550\ua7b0\ua780WNO\u0500\ua779\u1d1aS\u27d8\u2229\u039bMX\u2144Z0\u295d\u1614\u0190\u07c8\u03db9\u312586'\u02d9\u00bf\u00a1\u061b\u201e,,\u214b\u203ev)(][}{><".toCharArray();

    public UpsideDownLanguageProvider(DataGenerator gen, String modid) {
        super(gen, modid, "en_ud");
    }

    @Override
    public void convert(String key, List<FormatSplitter.Component> splitEnglish) {
        this.add(key, UpsideDownLanguageProvider.convertComponents(splitEnglish));
    }

    private static char flip(char c) {
        int index = normal.indexOf(c);
        return index == -1 ? c : upside_down[index];
    }

    private static String convertFormattingComponent(FormatSplitter.FormatComponent component, int curIndex, int numArguments) {
        String ending;
        if (component instanceof FormatSplitter.MessageFormatComponent) {
            return UpsideDownLanguageProvider.convertMessageFormatCode((FormatSplitter.MessageFormatComponent)component);
        }
        String formattingCode = component.getContents();
        int storedIndex = curIndex;
        String[] split = formattingCode.split("\\$");
        if (split.length == 2) {
            ending = split[1];
            storedIndex = Integer.parseInt(split[0].substring(1));
        } else {
            ending = formattingCode.substring(1);
        }
        if (storedIndex == numArguments - curIndex + 1) {
            return "%" + ending;
        }
        return "%" + storedIndex + "$" + ending;
    }

    private static String convertMessageFormatCode(FormatSplitter.MessageFormatComponent component) {
        String formatStyle = component.getFormatStyle();
        if (formatStyle != null && component.isChoice()) {
            String newFormatStyle = UpsideDownLanguageProvider.invertChoice(formatStyle);
            try {
                new ChoiceFormat(newFormatStyle);
            }
            catch (IllegalArgumentException e) {
                Mekanism.logger.warn("Failed to convert '{}' to an upside down choice format. Got: '{}' which was invalid.", (Object)formatStyle, (Object)newFormatStyle);
                return component.getContents();
            }
            return "{" + component.getArgumentIndex() + "," + component.getFormatType() + "," + newFormatStyle + "}";
        }
        return component.getContents();
    }

    private static String invertChoice(String choice) {
        StringBuilder converted = new StringBuilder();
        StringBuilder literalBuilder = new StringBuilder();
        StringBuilder textBuilder = new StringBuilder();
        char[] exploded = choice.toCharArray();
        int leftBrackets = 0;
        boolean inLiteral = true;
        for (char c : exploded) {
            if (inLiteral) {
                literalBuilder.append(c);
                if (c != '#' && c != '<' && c != '\u2264') continue;
                inLiteral = false;
                converted.append((CharSequence)literalBuilder);
                literalBuilder = new StringBuilder();
                continue;
            }
            if (c == '{') {
                ++leftBrackets;
            } else if (c == '}') {
                --leftBrackets;
            } else if (c == '|' && leftBrackets == 0) {
                inLiteral = true;
                converted.append(UpsideDownLanguageProvider.convertComponents(FormatSplitter.splitMessageFormat(textBuilder.toString())));
                textBuilder = new StringBuilder();
            }
            if (inLiteral) {
                literalBuilder.append(c);
                continue;
            }
            textBuilder.append(c);
        }
        if (inLiteral) {
            converted.append((CharSequence)literalBuilder);
        } else {
            converted.append(UpsideDownLanguageProvider.convertComponents(FormatSplitter.splitMessageFormat(textBuilder.toString())));
        }
        return converted.toString();
    }

    private static String convertComponents(List<FormatSplitter.Component> splitText) {
        int numArguments = (int)splitText.stream().filter(component -> component instanceof FormatSplitter.FormatComponent).count();
        StringBuilder converted = new StringBuilder();
        int curIndex = numArguments;
        for (int i = splitText.size() - 1; i >= 0; --i) {
            FormatSplitter.Component component2 = splitText.get(i);
            if (component2 instanceof FormatSplitter.FormatComponent) {
                converted.append(UpsideDownLanguageProvider.convertFormattingComponent((FormatSplitter.FormatComponent)component2, curIndex--, numArguments));
                continue;
            }
            char[] toConvertArr = component2.getContents().toCharArray();
            for (int j = toConvertArr.length - 1; j >= 0; --j) {
                converted.append(UpsideDownLanguageProvider.flip(toConvertArr[j]));
            }
        }
        return new String(converted);
    }
}

