/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen.lang;

import com.google.common.collect.Table;
import igentuman.bfr.common.datagen.lang.BaseLanguageProvider;
import java.util.Map;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.providers.IItemProvider;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.common.MekanismLang;
import mekanism.common.block.BlockOre;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.FluidRegistryObject;
import mekanism.common.registration.impl.SlurryRegistryObject;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismDamageSource;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismInfuseTypes;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismModules;
import mekanism.common.registries.MekanismPigments;
import mekanism.common.registries.MekanismRobitSkins;
import mekanism.common.registries.MekanismSlurries;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.resource.OreType;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BucketItem;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class MekanismLangProvider
extends BaseLanguageProvider {
    public MekanismLangProvider(DataGenerator gen) {
        super(gen, "mekanism");
    }

    protected void addTranslations() {
        this.addItems();
        this.addBlocks();
        this.addFluids();
        this.addEntities();
        this.addGases();
        this.addInfusionTypes();
        this.addPigments();
        this.addSlurries();
        this.addDamageSources();
        this.addRobitSkins();
        this.addSubtitles();
        this.addMisc();
    }

    private void addItems() {
        this.add((IHasTranslationKey)MekanismItems.ROBIT, "Robit");
        this.add((IHasTranslationKey)MekanismItems.ENERGY_TABLET, "Energy Tablet");
        this.add((IHasTranslationKey)MekanismItems.CONFIGURATION_CARD, "Configuration Card");
        this.add((IHasTranslationKey)MekanismItems.CRAFTING_FORMULA, "Crafting Formula");
        this.add((IHasTranslationKey)MekanismItems.TELEPORTATION_CORE, "Teleportation Core");
        this.add((IHasTranslationKey)MekanismItems.ENRICHED_IRON, "Enriched Iron");
        this.add((IHasTranslationKey)MekanismItems.ELECTROLYTIC_CORE, "Electrolytic Core");
        this.add((IHasTranslationKey)MekanismItems.SAWDUST, "Sawdust");
        this.add((IHasTranslationKey)MekanismItems.SALT, "Salt");
        this.add((IHasTranslationKey)MekanismItems.SUBSTRATE, "Substrate");
        this.add((IHasTranslationKey)MekanismItems.BIO_FUEL, "Bio Fuel");
        this.add((IHasTranslationKey)MekanismItems.DYE_BASE, "Dye Base");
        this.add((IHasTranslationKey)MekanismItems.FLUORITE_GEM, "Fluorite");
        this.add((IHasTranslationKey)MekanismItems.YELLOW_CAKE_URANIUM, "Yellow Cake Uranium");
        this.add((IHasTranslationKey)MekanismItems.ANTIMATTER_PELLET, "Antimatter Pellet");
        this.add((IHasTranslationKey)MekanismItems.PLUTONIUM_PELLET, "Plutonium Pellet");
        this.add((IHasTranslationKey)MekanismItems.POLONIUM_PELLET, "Polonium Pellet");
        this.add((IHasTranslationKey)MekanismItems.REPROCESSED_FISSILE_FRAGMENT, "Reprocessed Fissile Fragment");
        this.add((IHasTranslationKey)MekanismItems.MODULE_BASE, "Module Base");
        this.add((IHasTranslationKey)MekanismItems.PORTABLE_QIO_DASHBOARD, "Portable QIO Dashboard");
        this.add((IHasTranslationKey)MekanismItems.GAUGE_DROPPER, "Gauge Dropper");
        this.add((IHasTranslationKey)MekanismItems.DICTIONARY, "Dictionary");
        this.add((IHasTranslationKey)MekanismItems.CONFIGURATOR, "Configurator");
        this.add((IHasTranslationKey)MekanismItems.NETWORK_READER, "Network Reader");
        this.add((IHasTranslationKey)MekanismItems.SEISMIC_READER, "Seismic Reader");
        this.add((IHasTranslationKey)MekanismItems.PORTABLE_TELEPORTER, "Portable Teleporter");
        this.add((IHasTranslationKey)MekanismItems.ELECTRIC_BOW, "Electric Bow");
        this.add((IHasTranslationKey)MekanismItems.ATOMIC_DISASSEMBLER, "Atomic Disassembler");
        this.add((IHasTranslationKey)MekanismItems.SCUBA_MASK, "Scuba Mask");
        this.add((IHasTranslationKey)MekanismItems.SCUBA_TANK, "Scuba Tank");
        this.add((IHasTranslationKey)MekanismItems.FLAMETHROWER, "Flamethrower");
        this.add((IHasTranslationKey)MekanismItems.FREE_RUNNERS, "Free Runners");
        this.add((IHasTranslationKey)MekanismItems.JETPACK, "Jetpack");
        this.add((IHasTranslationKey)MekanismItems.ARMORED_JETPACK, "Armored Jetpack");
        this.add((IHasTranslationKey)MekanismItems.HDPE_REINFORCED_ELYTRA, "HDPE Reinforced Elytra");
        this.add((IHasTranslationKey)MekanismItems.GEIGER_COUNTER, "Geiger Counter");
        this.add((IHasTranslationKey)MekanismItems.DOSIMETER, "Dosimeter");
        this.add((IHasTranslationKey)MekanismItems.CANTEEN, "Canteen");
        this.add((IHasTranslationKey)MekanismItems.MEKA_TOOL, "Meka-Tool");
        this.add((IHasTranslationKey)MekanismItems.HAZMAT_MASK, "Hazmat Mask");
        this.add((IHasTranslationKey)MekanismItems.HAZMAT_GOWN, "Hazmat Gown");
        this.add((IHasTranslationKey)MekanismItems.HAZMAT_PANTS, "Hazmat Pants");
        this.add((IHasTranslationKey)MekanismItems.HAZMAT_BOOTS, "Hazmat Boots");
        this.add((IHasTranslationKey)MekanismItems.MEKASUIT_HELMET, "MekaSuit Helmet");
        this.add((IHasTranslationKey)MekanismItems.MEKASUIT_BODYARMOR, "MekaSuit Bodyarmor");
        this.add((IHasTranslationKey)MekanismItems.MEKASUIT_PANTS, "MekaSuit Pants");
        this.add((IHasTranslationKey)MekanismItems.MEKASUIT_BOOTS, "MekaSuit Boots");
        this.add((IHasTranslationKey)MekanismItems.BASE_QIO_DRIVE, "QIO Drive");
        this.add((IHasTranslationKey)MekanismItems.HYPER_DENSE_QIO_DRIVE, "Hyper-Dense QIO Drive");
        this.add((IHasTranslationKey)MekanismItems.TIME_DILATING_QIO_DRIVE, "Time-Dilating QIO Drive");
        this.add((IHasTranslationKey)MekanismItems.SUPERMASSIVE_QIO_DRIVE, "Supermassive QIO Drive");
        this.add((IHasTranslationKey)MekanismItems.HDPE_PELLET, "HDPE Pellet");
        this.add((IHasTranslationKey)MekanismItems.HDPE_ROD, "HDPE Rod");
        this.add((IHasTranslationKey)MekanismItems.HDPE_SHEET, "HDPE Sheet");
        this.add((IHasTranslationKey)MekanismItems.HDPE_STICK, "PlaStick");
        this.add((IHasTranslationKey)MekanismItems.ENRICHED_CARBON, "Enriched Carbon");
        this.add((IHasTranslationKey)MekanismItems.ENRICHED_REDSTONE, "Enriched Redstone");
        this.add((IHasTranslationKey)MekanismItems.ENRICHED_DIAMOND, "Enriched Diamond");
        this.add((IHasTranslationKey)MekanismItems.ENRICHED_OBSIDIAN, "Enriched Obsidian");
        this.add((IHasTranslationKey)MekanismItems.ENRICHED_GOLD, "Enriched Gold");
        this.add((IHasTranslationKey)MekanismItems.ENRICHED_TIN, "Enriched Tin");
        this.add((IHasTranslationKey)MekanismItems.SPEED_UPGRADE, "Speed Upgrade");
        this.add((IHasTranslationKey)MekanismItems.ENERGY_UPGRADE, "Energy Upgrade");
        this.add((IHasTranslationKey)MekanismItems.FILTER_UPGRADE, "Filter Upgrade");
        this.add((IHasTranslationKey)MekanismItems.MUFFLING_UPGRADE, "Muffling Upgrade");
        this.add((IHasTranslationKey)MekanismItems.GAS_UPGRADE, "Gas Upgrade");
        this.add((IHasTranslationKey)MekanismItems.ANCHOR_UPGRADE, "Anchor Upgrade");
        this.add((IHasTranslationKey)MekanismItems.STONE_GENERATOR_UPGRADE, "Stone Generator Upgrade");
        this.add((IHasTranslationKey)MekanismItems.INFUSED_ALLOY, "Infused Alloy");
        this.add((IHasTranslationKey)MekanismItems.REINFORCED_ALLOY, "Reinforced Alloy");
        this.add((IHasTranslationKey)MekanismItems.ATOMIC_ALLOY, "Atomic Alloy");
        this.add((IHasTranslationKey)MekanismItems.REFINED_OBSIDIAN_INGOT, "Refined Obsidian Ingot");
        this.add((IHasTranslationKey)MekanismItems.BRONZE_INGOT, "Bronze Ingot");
        this.add((IHasTranslationKey)MekanismItems.REFINED_GLOWSTONE_INGOT, "Refined Glowstone Ingot");
        this.add((IHasTranslationKey)MekanismItems.STEEL_INGOT, "Steel Ingot");
        this.add((IHasTranslationKey)MekanismItems.REFINED_OBSIDIAN_NUGGET, "Refined Obsidian Nugget");
        this.add((IHasTranslationKey)MekanismItems.BRONZE_NUGGET, "Bronze Nugget");
        this.add((IHasTranslationKey)MekanismItems.REFINED_GLOWSTONE_NUGGET, "Refined Glowstone Nugget");
        this.add((IHasTranslationKey)MekanismItems.STEEL_NUGGET, "Steel Nugget");
        this.add((IHasTranslationKey)MekanismItems.BRONZE_DUST, "Bronze Dust");
        this.add((IHasTranslationKey)MekanismItems.LAPIS_LAZULI_DUST, "Lapis Lazuli Dust");
        this.add((IHasTranslationKey)MekanismItems.COAL_DUST, "Coal Dust");
        this.add((IHasTranslationKey)MekanismItems.CHARCOAL_DUST, "Charcoal Dust");
        this.add((IHasTranslationKey)MekanismItems.QUARTZ_DUST, "Quartz Dust");
        this.add((IHasTranslationKey)MekanismItems.EMERALD_DUST, "Emerald Dust");
        this.add((IHasTranslationKey)MekanismItems.DIAMOND_DUST, "Diamond Dust");
        this.add((IHasTranslationKey)MekanismItems.NETHERITE_DUST, "Netherite Dust");
        this.add((IHasTranslationKey)MekanismItems.STEEL_DUST, "Steel Dust");
        this.add((IHasTranslationKey)MekanismItems.SULFUR_DUST, "Sulfur Dust");
        this.add((IHasTranslationKey)MekanismItems.LITHIUM_DUST, "Lithium Dust");
        this.add((IHasTranslationKey)MekanismItems.REFINED_OBSIDIAN_DUST, "Refined Obsidian Dust");
        this.add((IHasTranslationKey)MekanismItems.OBSIDIAN_DUST, "Obsidian Dust");
        this.add((IHasTranslationKey)MekanismItems.FLUORITE_DUST, "Fluorite Dust");
        this.add((IHasTranslationKey)MekanismItems.DIRTY_NETHERITE_SCRAP, "Dirty Netherite Scrap");
        this.addTiered((IItemProvider)MekanismItems.BASIC_CONTROL_CIRCUIT, (IItemProvider)MekanismItems.ADVANCED_CONTROL_CIRCUIT, (IItemProvider)MekanismItems.ELITE_CONTROL_CIRCUIT, (IItemProvider)MekanismItems.ULTIMATE_CONTROL_CIRCUIT, "Control Circuit");
        this.addTiered((IItemProvider)MekanismItems.BASIC_TIER_INSTALLER, (IItemProvider)MekanismItems.ADVANCED_TIER_INSTALLER, (IItemProvider)MekanismItems.ELITE_TIER_INSTALLER, (IItemProvider)MekanismItems.ULTIMATE_TIER_INSTALLER, "Tier Installer");
        for (Table.Cell item : MekanismItems.PROCESSED_RESOURCES.cellSet()) {
            String resourceName = MekanismLangProvider.formatAndCapitalize(((PrimaryResource)item.getColumnKey()).getName());
            switch ((ResourceType)item.getRowKey()) {
                case SHARD: {
                    this.add((IHasTranslationKey)item.getValue(), resourceName + " Shard");
                    break;
                }
                case CRYSTAL: {
                    this.add((IHasTranslationKey)item.getValue(), resourceName + " Crystal");
                    break;
                }
                case DUST: {
                    this.add((IHasTranslationKey)item.getValue(), resourceName + " Dust");
                    break;
                }
                case DIRTY_DUST: {
                    this.add((IHasTranslationKey)item.getValue(), "Dirty " + resourceName + " Dust");
                    break;
                }
                case CLUMP: {
                    this.add((IHasTranslationKey)item.getValue(), resourceName + " Clump");
                    break;
                }
                case INGOT: {
                    this.add((IHasTranslationKey)item.getValue(), resourceName + " Ingot");
                    break;
                }
                case NUGGET: {
                    this.add((IHasTranslationKey)item.getValue(), resourceName + " Nugget");
                    break;
                }
            }
        }
    }

    private static String formatAndCapitalize(String s) {
        boolean isFirst = true;
        StringBuilder ret = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c == '_') {
                isFirst = true;
                ret.append(' ');
                continue;
            }
            ret.append(isFirst ? Character.toUpperCase(c) : c);
            isFirst = false;
        }
        return ret.toString();
    }

    private void addBlocks() {
        this.add((IHasTranslationKey)MekanismBlocks.BOILER_CASING, "Boiler Casing");
        this.add((IHasTranslationKey)MekanismBlocks.BOILER_VALVE, "Boiler Valve");
        this.add((IHasTranslationKey)MekanismBlocks.CARDBOARD_BOX, "Cardboard Box");
        this.add((IHasTranslationKey)MekanismBlocks.CHARGEPAD, "Chargepad");
        this.add((IHasTranslationKey)MekanismBlocks.CHEMICAL_CRYSTALLIZER, "Chemical Crystallizer");
        this.add((IHasTranslationKey)MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER, "Chemical Dissolution Chamber");
        this.add((IHasTranslationKey)MekanismBlocks.CHEMICAL_INFUSER, "Chemical Infuser");
        this.add((IHasTranslationKey)MekanismBlocks.CHEMICAL_INJECTION_CHAMBER, "Chemical Injection Chamber");
        this.add((IHasTranslationKey)MekanismBlocks.CHEMICAL_OXIDIZER, "Chemical Oxidizer");
        this.add((IHasTranslationKey)MekanismBlocks.CHEMICAL_WASHER, "Chemical Washer");
        this.add((IHasTranslationKey)MekanismBlocks.COMBINER, "Combiner");
        this.add((IHasTranslationKey)MekanismBlocks.CRUSHER, "Crusher");
        this.add((IHasTranslationKey)MekanismBlocks.DIGITAL_MINER, "Digital Miner");
        this.add((IHasTranslationKey)MekanismBlocks.DYNAMIC_TANK, "Dynamic Tank");
        this.add((IHasTranslationKey)MekanismBlocks.DYNAMIC_VALVE, "Dynamic Valve");
        this.add((IHasTranslationKey)MekanismBlocks.ELECTRIC_PUMP, "Electric Pump");
        this.add((IHasTranslationKey)MekanismBlocks.ELECTROLYTIC_SEPARATOR, "Electrolytic Separator");
        this.add((IHasTranslationKey)MekanismBlocks.ENERGIZED_SMELTER, "Energized Smelter");
        this.add((IHasTranslationKey)MekanismBlocks.ENRICHMENT_CHAMBER, "Enrichment Chamber");
        this.add((IHasTranslationKey)MekanismBlocks.FLUIDIC_PLENISHER, "Fluidic Plenisher");
        this.add((IHasTranslationKey)MekanismBlocks.FORMULAIC_ASSEMBLICATOR, "Formulaic Assemblicator");
        this.add((IHasTranslationKey)MekanismBlocks.FUELWOOD_HEATER, "Fuelwood Heater");
        this.add((IHasTranslationKey)MekanismBlocks.INDUCTION_CASING, "Induction Casing");
        this.add((IHasTranslationKey)MekanismBlocks.INDUCTION_PORT, "Induction Port");
        this.add((IHasTranslationKey)MekanismBlocks.LASER, "Laser");
        this.add((IHasTranslationKey)MekanismBlocks.LASER_AMPLIFIER, "Laser Amplifier");
        this.add((IHasTranslationKey)MekanismBlocks.LASER_TRACTOR_BEAM, "Laser Tractor Beam");
        this.add((IHasTranslationKey)MekanismBlocks.LOGISTICAL_SORTER, "Logistical Sorter");
        this.add((IHasTranslationKey)MekanismBlocks.METALLURGIC_INFUSER, "Metallurgic Infuser");
        this.add((IHasTranslationKey)MekanismBlocks.OREDICTIONIFICATOR, "Oredictionificator");
        this.add((IHasTranslationKey)MekanismBlocks.OSMIUM_COMPRESSOR, "Osmium Compressor");
        this.add((IHasTranslationKey)MekanismBlocks.PAINTING_MACHINE, "Painting Machine");
        this.add((IHasTranslationKey)MekanismBlocks.PERSONAL_CHEST, "Personal Chest");
        this.add((IHasTranslationKey)MekanismBlocks.PIGMENT_EXTRACTOR, "Pigment Extractor");
        this.add((IHasTranslationKey)MekanismBlocks.PIGMENT_MIXER, "Pigment Mixer");
        this.add((IHasTranslationKey)MekanismBlocks.PRECISION_SAWMILL, "Precision Sawmill");
        this.add((IHasTranslationKey)MekanismBlocks.PRESSURE_DISPERSER, "Pressure Disperser");
        this.add((IHasTranslationKey)MekanismBlocks.PRESSURIZED_REACTION_CHAMBER, "Pressurized Reaction Chamber");
        this.add((IHasTranslationKey)MekanismBlocks.PURIFICATION_CHAMBER, "Purification Chamber");
        this.add((IHasTranslationKey)MekanismBlocks.QUANTUM_ENTANGLOPORTER, "Quantum Entangloporter");
        this.add((IHasTranslationKey)MekanismBlocks.RESISTIVE_HEATER, "Resistive Heater");
        this.add((IHasTranslationKey)MekanismBlocks.MODIFICATION_STATION, "Modification Station");
        this.add((IHasTranslationKey)MekanismBlocks.ISOTOPIC_CENTRIFUGE, "Isotopic Centrifuge");
        this.add((IHasTranslationKey)MekanismBlocks.NUTRITIONAL_LIQUIFIER, "Nutritional Liquifier");
        this.add((IHasTranslationKey)MekanismBlocks.ROTARY_CONDENSENTRATOR, "Rotary Condensentrator");
        this.add((IHasTranslationKey)MekanismBlocks.SALT_BLOCK, "Salt Block");
        this.add((IHasTranslationKey)MekanismBlocks.SECURITY_DESK, "Security Desk");
        this.add((IHasTranslationKey)MekanismBlocks.SEISMIC_VIBRATOR, "Seismic Vibrator");
        this.add((IHasTranslationKey)MekanismBlocks.SOLAR_NEUTRON_ACTIVATOR, "Solar Neutron Activator");
        this.add((IHasTranslationKey)MekanismBlocks.STEEL_CASING, "Steel Casing");
        this.add((IHasTranslationKey)MekanismBlocks.STRUCTURAL_GLASS, "Structural Glass");
        this.add((IHasTranslationKey)MekanismBlocks.SUPERHEATING_ELEMENT, "Superheating Element");
        this.add((IHasTranslationKey)MekanismBlocks.TELEPORTER, "Teleporter");
        this.add((IHasTranslationKey)MekanismBlocks.TELEPORTER_FRAME, "Teleporter Frame");
        this.add((IHasTranslationKey)MekanismBlocks.THERMAL_EVAPORATION_BLOCK, "Thermal Evaporation Block");
        this.add((IHasTranslationKey)MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER, "Thermal Evaporation Controller");
        this.add((IHasTranslationKey)MekanismBlocks.THERMAL_EVAPORATION_VALVE, "Thermal Evaporation Valve");
        this.add((IHasTranslationKey)MekanismBlocks.RADIOACTIVE_WASTE_BARREL, "Radioactive Waste Barrel");
        this.add((IHasTranslationKey)MekanismBlocks.INDUSTRIAL_ALARM, "Industrial Alarm");
        this.add((IHasTranslationKey)MekanismBlocks.ANTIPROTONIC_NUCLEOSYNTHESIZER, "Antiprotonic Nucleosynthesizer");
        this.add((IHasTranslationKey)MekanismBlocks.QIO_DRIVE_ARRAY, "QIO Drive Array");
        this.add((IHasTranslationKey)MekanismBlocks.QIO_DASHBOARD, "QIO Dashboard");
        this.add((IHasTranslationKey)MekanismBlocks.QIO_IMPORTER, "QIO Importer");
        this.add((IHasTranslationKey)MekanismBlocks.QIO_EXPORTER, "QIO Exporter");
        this.add((IHasTranslationKey)MekanismBlocks.QIO_REDSTONE_ADAPTER, "QIO Redstone Adapter");
        this.add((IHasTranslationKey)MekanismBlocks.SPS_CASING, "SPS Casing");
        this.add((IHasTranslationKey)MekanismBlocks.SPS_PORT, "SPS Port");
        this.add((IHasTranslationKey)MekanismBlocks.SUPERCHARGED_COIL, "Supercharged Coil");
        this.add((IHasTranslationKey)MekanismBlocks.BOUNDING_BLOCK, "Bounding Block");
        this.add((IHasTranslationKey)MekanismBlocks.ADVANCED_BOUNDING_BLOCK, "Advanced Bounding Block");
        this.addOre(OreType.OSMIUM, "A strong mineral that can be found at nearly any height in the world. It is known to have many uses in the construction of machinery.");
        this.addOre(OreType.COPPER, "A common, conductive material that can be used in the production of wires. Its ability to withstand high heats also makes it essential to advanced machinery.");
        this.addOre(OreType.TIN, "A lightweight, yet sturdy, conductive material that is found slightly less commonly than Copper.");
        this.addOre(OreType.FLUORITE, "A mineral found relatively deep under the world's surface. The crystals can be processed into Hydrofluoric Acid, an essential chemical for Uranium processing.");
        this.addOre(OreType.URANIUM, "A common, heavy metal, which can yield massive amounts of energy when properly processed. In its naturally-occurring form, it is not radioactive enough to cause harm.");
        this.addOre(OreType.LEAD, "A somewhat rare metal that is excellent at resisting radioactive particles, spawning slightly less frequently than iron.");
        this.add((IHasTranslationKey)MekanismBlocks.BRONZE_BLOCK, "Bronze Block");
        this.add((IHasTranslationKey)MekanismBlocks.REFINED_OBSIDIAN_BLOCK, "Refined Obsidian");
        this.add((IHasTranslationKey)MekanismBlocks.CHARCOAL_BLOCK, "Charcoal Block");
        this.add((IHasTranslationKey)MekanismBlocks.REFINED_GLOWSTONE_BLOCK, "Refined Glowstone");
        this.add((IHasTranslationKey)MekanismBlocks.STEEL_BLOCK, "Steel Block");
        this.add((IHasTranslationKey)MekanismBlocks.FLUORITE_BLOCK, "Fluorite Block");
        for (Map.Entry entry : MekanismBlocks.PROCESSED_RESOURCE_BLOCKS.entrySet()) {
            this.add((IHasTranslationKey)entry.getValue(), MekanismLangProvider.formatAndCapitalize(((PrimaryResource)entry.getKey()).getName()) + " Block");
        }
        this.addTiered((IItemProvider)MekanismBlocks.BASIC_INDUCTION_CELL, (IItemProvider)MekanismBlocks.ADVANCED_INDUCTION_CELL, (IItemProvider)MekanismBlocks.ELITE_INDUCTION_CELL, (IItemProvider)MekanismBlocks.ULTIMATE_INDUCTION_CELL, "Induction Cell");
        this.addTiered((IItemProvider)MekanismBlocks.BASIC_INDUCTION_PROVIDER, (IItemProvider)MekanismBlocks.ADVANCED_INDUCTION_PROVIDER, (IItemProvider)MekanismBlocks.ELITE_INDUCTION_PROVIDER, (IItemProvider)MekanismBlocks.ULTIMATE_INDUCTION_PROVIDER, "Induction Provider");
        this.addTiered((IItemProvider)MekanismBlocks.BASIC_BIN, (IItemProvider)MekanismBlocks.ADVANCED_BIN, (IItemProvider)MekanismBlocks.ELITE_BIN, (IItemProvider)MekanismBlocks.ULTIMATE_BIN, (IItemProvider)MekanismBlocks.CREATIVE_BIN, "Bin");
        this.addTiered((IItemProvider)MekanismBlocks.BASIC_ENERGY_CUBE, (IItemProvider)MekanismBlocks.ADVANCED_ENERGY_CUBE, (IItemProvider)MekanismBlocks.ELITE_ENERGY_CUBE, (IItemProvider)MekanismBlocks.ULTIMATE_ENERGY_CUBE, (IItemProvider)MekanismBlocks.CREATIVE_ENERGY_CUBE, "Energy Cube");
        this.addTiered((IItemProvider)MekanismBlocks.BASIC_FLUID_TANK, (IItemProvider)MekanismBlocks.ADVANCED_FLUID_TANK, (IItemProvider)MekanismBlocks.ELITE_FLUID_TANK, (IItemProvider)MekanismBlocks.ULTIMATE_FLUID_TANK, (IItemProvider)MekanismBlocks.CREATIVE_FLUID_TANK, "Fluid Tank");
        this.addTiered((IItemProvider)MekanismBlocks.BASIC_CHEMICAL_TANK, (IItemProvider)MekanismBlocks.ADVANCED_CHEMICAL_TANK, (IItemProvider)MekanismBlocks.ELITE_CHEMICAL_TANK, (IItemProvider)MekanismBlocks.ULTIMATE_CHEMICAL_TANK, (IItemProvider)MekanismBlocks.CREATIVE_CHEMICAL_TANK, "Chemical Tank");
        for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
            for (FactoryType type : EnumUtils.FACTORY_TYPES) {
                this.add((IHasTranslationKey)MekanismBlocks.getFactory((FactoryTier)tier, (FactoryType)type), tier.getBaseTier().getSimpleName() + " " + type.getRegistryNameComponentCapitalized() + " Factory");
            }
        }
        this.add((IHasTranslationKey)MekanismBlocks.RESTRICTIVE_TRANSPORTER, "Restrictive Transporter");
        this.add((IHasTranslationKey)MekanismBlocks.DIVERSION_TRANSPORTER, "Diversion Transporter");
        this.addTiered((IItemProvider)MekanismBlocks.BASIC_UNIVERSAL_CABLE, (IItemProvider)MekanismBlocks.ADVANCED_UNIVERSAL_CABLE, (IItemProvider)MekanismBlocks.ELITE_UNIVERSAL_CABLE, (IItemProvider)MekanismBlocks.ULTIMATE_UNIVERSAL_CABLE, "Universal Cable");
        this.addTiered((IItemProvider)MekanismBlocks.BASIC_MECHANICAL_PIPE, (IItemProvider)MekanismBlocks.ADVANCED_MECHANICAL_PIPE, (IItemProvider)MekanismBlocks.ELITE_MECHANICAL_PIPE, (IItemProvider)MekanismBlocks.ULTIMATE_MECHANICAL_PIPE, "Mechanical Pipe");
        this.addTiered((IItemProvider)MekanismBlocks.BASIC_PRESSURIZED_TUBE, (IItemProvider)MekanismBlocks.ADVANCED_PRESSURIZED_TUBE, (IItemProvider)MekanismBlocks.ELITE_PRESSURIZED_TUBE, (IItemProvider)MekanismBlocks.ULTIMATE_PRESSURIZED_TUBE, "Pressurized Tube");
        this.addTiered((IItemProvider)MekanismBlocks.BASIC_LOGISTICAL_TRANSPORTER, (IItemProvider)MekanismBlocks.ADVANCED_LOGISTICAL_TRANSPORTER, (IItemProvider)MekanismBlocks.ELITE_LOGISTICAL_TRANSPORTER, (IItemProvider)MekanismBlocks.ULTIMATE_LOGISTICAL_TRANSPORTER, "Logistical Transporter");
        this.addTiered((IItemProvider)MekanismBlocks.BASIC_THERMODYNAMIC_CONDUCTOR, (IItemProvider)MekanismBlocks.ADVANCED_THERMODYNAMIC_CONDUCTOR, (IItemProvider)MekanismBlocks.ELITE_THERMODYNAMIC_CONDUCTOR, (IItemProvider)MekanismBlocks.ULTIMATE_THERMODYNAMIC_CONDUCTOR, "Thermodynamic Conductor");
    }

    private void addFluids() {
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.HYDROGEN, "Liquid Hydrogen");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.OXYGEN, "Liquid Oxygen");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.CHLORINE, "Liquid Chlorine");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.SULFUR_DIOXIDE, "Liquid Sulfur Dioxide");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.SULFUR_TRIOXIDE, "Liquid Sulfur Trioxide");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.SULFURIC_ACID, "Sulfuric Acid");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.HYDROGEN_CHLORIDE, "Liquid Hydrogen Chloride");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.HYDROFLUORIC_ACID, "Liquid Hydrofluoric Acid");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.URANIUM_OXIDE, "Liquid Uranium Oxide");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.URANIUM_HEXAFLUORIDE, "Liquid Uranium Hexafluoride");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.ETHENE, "Liquid Ethylene");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.SODIUM, "Liquid Sodium");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.SUPERHEATED_SODIUM, "Liquid Superheated Sodium");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.BRINE, "Brine");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.LITHIUM, "Liquid Lithium");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.STEAM, "Liquid Steam");
        this.addFluid((FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem>)MekanismFluids.HEAVY_WATER, "Heavy Water");
    }

    private void addEntities() {
        this.add((IHasTranslationKey)MekanismEntityTypes.FLAME, "Flamethrower Flame");
        this.add((IHasTranslationKey)MekanismEntityTypes.ROBIT, "Robit");
    }

    private void addGases() {
        this.add((IHasTranslationKey)MekanismAPI.EMPTY_GAS, "Empty");
        this.add((IHasTranslationKey)MekanismGases.HYDROGEN, "Hydrogen");
        this.add((IHasTranslationKey)MekanismGases.OXYGEN, "Oxygen");
        this.add((IHasTranslationKey)MekanismGases.STEAM, "Steam");
        this.add((IHasTranslationKey)MekanismGases.WATER_VAPOR, "Water Vapor");
        this.add((IHasTranslationKey)MekanismGases.CHLORINE, "Chlorine");
        this.add((IHasTranslationKey)MekanismGases.SULFUR_DIOXIDE, "Sulfur Dioxide");
        this.add((IHasTranslationKey)MekanismGases.SULFUR_TRIOXIDE, "Sulfur Trioxide");
        this.add((IHasTranslationKey)MekanismGases.SULFURIC_ACID, "Sulfuric Acid");
        this.add((IHasTranslationKey)MekanismGases.HYDROGEN_CHLORIDE, "Hydrogen Chloride");
        this.add((IHasTranslationKey)MekanismGases.HYDROFLUORIC_ACID, "Hydrofluoric Acid");
        this.add((IHasTranslationKey)MekanismGases.URANIUM_OXIDE, "Uranium Oxide");
        this.add((IHasTranslationKey)MekanismGases.URANIUM_HEXAFLUORIDE, "Uranium Hexafluoride");
        this.add((IHasTranslationKey)MekanismGases.ETHENE, "Ethylene");
        this.add((IHasTranslationKey)MekanismGases.SODIUM, "Sodium");
        this.add((IHasTranslationKey)MekanismGases.SUPERHEATED_SODIUM, "Superheated Sodium");
        this.add((IHasTranslationKey)MekanismGases.BRINE, "Gaseous Brine");
        this.add((IHasTranslationKey)MekanismGases.LITHIUM, "Lithium");
        this.add((IHasTranslationKey)MekanismGases.LIQUID_OSMIUM, "Liquid Osmium");
        this.add((IHasTranslationKey)MekanismGases.FISSILE_FUEL, "Fissile Fuel");
        this.add((IHasTranslationKey)MekanismGases.NUCLEAR_WASTE, "Nuclear Waste");
        this.add((IHasTranslationKey)MekanismGases.SPENT_NUCLEAR_WASTE, "Spent Nuclear Waste");
        this.add((IHasTranslationKey)MekanismGases.ANTIMATTER, "Antimatter");
        this.add((IHasTranslationKey)MekanismGases.PLUTONIUM, "Plutonium");
        this.add((IHasTranslationKey)MekanismGases.POLONIUM, "Polonium");
        this.add((IHasTranslationKey)MekanismGases.NUTRITIONAL_PASTE, "Nutritional Paste");
    }

    private void addInfusionTypes() {
        this.add((IHasTranslationKey)MekanismAPI.EMPTY_INFUSE_TYPE, "Empty");
        this.add((IHasTranslationKey)MekanismInfuseTypes.CARBON, "Carbon");
        this.add((IHasTranslationKey)MekanismInfuseTypes.REDSTONE, "Redstone");
        this.add((IHasTranslationKey)MekanismInfuseTypes.DIAMOND, "Diamond");
        this.add((IHasTranslationKey)MekanismInfuseTypes.REFINED_OBSIDIAN, "Refined Obsidian");
        this.add((IHasTranslationKey)MekanismInfuseTypes.GOLD, "Gold");
        this.add((IHasTranslationKey)MekanismInfuseTypes.TIN, "Tin");
        this.add((IHasTranslationKey)MekanismInfuseTypes.FUNGI, "Fungi");
        this.add((IHasTranslationKey)MekanismInfuseTypes.BIO, "Biomass");
    }

    private void addPigments() {
        this.add((IHasTranslationKey)MekanismAPI.EMPTY_PIGMENT, "Empty");
        for (Map.Entry entry : MekanismPigments.PIGMENT_COLOR_LOOKUP.entrySet()) {
            this.add((IHasTranslationKey)entry.getValue(), ((EnumColor)entry.getKey()).getEnglishName() + " Pigment");
        }
    }

    private void addSlurries() {
        this.add((IHasTranslationKey)MekanismAPI.EMPTY_SLURRY, "Empty");
        for (Map.Entry entry : MekanismSlurries.PROCESSED_RESOURCES.entrySet()) {
            this.addSlurry((SlurryRegistryObject<Slurry, Slurry>)((SlurryRegistryObject)entry.getValue()), MekanismLangProvider.formatAndCapitalize(((PrimaryResource)entry.getKey()).getName()));
        }
    }

    private void addSlurry(SlurryRegistryObject<Slurry, Slurry> slurryRO, String name) {
        this.add((IHasTranslationKey)slurryRO.getDirtySlurry(), "Dirty " + name + " Slurry");
        this.add((IHasTranslationKey)slurryRO.getCleanSlurry(), "Clean " + name + " Slurry");
    }

    private void addDamageSources() {
        this.add(MekanismDamageSource.LASER, "%s was incinerated.", "%s was incinerated whilst trying to escape %s.");
        this.add(MekanismDamageSource.RADIATION, "%s was killed by radiation poisoning.", "%s was killed by radiation poisoning whilst trying to escape %s.");
    }

    private void add(MekanismDamageSource damageSource, String value, String valueEscaping) {
        this.add((IHasTranslationKey)damageSource, value);
        this.add(damageSource.getTranslationKey() + ".player", valueEscaping);
    }

    private void addRobitSkins() {
        this.add((IHasTranslationKey)MekanismRobitSkins.BASE, "Default");
        this.add((IHasTranslationKey)MekanismRobitSkins.LESBIAN, "Lesbian Pride");
        this.add((IHasTranslationKey)MekanismRobitSkins.PRIDE, "Pride");
        this.add((IHasTranslationKey)MekanismRobitSkins.TRANS, "Trans Pride");
    }

    private void addSubtitles() {
        this.add((IHasTranslationKey)MekanismSounds.CHARGEPAD, "Chargepad hums");
        this.add((IHasTranslationKey)MekanismSounds.CHEMICAL_CRYSTALLIZER, "Crystallizer hums");
        this.add((IHasTranslationKey)MekanismSounds.CHEMICAL_DISSOLUTION_CHAMBER, "Dissolution Chamber hums");
        this.add((IHasTranslationKey)MekanismSounds.CHEMICAL_INFUSER, "Chemical Infuser hums");
        this.add((IHasTranslationKey)MekanismSounds.CHEMICAL_INJECTION_CHAMBER, "Injection Chamber processes");
        this.add((IHasTranslationKey)MekanismSounds.CHEMICAL_OXIDIZER, "Oxidizer hums");
        this.add((IHasTranslationKey)MekanismSounds.CHEMICAL_WASHER, "Washer hums");
        this.add((IHasTranslationKey)MekanismSounds.COMBINER, "Combiner hums");
        this.add((IHasTranslationKey)MekanismSounds.OSMIUM_COMPRESSOR, "Compressor hums");
        this.add((IHasTranslationKey)MekanismSounds.CRUSHER, "Crusher clangs");
        this.add((IHasTranslationKey)MekanismSounds.ELECTROLYTIC_SEPARATOR, "Separator separates");
        this.add((IHasTranslationKey)MekanismSounds.ENRICHMENT_CHAMBER, "Enricher hums");
        this.add((IHasTranslationKey)MekanismSounds.LASER, "Laser hums");
        this.add((IHasTranslationKey)MekanismSounds.LOGISTICAL_SORTER, "Sorter clicks");
        this.add((IHasTranslationKey)MekanismSounds.METALLURGIC_INFUSER, "Metallurgic infuser hums");
        this.add((IHasTranslationKey)MekanismSounds.PRECISION_SAWMILL, "Sawmill cuts");
        this.add((IHasTranslationKey)MekanismSounds.PRESSURIZED_REACTION_CHAMBER, "Reaction chamber hums");
        this.add((IHasTranslationKey)MekanismSounds.PURIFICATION_CHAMBER, "Purifier hums");
        this.add((IHasTranslationKey)MekanismSounds.RESISTIVE_HEATER, "Heater hums");
        this.add((IHasTranslationKey)MekanismSounds.ROTARY_CONDENSENTRATOR, "Condensentrator rotates");
        this.add((IHasTranslationKey)MekanismSounds.ENERGIZED_SMELTER, "Smelter whines");
        this.add((IHasTranslationKey)MekanismSounds.ISOTOPIC_CENTRIFUGE, "Centrifuge spins");
        this.add((IHasTranslationKey)MekanismSounds.NUTRITIONAL_LIQUIFIER, "Nutrients liquified");
        this.add((IHasTranslationKey)MekanismSounds.INDUSTRIAL_ALARM, "Alarm sounds");
        this.add((IHasTranslationKey)MekanismSounds.ANTIPROTONIC_NUCLEOSYNTHESIZER, "Nucleosynthesizer hums");
        this.add((IHasTranslationKey)MekanismSounds.PIGMENT_EXTRACTOR, "Pigment extractor extracts");
        this.add((IHasTranslationKey)MekanismSounds.PIGMENT_MIXER, "Pigment mixer sloshes");
        this.add((IHasTranslationKey)MekanismSounds.PAINTING_MACHINE, "Painting machine sprays");
        this.add((IHasTranslationKey)MekanismSounds.SPS, "SPS hums");
        this.add((IHasTranslationKey)MekanismSounds.FLAMETHROWER_IDLE, "Flamethrower hisses");
        this.add((IHasTranslationKey)MekanismSounds.FLAMETHROWER_ACTIVE, "Flamethrower burns");
        this.add((IHasTranslationKey)MekanismSounds.SCUBA_MASK, "Air flows");
        this.add((IHasTranslationKey)MekanismSounds.JETPACK, "Jetpack burns");
        this.add((IHasTranslationKey)MekanismSounds.HYDRAULIC, "Hydraulic shifts");
        this.add((IHasTranslationKey)MekanismSounds.GRAVITATIONAL_MODULATION_UNIT, "Gravity modulates");
        this.add((IHasTranslationKey)MekanismSounds.GEIGER_SLOW, "Geiger counter clicks slowly");
        this.add((IHasTranslationKey)MekanismSounds.GEIGER_MEDIUM, "Geiger Counter clicks");
        this.add((IHasTranslationKey)MekanismSounds.GEIGER_ELEVATED, "Elevated Geiger Counter clicks");
        this.add((IHasTranslationKey)MekanismSounds.GEIGER_FAST, "Constant Geiger Counter clicks");
    }

    private void addMisc() {
        this.add((IHasTranslationKey)APILang.UPGRADE_SPEED, "Speed");
        this.add((IHasTranslationKey)APILang.UPGRADE_SPEED_DESCRIPTION, "Increases speed of machinery.");
        this.add((IHasTranslationKey)APILang.UPGRADE_ENERGY, "Energy");
        this.add((IHasTranslationKey)APILang.UPGRADE_ENERGY_DESCRIPTION, "Increases energy efficiency and capacity of machinery.");
        this.add((IHasTranslationKey)APILang.UPGRADE_FILTER, "Filter");
        this.add((IHasTranslationKey)APILang.UPGRADE_FILTER_DESCRIPTION, "A filter that separates heavy water from regular water.");
        this.add((IHasTranslationKey)APILang.UPGRADE_GAS, "Gas");
        this.add((IHasTranslationKey)APILang.UPGRADE_GAS_DESCRIPTION, "Increases the efficiency of gas-using machinery.");
        this.add((IHasTranslationKey)APILang.UPGRADE_MUFFLING, "Muffling");
        this.add((IHasTranslationKey)APILang.UPGRADE_MUFFLING_DESCRIPTION, "Reduces noise generated by machinery.");
        this.add((IHasTranslationKey)APILang.UPGRADE_ANCHOR, "Anchor");
        this.add((IHasTranslationKey)APILang.UPGRADE_ANCHOR_DESCRIPTION, "Keeps a machine's chunk loaded.");
        this.add((IHasTranslationKey)APILang.UPGRADE_STONE_GENERATOR, "Stone Generator");
        this.add((IHasTranslationKey)APILang.UPGRADE_STONE_GENERATOR_DESCRIPTION, "Generates stone or cobblestone as needed.");
        this.add((IHasTranslationKey)MekanismLang.TRANSMISSION_TYPE_ENERGY, "Energy");
        this.add((IHasTranslationKey)MekanismLang.TRANSMISSION_TYPE_FLUID, "Fluids");
        this.add((IHasTranslationKey)MekanismLang.TRANSMISSION_TYPE_GAS, "Gases");
        this.add((IHasTranslationKey)MekanismLang.TRANSMISSION_TYPE_INFUSION, "Infuse Types");
        this.add((IHasTranslationKey)MekanismLang.TRANSMISSION_TYPE_PIGMENT, "Pigments");
        this.add((IHasTranslationKey)MekanismLang.TRANSMISSION_TYPE_SLURRY, "Slurries");
        this.add((IHasTranslationKey)MekanismLang.TRANSMISSION_TYPE_ITEM, "Items");
        this.add((IHasTranslationKey)MekanismLang.TRANSMISSION_TYPE_HEAT, "Heat");
        this.add((IHasTranslationKey)APILang.CHEMICAL_ATTRIBUTE_RADIATION, " - Radioactivity: %s");
        this.add((IHasTranslationKey)APILang.CHEMICAL_ATTRIBUTE_COOLANT_EFFICIENCY, " - Coolant Efficiency: %s");
        this.add((IHasTranslationKey)APILang.CHEMICAL_ATTRIBUTE_COOLANT_ENTHALPY, " - Thermal Enthalpy: %s");
        this.add((IHasTranslationKey)APILang.CHEMICAL_ATTRIBUTE_FUEL_BURN_TICKS, " - Burn Time: %s t");
        this.add((IHasTranslationKey)APILang.CHEMICAL_ATTRIBUTE_FUEL_ENERGY_DENSITY, " - Energy Density: %s");
        for (EnumColor color : EnumUtils.COLORS) {
            this.add((IHasTranslationKey)color.getLangEntry(), color.getEnglishName());
        }
        this.add((IHasTranslationKey)MekanismLang.MEKANISM, "Mekanism");
        this.add((IHasTranslationKey)MekanismLang.DEBUG_TITLE, "Mekanism Debug");
        this.add((IHasTranslationKey)MekanismLang.LOG_FORMAT, "[%s] %s");
        this.add((IHasTranslationKey)MekanismLang.FORGE, "MinecraftForge");
        this.add((IHasTranslationKey)MekanismLang.IC2, "IndustrialCraft");
        this.add((IHasTranslationKey)MekanismLang.ERROR, "Error");
        this.add((IHasTranslationKey)MekanismLang.ALPHA_WARNING, "Warning: Mekanism is currently in alpha, and is not recommended for widespread use in modpacks. There are likely to be game breaking bugs, and various other issues that you can read more about %s.");
        this.add((IHasTranslationKey)MekanismLang.ALPHA_WARNING_HERE, "here");
        this.add((IHasTranslationKey)MekanismLang.HEAD, "Head");
        this.add((IHasTranslationKey)MekanismLang.BODY, "Body");
        this.add((IHasTranslationKey)MekanismLang.LEGS, "Legs");
        this.add((IHasTranslationKey)MekanismLang.FEET, "Feet");
        this.add((IHasTranslationKey)MekanismLang.MAINHAND, "Hand 1");
        this.add((IHasTranslationKey)MekanismLang.OFFHAND, "Hand 2");
        this.add((IHasTranslationKey)MekanismLang.MULTIBLOCK_INVALID_FRAME, "Couldn't create frame, invalid block at %s.");
        this.add((IHasTranslationKey)MekanismLang.MULTIBLOCK_INVALID_INNER, "Couldn't validate center, found invalid block at %s.");
        this.add((IHasTranslationKey)MekanismLang.MULTIBLOCK_INVALID_CONTROLLER_CONFLICT, "Controller conflict: found extra controller at %s.");
        this.add((IHasTranslationKey)MekanismLang.MULTIBLOCK_INVALID_NO_CONTROLLER, "Couldn't form, no controller found.");
        this.add((IHasTranslationKey)MekanismLang.SPS, "Supercritical Phase Shifter");
        this.add((IHasTranslationKey)MekanismLang.SPS_INVALID_DISCONNECTED_COIL, "Couldn't form, found a coil without a connection to an SPS Port.");
        this.add((IHasTranslationKey)MekanismLang.SPS_PORT_MODE, "Toggled SPS Port mode to: %s.");
        this.add((IHasTranslationKey)MekanismLang.SPS_ENERGY_INPUT, "Energy Input: %s/t");
        this.add((IHasTranslationKey)MekanismLang.BOILER_INVALID_AIR_POCKETS, "Couldn't form, found disconnected interior air pockets.");
        this.add((IHasTranslationKey)MekanismLang.BOILER_INVALID_EXTRA_DISPERSER, "Couldn't form, found invalid Pressure Dispersers.");
        this.add((IHasTranslationKey)MekanismLang.BOILER_INVALID_MISSING_DISPERSER, "Couldn't form, expected but didn't find Pressure Disperser at %s.");
        this.add((IHasTranslationKey)MekanismLang.BOILER_INVALID_NO_DISPERSER, "Couldn't form, no Pressure Disperser layer found.");
        this.add((IHasTranslationKey)MekanismLang.BOILER_INVALID_SUPERHEATING, "Couldn't form, invalid Superheating Element arrangement.");
        this.add((IHasTranslationKey)MekanismLang.CONVERSION_ENERGY, "Item to Energy");
        this.add((IHasTranslationKey)MekanismLang.CONVERSION_GAS, "Item to Gas");
        this.add((IHasTranslationKey)MekanismLang.CONVERSION_INFUSION, "Item to Infuse Type");
        this.add((IHasTranslationKey)MekanismLang.SET_FREQUENCY, "Set Frequency");
        this.add((IHasTranslationKey)MekanismLang.QIO_FREQUENCY_SELECT, "QIO Frequency Select");
        this.add((IHasTranslationKey)MekanismLang.QIO_ITEMS_DETAIL, "Items: %s / %s");
        this.add((IHasTranslationKey)MekanismLang.QIO_TYPES_DETAIL, "Types: %s / %s");
        this.add((IHasTranslationKey)MekanismLang.QIO_ITEMS, "Items");
        this.add((IHasTranslationKey)MekanismLang.QIO_TYPES, "Types");
        this.add((IHasTranslationKey)MekanismLang.QIO_TRIGGER_COUNT, "Trigger count: %s");
        this.add((IHasTranslationKey)MekanismLang.QIO_STORED_COUNT, "Stored count: %s");
        this.add((IHasTranslationKey)MekanismLang.QIO_ITEM_TYPE_UNDEFINED, "Item type undefined");
        this.add((IHasTranslationKey)MekanismLang.QIO_IMPORT_WITHOUT_FILTER, "Import Without Filter:");
        this.add((IHasTranslationKey)MekanismLang.QIO_EXPORT_WITHOUT_FILTER, "Export Without Filter:");
        this.add((IHasTranslationKey)MekanismLang.QIO_COMPENSATE_TOOLTIP, "What are you trying to compensate for?");
        this.add((IHasTranslationKey)MekanismLang.LIST_SORT_COUNT, "Count");
        this.add((IHasTranslationKey)MekanismLang.LIST_SORT_NAME, "Name");
        this.add((IHasTranslationKey)MekanismLang.LIST_SORT_MOD, "Mod");
        this.add((IHasTranslationKey)MekanismLang.LIST_SORT_NAME_DESC, "Sort items by name.");
        this.add((IHasTranslationKey)MekanismLang.LIST_SORT_COUNT_DESC, "Sort items by count.");
        this.add((IHasTranslationKey)MekanismLang.LIST_SORT_MOD_DESC, "Sort items by mod.");
        this.add((IHasTranslationKey)MekanismLang.LIST_SORT_ASCENDING_DESC, "Sort items in ascending order.");
        this.add((IHasTranslationKey)MekanismLang.LIST_SORT_DESCENDING_DESC, "Sort items in descending order.");
        this.add((IHasTranslationKey)MekanismLang.LIST_SEARCH, "Search:");
        this.add((IHasTranslationKey)MekanismLang.LIST_SORT, "Sort:");
        this.add((IHasTranslationKey)MekanismLang.JEI_AMOUNT_WITH_CAPACITY, "%s / %s mB");
        this.add((IHasTranslationKey)MekanismLang.JEI_INFO_HEAVY_WATER, "%s mB of Heavy Water can be extracted from a water source block via an electric pump with a filter upgrade installed.");
        this.add((IHasTranslationKey)MekanismLang.JEI_INFO_MODULE_INSTALLATION, "Using a Modification Station, modules can be installed on the various MekaSuit pieces and on the Meka-Tool.");
        this.add((IHasTranslationKey)MekanismLang.KEY_HAND_MODE, "Item Mode Switch");
        this.add((IHasTranslationKey)MekanismLang.KEY_HEAD_MODE, "Head Mode Switch");
        this.add((IHasTranslationKey)MekanismLang.KEY_CHEST_MODE, "Chest Mode Switch");
        this.add((IHasTranslationKey)MekanismLang.KEY_LEGS_MODE, "Legs Mode Switch");
        this.add((IHasTranslationKey)MekanismLang.KEY_FEET_MODE, "Feet Mode Switch");
        this.add((IHasTranslationKey)MekanismLang.KEY_DETAILS_MODE, "Show Details");
        this.add((IHasTranslationKey)MekanismLang.KEY_DESCRIPTION_MODE, "Show Description");
        this.add((IHasTranslationKey)MekanismLang.KEY_BOOST, "Boost");
        this.add((IHasTranslationKey)MekanismLang.KEY_MODULE_TWEAKER, "Module Tweaker");
        this.add((IHasTranslationKey)MekanismLang.KEY_HUD, "Show HUD");
        this.add((IHasTranslationKey)MekanismLang.HOLIDAY_BORDER, "%s%s%1$s");
        this.add((IHasTranslationKey)MekanismLang.HOLIDAY_SIGNATURE, "-aidancbrady");
        this.add((IHasTranslationKey)MekanismLang.CHRISTMAS_LINE_ONE, "Merry Christmas, %s!");
        this.add((IHasTranslationKey)MekanismLang.CHRISTMAS_LINE_TWO, "May you have plenty of Christmas cheer");
        this.add((IHasTranslationKey)MekanismLang.CHRISTMAS_LINE_THREE, "and have a relaxing holiday with your");
        this.add((IHasTranslationKey)MekanismLang.CHRISTMAS_LINE_FOUR, "family :)");
        this.add((IHasTranslationKey)MekanismLang.NEW_YEAR_LINE_ONE, "Happy New Year, %s!");
        this.add((IHasTranslationKey)MekanismLang.NEW_YEAR_LINE_TWO, "Best wishes to you as we enter this");
        this.add((IHasTranslationKey)MekanismLang.NEW_YEAR_LINE_THREE, "new and exciting year of %s! :)");
        this.add((IHasTranslationKey)MekanismLang.MAY_4_LINE_ONE, "May the 4th be with you, %s!");
        this.add((IHasTranslationKey)APILang.GENERIC, "%s");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_PERCENT, "%s%%");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_WITH_COMMA, "%s, %s");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_STORED, "%s: %s");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_STORED_MB, "%s: %s mB");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_MB, "%s mB");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_PRE_COLON, "%s:");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_SQUARE_BRACKET, "[%s]");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_PARENTHESIS, "(%s)");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_WITH_PARENTHESIS, "%s (%s)");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_WITH_TWO_PARENTHESIS, "%s (%s) (%s)");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_FRACTION, "%s/%s");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_TRANSFER, "- %s (%s)");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_PER_TICK, "%s/t");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_PER_MB, "%s/mB");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_PRE_STORED, "%s %s: %s");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_BLOCK_POS, "%s, %s, %s");
        this.add((IHasTranslationKey)MekanismLang.GENERIC_HEX, "#%s");
        this.add((IHasTranslationKey)APILang.DOWN, "Down");
        this.add((IHasTranslationKey)APILang.UP, "Up");
        this.add((IHasTranslationKey)APILang.NORTH, "North");
        this.add((IHasTranslationKey)APILang.SOUTH, "South");
        this.add((IHasTranslationKey)APILang.WEST, "West");
        this.add((IHasTranslationKey)APILang.EAST, "East");
        this.add((IHasTranslationKey)MekanismLang.NORTH_SHORT, "N");
        this.add((IHasTranslationKey)MekanismLang.SOUTH_SHORT, "S");
        this.add((IHasTranslationKey)MekanismLang.WEST_SHORT, "W");
        this.add((IHasTranslationKey)MekanismLang.EAST_SHORT, "E");
        this.add((IHasTranslationKey)APILang.FRONT, "Front");
        this.add((IHasTranslationKey)APILang.LEFT, "Left");
        this.add((IHasTranslationKey)APILang.RIGHT, "Right");
        this.add((IHasTranslationKey)APILang.BACK, "Back");
        this.add((IHasTranslationKey)APILang.TOP, "Top");
        this.add((IHasTranslationKey)APILang.BOTTOM, "Bottom");
        this.add((IHasTranslationKey)MekanismLang.HOLD_FOR_DETAILS, "Hold %s for details.");
        this.add((IHasTranslationKey)MekanismLang.HOLD_FOR_DESCRIPTION, "Hold %s for a description.");
        this.add((IHasTranslationKey)MekanismLang.HOLD_FOR_MODULES, "Hold %s for installed modules.");
        this.add((IHasTranslationKey)MekanismLang.HOLD_FOR_SUPPORTED_ITEMS, "Hold %s for supporting items.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_CHUNK_WATCH, "Chunk (%s) added to watch list.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_CHUNK_UNWATCH, "Chunk (%s) removed from watch list.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_CHUNK_CLEAR, "%s chunks removed from watch list.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_CHUNK_FLUSH, "%s chunks unloaded.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_CHUNK_LOADED, "Loaded chunk (%s).");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_CHUNK_UNLOADED, "Unloaded chunk (%s).");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_DEBUG, "Toggled debug mode: %s.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_TEST_RULES, "Enabled keepInventory, and disabled doMobSpawning, doDaylightCycle, doWeatherCycle and mobGriefing!");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_TP, "Teleported to (%s) - saved last position on stack.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_TPOP, "Returned to (%s); %s positions on stack.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_ERROR_TPOP_EMPTY, "No positions on stack.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_BUILD_REMOVED, "Build successfully removed.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_BUILD_BUILT, "Finished building: %s.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_ERROR_BUILD_MISS, "No valid target found.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_RADIATION_ADD, "Added %s radiation at (%s) in %s.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_RADIATION_GET, "Current radiation at (%s) in %s: %s");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_RADIATION_CLEAR, "Cleared player radiation.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_RADIATION_CLEAR_ENTITY, "Cleared entity radiation for: %s.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_RADIATION_REMOVE_ALL, "Removed all radiation sources.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_RETROGEN_CHUNK_QUEUED, "Queued chunk (%s) in %s for retrogen.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_ERROR_RETROGEN_DISABLED, "Retrogen is disabled, please enable it in the config.");
        this.add((IHasTranslationKey)MekanismLang.COMMAND_ERROR_RETROGEN_FAILURE, "Failed to queue any chunks for retrogen.");
        this.add((IHasTranslationKey)MekanismLang.MODE, "Mode: %s");
        this.add((IHasTranslationKey)MekanismLang.FIRE_MODE, "Fire Mode: %s");
        this.add((IHasTranslationKey)MekanismLang.BUCKET_MODE, "Bucket Mode: %s");
        this.add((IHasTranslationKey)MekanismLang.STORED_ENERGY, "Stored energy: %s");
        this.add((IHasTranslationKey)MekanismLang.STORED, "Stored %s: %s");
        this.add((IHasTranslationKey)MekanismLang.STORED_MB_PERCENTAGE, "Stored %s: %s mB (%s)");
        this.add((IHasTranslationKey)MekanismLang.ITEM_AMOUNT, "Item amount: %s");
        this.add((IHasTranslationKey)MekanismLang.FLOWING, "Flowing: %s");
        this.add((IHasTranslationKey)MekanismLang.INVALID, "(Invalid)");
        this.add((IHasTranslationKey)MekanismLang.HAS_INVENTORY, "Inventory: %s");
        this.add((IHasTranslationKey)MekanismLang.NO_GAS, "No gas stored.");
        this.add((IHasTranslationKey)MekanismLang.FREE_RUNNERS_MODE, "Runners Mode: %s");
        this.add((IHasTranslationKey)MekanismLang.JETPACK_MODE, "Jetpack Mode: %s");
        this.add((IHasTranslationKey)MekanismLang.SCUBA_TANK_MODE, "Scuba Tank: %s");
        this.add((IHasTranslationKey)MekanismLang.FREE_RUNNERS_STORED, "Runners Energy: %s");
        this.add((IHasTranslationKey)MekanismLang.FLAMETHROWER_STORED, "Flamethrower: %s");
        this.add((IHasTranslationKey)MekanismLang.JETPACK_STORED, "Jetpack Fuel: %s");
        this.add((IHasTranslationKey)MekanismLang.PROGRESS, "Progress: %s");
        this.add((IHasTranslationKey)MekanismLang.PROCESS_RATE, "Process Rate: %s");
        this.add((IHasTranslationKey)MekanismLang.PROCESS_RATE_MB, "Process Rate: %s mB/t");
        this.add((IHasTranslationKey)MekanismLang.TICKS_REQUIRED, "Ticks Required: %s");
        this.add((IHasTranslationKey)MekanismLang.DECAY_IMMUNE, "Will not decay inside a Radioactive Waste Barrel");
        this.add((IHasTranslationKey)MekanismLang.WIDTH, "Width");
        this.add((IHasTranslationKey)MekanismLang.HEIGHT, "Height");
        this.add((IHasTranslationKey)MekanismLang.CRAFTING_TAB, "Crafting (%s/%s)");
        this.add((IHasTranslationKey)MekanismLang.CRAFTING_WINDOW, "Crafting Window %s");
        this.add((IHasTranslationKey)MekanismLang.MIN, "Min: %s");
        this.add((IHasTranslationKey)MekanismLang.MAX, "Max: %s");
        this.add((IHasTranslationKey)MekanismLang.INFINITE, "Infinite");
        this.add((IHasTranslationKey)MekanismLang.NONE, "None");
        this.add((IHasTranslationKey)MekanismLang.EMPTY, "Empty");
        this.add((IHasTranslationKey)MekanismLang.MAX_OUTPUT, "Max Output: %s/t");
        this.add((IHasTranslationKey)MekanismLang.STORING, "Storing: %s");
        this.add((IHasTranslationKey)MekanismLang.DISSIPATED_RATE, "Dissipated: %s/t");
        this.add((IHasTranslationKey)MekanismLang.TRANSFERRED_RATE, "Transferred: %s/t");
        this.add((IHasTranslationKey)MekanismLang.FUEL, "Fuel: %s");
        this.add((IHasTranslationKey)MekanismLang.VOLUME, "Volume: %s");
        this.add((IHasTranslationKey)MekanismLang.NO_FLUID, "No fluid");
        this.add((IHasTranslationKey)MekanismLang.CHEMICAL, "Chemical: %s");
        this.add((IHasTranslationKey)MekanismLang.GAS, "Gas: %s");
        this.add((IHasTranslationKey)MekanismLang.INFUSE_TYPE, "Infuse Type: %s");
        this.add((IHasTranslationKey)MekanismLang.PIGMENT, "Pigment: %s");
        this.add((IHasTranslationKey)MekanismLang.SLURRY, "Slurry: %s");
        this.add((IHasTranslationKey)MekanismLang.LIQUID, "Liquid: %s");
        this.add((IHasTranslationKey)MekanismLang.UNIT, "Unit: %s");
        this.add((IHasTranslationKey)MekanismLang.USING, "Using: %s/t");
        this.add((IHasTranslationKey)MekanismLang.NEEDED, "Needed: %s");
        this.add((IHasTranslationKey)MekanismLang.NEEDED_PER_TICK, "Needed: %s/t");
        this.add((IHasTranslationKey)MekanismLang.FINISHED, "Finished: %s");
        this.add((IHasTranslationKey)MekanismLang.NO_RECIPE, "(No recipe)");
        this.add((IHasTranslationKey)MekanismLang.EJECT, "Eject: %s");
        this.add((IHasTranslationKey)MekanismLang.NO_DELAY, "No Delay");
        this.add((IHasTranslationKey)MekanismLang.DELAY, "Delay: %st");
        this.add((IHasTranslationKey)MekanismLang.ENERGY, "Energy: %s");
        this.add((IHasTranslationKey)MekanismLang.RESISTIVE_HEATER_USAGE, "Usage: %s/t");
        this.add((IHasTranslationKey)MekanismLang.DYNAMIC_TANK, "Dynamic Tank");
        this.add((IHasTranslationKey)MekanismLang.CHEMICAL_DISSOLUTION_CHAMBER_SHORT, "C. Dissolution Chamber");
        this.add((IHasTranslationKey)MekanismLang.CHEMICAL_INFUSER_SHORT, "C. Infuser");
        this.add((IHasTranslationKey)MekanismLang.MOVE_UP, "Move Up");
        this.add((IHasTranslationKey)MekanismLang.MOVE_DOWN, "Move Down");
        this.add((IHasTranslationKey)MekanismLang.SET, "Set:");
        this.add((IHasTranslationKey)MekanismLang.TRUE, "True");
        this.add((IHasTranslationKey)MekanismLang.FALSE, "False");
        this.add((IHasTranslationKey)MekanismLang.CLOSE, "Close");
        this.add((IHasTranslationKey)MekanismLang.RADIATION_DOSE, "Radiation Dose: %s");
        this.add((IHasTranslationKey)MekanismLang.RADIATION_EXPOSURE, "Radiation Exposure: %s");
        this.add((IHasTranslationKey)MekanismLang.RGB, "RGB:");
        this.add((IHasTranslationKey)MekanismLang.COLOR_PICKER, "Color Picker");
        this.add((IHasTranslationKey)MekanismLang.HELMET_OPTIONS, "Helmet Options");
        this.add((IHasTranslationKey)MekanismLang.HUD_OVERLAY, "HUD Overlay:");
        this.add((IHasTranslationKey)MekanismLang.OPACITY, "Opacity");
        this.add((IHasTranslationKey)MekanismLang.DEFAULT, "Default");
        this.add((IHasTranslationKey)MekanismLang.WARNING, "Warning");
        this.add((IHasTranslationKey)MekanismLang.DANGER, "Danger");
        this.add((IHasTranslationKey)MekanismLang.COMPASS, "Compass");
        this.add((IHasTranslationKey)MekanismLang.RADIAL_SCREEN, "Radial Selector Screen");
        this.add((IHasTranslationKey)MekanismLang.ISSUES, "Issues:");
        this.add((IHasTranslationKey)MekanismLang.ISSUE_NOT_ENOUGH_ENERGY, " - Not enough energy to operate");
        this.add((IHasTranslationKey)MekanismLang.ISSUE_NOT_ENOUGH_ENERGY_REDUCED_RATE, " - Not enough energy to run at maximum speed");
        this.add((IHasTranslationKey)MekanismLang.ISSUE_NO_SPACE_IN_OUTPUT, " - Not enough room in output");
        this.add((IHasTranslationKey)MekanismLang.ISSUE_NO_MATCHING_RECIPE, " - No matching recipe or not enough input");
        this.add((IHasTranslationKey)MekanismLang.ISSUE_INPUT_DOESNT_PRODUCE_OUTPUT, " - Input does not produce output");
        this.add((IHasTranslationKey)MekanismLang.ISSUE_INVALID_OREDICTIONIFICATOR_FILTER, " - Filter is no longer valid or supported");
        this.add((IHasTranslationKey)MekanismLang.ISSUE_FILTER_HAS_BLACKLISTED_ELEMENT, " - Filter contains at least one element that is blacklisted");
        this.add((IHasTranslationKey)MekanismLang.ENTITY_DETECTION, "Entity Detection");
        this.add((IHasTranslationKey)MekanismLang.ENERGY_CONTENTS, "Energy Contents");
        this.add((IHasTranslationKey)MekanismLang.REDSTONE_OUTPUT, "Redstone Output: %s");
        this.add((IHasTranslationKey)MekanismLang.FREQUENCY, "Frequency: %s");
        this.add((IHasTranslationKey)MekanismLang.NO_FREQUENCY, "No frequency");
        this.add((IHasTranslationKey)MekanismLang.FREQUENCY_DELETE_CONFIRM, "Are you sure you want to delete this frequency? This can't be undone.");
        this.add((IHasTranslationKey)MekanismLang.NOW_OWN, "You now own this item.");
        this.add((IHasTranslationKey)MekanismLang.OWNER, "Owner: %s");
        this.add((IHasTranslationKey)MekanismLang.NO_OWNER, "No Owner");
        this.add((IHasTranslationKey)MekanismLang.MAIN_TAB, "Main");
        this.add((IHasTranslationKey)MekanismLang.EVAPORATION_HEIGHT, "Height: %s");
        this.add((IHasTranslationKey)MekanismLang.FLUID_PRODUCTION, "Production: %s mB/t");
        this.add((IHasTranslationKey)MekanismLang.EVAPORATION_PLANT, "Thermal Evaporation Plant");
        this.add((IHasTranslationKey)MekanismLang.TRANSPORTER_CONFIG, "Transporter Config");
        this.add((IHasTranslationKey)MekanismLang.SIDE_CONFIG, "Side Config");
        this.add((IHasTranslationKey)MekanismLang.SIDE_CONFIG_CLEAR, "Clear Side Config (sets all sides to none)");
        this.add((IHasTranslationKey)MekanismLang.STRICT_INPUT, "Strict Input");
        this.add((IHasTranslationKey)MekanismLang.STRICT_INPUT_ENABLED, "Strict Input (%s)");
        this.add((IHasTranslationKey)MekanismLang.CONFIG_TYPE, "%s Config");
        this.add((IHasTranslationKey)MekanismLang.NO_EJECT, "Can't Eject");
        this.add((IHasTranslationKey)MekanismLang.CANT_EJECT_TOOLTIP, "Auto-eject is not supported, manual extraction may still be possible.");
        this.add((IHasTranslationKey)MekanismLang.SLOTS, "Slots");
        this.add((IHasTranslationKey)MekanismLang.AUTO_PULL, "Auto-pull");
        this.add((IHasTranslationKey)MekanismLang.AUTO_EJECT, "Auto-eject");
        this.add((IHasTranslationKey)MekanismLang.AUTO_SORT, "Auto-sort");
        this.add((IHasTranslationKey)MekanismLang.IDLE, "Idle");
        this.add((IHasTranslationKey)MekanismLang.DUMPING_EXCESS, "Dumping Excess");
        this.add((IHasTranslationKey)MekanismLang.DUMPING, "Dumping");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_KEY, " - %s");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_NO_KEY, "No key.");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_BLOCK_TAGS_FOUND, "Block Tag(s) found:");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_FLUID_TAGS_FOUND, "Fluid Tag(s) found:");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_ENTITY_TYPE_TAGS_FOUND, "Entity Type Tag(s) found:");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_TILE_ENTITY_TYPE_TAGS_FOUND, "Tile Entity Type Tag(s) found:");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_TAG_TYPE, "Tag Type:");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_ITEM, "Item");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_ITEM_DESC, "Display Item Tags");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_BLOCK, "Block");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_BLOCK_DESC, "Display Block Tags");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_FLUID, "Fluid");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_FLUID_DESC, "Display Fluid Tags");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_ENTITY_TYPE, "Entity Type");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_ENTITY_TYPE_DESC, "Display Entity Type Tags");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_POTION, "Potion");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_POTION_DESC, "Display Potion Tags");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_ENCHANTMENT, "Enchantment");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_ENCHANTMENT_DESC, "Display Enchantment Tags");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_TILE_ENTITY_TYPE, "Tile Entity Type");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_TILE_ENTITY_TYPE_DESC, "Display Tile Entity Type Tags");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_GAS, "Gas");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_GAS_DESC, "Display Gas Tags");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_INFUSE_TYPE, "Infuse Type");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_INFUSE_TYPE_DESC, "Display Infuse Type Tags");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_PIGMENT, "Pigment");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_PIGMENT_DESC, "Display Pigment Tags");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_SLURRY, "Slurry");
        this.add((IHasTranslationKey)MekanismLang.DICTIONARY_SLURRY_DESC, "Display Slurry Tags");
        this.add((IHasTranslationKey)MekanismLang.LAST_ITEM, "Last Item");
        this.add((IHasTranslationKey)MekanismLang.NEXT_ITEM, "Next Item");
        this.add((IHasTranslationKey)MekanismLang.STATUS, "Status: %s");
        this.add((IHasTranslationKey)MekanismLang.STATUS_OK, "All OK");
        this.add((IHasTranslationKey)MekanismLang.FLUID_CONTAINER_BOTH, "Both");
        this.add((IHasTranslationKey)MekanismLang.FLUID_CONTAINER_FILL, "Fill");
        this.add((IHasTranslationKey)MekanismLang.FLUID_CONTAINER_EMPTY, "Empty");
        this.add((IHasTranslationKey)MekanismLang.YES, "yes");
        this.add((IHasTranslationKey)MekanismLang.NO, "no");
        this.add((IHasTranslationKey)MekanismLang.ON, "on");
        this.add((IHasTranslationKey)MekanismLang.OFF, "off");
        this.add((IHasTranslationKey)MekanismLang.INPUT, "Input");
        this.add((IHasTranslationKey)MekanismLang.OUTPUT, "Output");
        this.add((IHasTranslationKey)MekanismLang.ACTIVE, "Active");
        this.add((IHasTranslationKey)MekanismLang.DISABLED, "Disabled");
        this.add((IHasTranslationKey)MekanismLang.ON_CAPS, "ON");
        this.add((IHasTranslationKey)MekanismLang.OFF_CAPS, "OFF");
        this.add((IHasTranslationKey)MekanismLang.CAPACITY, "Capacity: %s");
        this.add((IHasTranslationKey)MekanismLang.CAPACITY_ITEMS, "Capacity: %s Items");
        this.add((IHasTranslationKey)MekanismLang.CAPACITY_MB, "Capacity: %s mB");
        this.add((IHasTranslationKey)MekanismLang.CAPACITY_PER_TICK, "Capacity: %s/t");
        this.add((IHasTranslationKey)MekanismLang.CAPACITY_MB_PER_TICK, "Capacity: %s mB/t");
        this.add((IHasTranslationKey)MekanismLang.BLOCK_DATA, "Block data: %s");
        this.add((IHasTranslationKey)MekanismLang.BLOCK, "Block: %s");
        this.add((IHasTranslationKey)MekanismLang.TILE, "Tile: %s");
        this.add((IHasTranslationKey)MekanismLang.INGREDIENTS, "Ingredients:");
        this.add((IHasTranslationKey)MekanismLang.ENCODED, "(Encoded)");
        this.add((IHasTranslationKey)MekanismLang.MULTIBLOCK_INCOMPLETE, "Incomplete");
        this.add((IHasTranslationKey)MekanismLang.MULTIBLOCK_FORMED, "Formed");
        this.add((IHasTranslationKey)MekanismLang.MULTIBLOCK_CONFLICT, "Conflict");
        this.add((IHasTranslationKey)MekanismLang.MULTIBLOCK_FORMED_CHAT, "Multiblock Formed");
        this.add((IHasTranslationKey)MekanismLang.UNIVERSAL, "universal");
        this.add((IHasTranslationKey)MekanismLang.ITEMS, "- Items (%s)");
        this.add((IHasTranslationKey)MekanismLang.BLOCKS, "- Blocks (%s)");
        this.add((IHasTranslationKey)MekanismLang.FLUIDS, "- Fluids (%s)");
        this.add((IHasTranslationKey)MekanismLang.GASES, "- Gases (%s)");
        this.add((IHasTranslationKey)MekanismLang.HEAT, "- Heat (%s)");
        this.add((IHasTranslationKey)MekanismLang.CONDUCTION, "Conduction: %s");
        this.add((IHasTranslationKey)MekanismLang.INSULATION, "Insulation: %s");
        this.add((IHasTranslationKey)MekanismLang.HEAT_CAPACITY, "Heat Capacity: %s");
        this.add((IHasTranslationKey)MekanismLang.CAPABLE_OF_TRANSFERRING, "Capable of transferring:");
        this.add((IHasTranslationKey)MekanismLang.DIVERSION_CONTROL_DISABLED, "Always active");
        this.add((IHasTranslationKey)MekanismLang.DIVERSION_CONTROL_HIGH, "Active with signal");
        this.add((IHasTranslationKey)MekanismLang.DIVERSION_CONTROL_LOW, "Active without signal");
        this.add((IHasTranslationKey)MekanismLang.TOGGLE_DIVERTER, "Diverter mode changed to: %s");
        this.add((IHasTranslationKey)MekanismLang.PUMP_RATE, "Pump Rate: %s/s");
        this.add((IHasTranslationKey)MekanismLang.PUMP_RATE_MB, "Pump Rate: %s mB/t");
        this.add((IHasTranslationKey)MekanismLang.SPEED, "Speed: %s m/s");
        this.add((IHasTranslationKey)MekanismLang.CONDENSENTRATOR_TOGGLE, "Toggle operation");
        this.add((IHasTranslationKey)MekanismLang.CONDENSENTRATING, "Condensentrating");
        this.add((IHasTranslationKey)MekanismLang.DECONDENSENTRATING, "Decondensentrating");
        this.add((IHasTranslationKey)MekanismLang.UPGRADE_DISPLAY, "- %s");
        this.add((IHasTranslationKey)MekanismLang.UPGRADE_DISPLAY_LEVEL, "- %s: x%s");
        this.add((IHasTranslationKey)MekanismLang.UPGRADES_EFFECT, "Effect: %sx");
        this.add((IHasTranslationKey)MekanismLang.UPGRADES, "Upgrades");
        this.add((IHasTranslationKey)MekanismLang.UPGRADE_NO_SELECTION, "No selection.");
        this.add((IHasTranslationKey)MekanismLang.UPGRADES_SUPPORTED, "Supported:");
        this.add((IHasTranslationKey)MekanismLang.UPGRADE_COUNT, "Amount: %s/%s");
        this.add((IHasTranslationKey)MekanismLang.UPGRADE_TYPE, "%s Upgrade");
        this.add((IHasTranslationKey)MekanismLang.UPGRADE_NOT_SUPPORTED, "%s (Not Supported)");
        this.add((IHasTranslationKey)MekanismLang.UPGRADE_UNINSTALL, "Uninstall");
        this.add((IHasTranslationKey)MekanismLang.UPGRADE_UNINSTALL_TOOLTIP, "Uninstalls a single upgrade, hold shift to uninstall all.");
        this.add((IHasTranslationKey)MekanismLang.CREATE_FILTER_TITLE, "Create New Filter");
        this.add((IHasTranslationKey)MekanismLang.FILTERS, "Filters:");
        this.add((IHasTranslationKey)MekanismLang.FILTER_COUNT, "T: %s");
        this.add((IHasTranslationKey)MekanismLang.FILTER_ALLOW_DEFAULT, "Allow Default");
        this.add((IHasTranslationKey)MekanismLang.FILTER, "Filter");
        this.add((IHasTranslationKey)MekanismLang.FILTER_NEW, "New: %s");
        this.add((IHasTranslationKey)MekanismLang.FILTER_EDIT, "Edit: %s");
        this.add((IHasTranslationKey)MekanismLang.SORTER_SIZE_MODE, "Size Mode");
        this.add((IHasTranslationKey)MekanismLang.SORTER_SIZE_MODE_CONFLICT, "Size Mode - has no effect currently, because single item mode is turned on.");
        this.add((IHasTranslationKey)MekanismLang.FUZZY_MODE, "Fuzzy Mode");
        this.add((IHasTranslationKey)MekanismLang.MATERIAL_FILTER, "Material Filter");
        this.add((IHasTranslationKey)MekanismLang.MATERIAL_FILTER_DETAILS, "Using material of:");
        this.add((IHasTranslationKey)MekanismLang.TAG_FILTER, "Tag Filter");
        this.add((IHasTranslationKey)MekanismLang.TAG_FILTER_NO_TAG, "No tag");
        this.add((IHasTranslationKey)MekanismLang.TAG_FILTER_SAME_TAG, "Same tag");
        this.add((IHasTranslationKey)MekanismLang.TAG_FILTER_TAG, "Tag: %s");
        this.add((IHasTranslationKey)MekanismLang.MODID_FILTER, "Mod ID Filter");
        this.add((IHasTranslationKey)MekanismLang.MODID_FILTER_NO_ID, "No ID");
        this.add((IHasTranslationKey)MekanismLang.MODID_FILTER_SAME_ID, "Same ID");
        this.add((IHasTranslationKey)MekanismLang.MODID_FILTER_ID, "ID: %s");
        this.add((IHasTranslationKey)MekanismLang.ITEM_FILTER, "Item Filter");
        this.add((IHasTranslationKey)MekanismLang.ITEM_FILTER_NO_ITEM, "No item");
        this.add((IHasTranslationKey)MekanismLang.SORTER_FILTER_SIZE_MODE, "%s!");
        this.add((IHasTranslationKey)MekanismLang.SORTER_FILTER_MAX_LESS_THAN_MIN, "Max < min");
        this.add((IHasTranslationKey)MekanismLang.SORTER_FILTER_OVER_SIZED, "Max > 64");
        this.add((IHasTranslationKey)MekanismLang.SORTER_FILTER_SIZE_MISSING, "Max/min");
        this.add((IHasTranslationKey)MekanismLang.OREDICTIONIFICATOR_FILTER, "Oredictionificator Filter");
        this.add((IHasTranslationKey)MekanismLang.OREDICTIONIFICATOR_FILTER_INVALID_NAMESPACE, "Invalid tag namespace");
        this.add((IHasTranslationKey)MekanismLang.OREDICTIONIFICATOR_FILTER_INVALID_PATH, "Invalid tag path");
        this.add((IHasTranslationKey)MekanismLang.OREDICTIONIFICATOR_FILTER_UNSUPPORTED_TAG, "Unsupported tag");
        this.add((IHasTranslationKey)MekanismLang.WASTE_BARREL_DECAY_RATE, "Decay Rate: %s mB/t");
        this.add((IHasTranslationKey)MekanismLang.WASTE_BARREL_DECAY_RATE_ACTUAL, "Actual Decay Rate: %s mB / %s ticks");
        this.add((IHasTranslationKey)MekanismLang.CHUNK, "Chunk: %s, %s");
        this.add((IHasTranslationKey)MekanismLang.VIBRATING, "Vibrating");
        this.add((IHasTranslationKey)MekanismLang.NEEDS_ENERGY, "Not enough energy to interpret vibration");
        this.add((IHasTranslationKey)MekanismLang.NO_VIBRATIONS, "Unable to discover any vibrations");
        this.add((IHasTranslationKey)MekanismLang.ABUNDANCY, "Abundancy: %s");
        this.add((IHasTranslationKey)MekanismLang.REDSTONE_CONTROL_DISABLED, "Redstone Detection: IGNORED");
        this.add((IHasTranslationKey)MekanismLang.REDSTONE_CONTROL_HIGH, "Redstone Detection: NORMAL");
        this.add((IHasTranslationKey)MekanismLang.REDSTONE_CONTROL_LOW, "Redstone Detection: INVERTED");
        this.add((IHasTranslationKey)MekanismLang.REDSTONE_CONTROL_PULSE, "Redstone Detection: PULSE");
        this.add((IHasTranslationKey)MekanismLang.SECURITY, "Security: %s");
        this.add((IHasTranslationKey)MekanismLang.SECURITY_OVERRIDDEN, "(Overridden)");
        this.add((IHasTranslationKey)MekanismLang.SECURITY_OFFLINE, "Security Offline");
        this.add((IHasTranslationKey)MekanismLang.SECURITY_ADD, "Add:");
        this.add((IHasTranslationKey)MekanismLang.SECURITY_OVERRIDE, "Security Override: %s");
        this.add((IHasTranslationKey)MekanismLang.NO_ACCESS, "You don't have access.");
        this.add((IHasTranslationKey)MekanismLang.TRUSTED_PLAYERS, "Trusted Players");
        this.add((IHasTranslationKey)MekanismLang.PUBLIC, "Public");
        this.add((IHasTranslationKey)MekanismLang.TRUSTED, "Trusted");
        this.add((IHasTranslationKey)MekanismLang.PRIVATE, "Private");
        this.add((IHasTranslationKey)MekanismLang.PUBLIC_MODE, "Public Mode");
        this.add((IHasTranslationKey)MekanismLang.TRUSTED_MODE, "Trusted Mode");
        this.add((IHasTranslationKey)MekanismLang.PRIVATE_MODE, "Private Mode");
        this.add((IHasTranslationKey)MekanismLang.ENCODE_FORMULA, "Encode Formula");
        this.add((IHasTranslationKey)MekanismLang.CRAFT_SINGLE, "Craft Single Item");
        this.add((IHasTranslationKey)MekanismLang.CRAFT_AVAILABLE, "Craft Available Items");
        this.add((IHasTranslationKey)MekanismLang.FILL_EMPTY, "Fill/Empty Grid");
        this.add((IHasTranslationKey)MekanismLang.STOCK_CONTROL, "Stock Control: %s");
        this.add((IHasTranslationKey)MekanismLang.AUTO_MODE, "Auto-Mode: %s");
        this.add((IHasTranslationKey)MekanismLang.FACTORY_TYPE, "Recipe type: %s");
        this.add((IHasTranslationKey)MekanismLang.SMELTING, "Smelting");
        this.add((IHasTranslationKey)MekanismLang.ENRICHING, "Enriching");
        this.add((IHasTranslationKey)MekanismLang.CRUSHING, "Crushing");
        this.add((IHasTranslationKey)MekanismLang.COMPRESSING, "Compressing");
        this.add((IHasTranslationKey)MekanismLang.COMBINING, "Combining");
        this.add((IHasTranslationKey)MekanismLang.PURIFYING, "Purifying");
        this.add((IHasTranslationKey)MekanismLang.INJECTING, "Injecting");
        this.add((IHasTranslationKey)MekanismLang.INFUSING, "Infusing");
        this.add((IHasTranslationKey)MekanismLang.SAWING, "Sawing");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_DESCRIPTION, "[%s] %s transmitters, %s acceptors.");
        this.add((IHasTranslationKey)MekanismLang.INVENTORY_NETWORK, "InventoryNetwork");
        this.add((IHasTranslationKey)MekanismLang.FLUID_NETWORK, "FluidNetwork");
        this.add((IHasTranslationKey)MekanismLang.CHEMICAL_NETWORK, "ChemicalNetwork");
        this.add((IHasTranslationKey)MekanismLang.HEAT_NETWORK, "HeatNetwork");
        this.add((IHasTranslationKey)MekanismLang.ENERGY_NETWORK, "EnergyNetwork");
        this.add((IHasTranslationKey)MekanismLang.NO_NETWORK, "No Network");
        this.add((IHasTranslationKey)MekanismLang.HEAT_NETWORK_STORED, "%s above ambient");
        this.add((IHasTranslationKey)MekanismLang.HEAT_NETWORK_FLOW, "%s transferred to acceptors, %s lost to environment.");
        this.add((IHasTranslationKey)MekanismLang.HEAT_NETWORK_FLOW_EFFICIENCY, "%s transferred to acceptors, %s lost to environment, %s efficiency.");
        this.add((IHasTranslationKey)MekanismLang.FLUID_NETWORK_NEEDED, "%s buckets");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_MB_PER_TICK, "%s mB/t");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_MB_STORED, "%s (%s mB)");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_CONFIRM, "Confirm");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_START, "Start");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_STOP, "Stop");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_CONFIG, "Config");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_REMOVE, "Remove");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_CANCEL, "Cancel");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_SAVE, "Save");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_SET, "Set");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_DELETE, "Delete");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_OPTIONS, "Options");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_TELEPORT, "Teleport");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_NEW_FILTER, "New Filter");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_ITEMSTACK_FILTER, "ItemStack");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_TAG_FILTER, "Tag");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_MATERIAL_FILTER, "Material");
        this.add((IHasTranslationKey)MekanismLang.BUTTON_MODID_FILTER, "Mod ID");
        this.add((IHasTranslationKey)MekanismLang.CONFIG_CARD_GOT, "Retrieved configuration data from %s");
        this.add((IHasTranslationKey)MekanismLang.CONFIG_CARD_SET, "Injected configuration data of type %s");
        this.add((IHasTranslationKey)MekanismLang.CONFIG_CARD_UNEQUAL, "Unequal configuration data formats.");
        this.add((IHasTranslationKey)MekanismLang.CONFIG_CARD_HAS_DATA, "Data: %s");
        this.add((IHasTranslationKey)MekanismLang.CONNECTION_NORMAL, "Normal");
        this.add((IHasTranslationKey)MekanismLang.CONNECTION_PUSH, "Push");
        this.add((IHasTranslationKey)MekanismLang.CONNECTION_PULL, "Pull");
        this.add((IHasTranslationKey)MekanismLang.CONNECTION_NONE, "None");
        this.add((IHasTranslationKey)MekanismLang.TELEPORTER_READY, "Ready");
        this.add((IHasTranslationKey)MekanismLang.TELEPORTER_NO_FRAME, "No frame");
        this.add((IHasTranslationKey)MekanismLang.TELEPORTER_NO_LINK, "No link");
        this.add((IHasTranslationKey)MekanismLang.TELEPORTER_NEEDS_ENERGY, "Needs energy");
        this.add((IHasTranslationKey)MekanismLang.MATRIX, "Induction Matrix");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_RECEIVING_RATE, "Receiving: %s/t");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_OUTPUT_AMOUNT, "Output: %s");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_OUTPUT_RATE, "Output: %s/t");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_OUTPUTTING_RATE, "Outputting: %s/t");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_INPUT_AMOUNT, "Input: %s");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_INPUT_RATE, "Input: %s/t");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_CONSTITUENTS, "Constituents:");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_DIMENSIONS, "Dimensions:");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_DIMENSION_REPRESENTATION, "%s x %s x %s");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_STATS, "Matrix Statistics");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_CELLS, "%s cells");
        this.add((IHasTranslationKey)MekanismLang.MATRIX_PROVIDERS, "%s providers");
        this.add((IHasTranslationKey)MekanismLang.INDUCTION_PORT_MODE, "Toggled Induction Port transfer mode to %s.");
        this.add((IHasTranslationKey)MekanismLang.INDUCTION_PORT_OUTPUT_RATE, "Output Rate: %s");
        this.add((IHasTranslationKey)MekanismLang.MINER_INSUFFICIENT_BUFFER, "Insufficient energy buffer!");
        this.add((IHasTranslationKey)MekanismLang.MINER_BUFFER_FREE, "Free Buffer: %s");
        this.add((IHasTranslationKey)MekanismLang.MINER_TO_MINE, "To mine: %s");
        this.add((IHasTranslationKey)MekanismLang.MINER_SILK_ENABLED, "Silk: %s");
        this.add((IHasTranslationKey)MekanismLang.MINER_AUTO_PULL, "Pull: %s");
        this.add((IHasTranslationKey)MekanismLang.MINER_RUNNING, "Running");
        this.add((IHasTranslationKey)MekanismLang.MINER_LOW_POWER, "Low Power");
        this.add((IHasTranslationKey)MekanismLang.MINER_ENERGY_CAPACITY, "Energy Capacity: %s");
        this.add((IHasTranslationKey)MekanismLang.MINER_MISSING_BLOCK, "Missing block");
        this.add((IHasTranslationKey)MekanismLang.MINER_WELL, "All is well!");
        this.add((IHasTranslationKey)MekanismLang.MINER_CONFIG, "Digital Miner Config");
        this.add((IHasTranslationKey)MekanismLang.MINER_SILK, "Silk touch");
        this.add((IHasTranslationKey)MekanismLang.MINER_RESET, "Reset");
        this.add((IHasTranslationKey)MekanismLang.MINER_INVERSE, "Inverse mode");
        this.add((IHasTranslationKey)MekanismLang.MINER_VISUALS, "Visuals: %s");
        this.add((IHasTranslationKey)MekanismLang.MINER_VISUALS_TOO_BIG, "Radius too big to display visuals");
        this.add((IHasTranslationKey)MekanismLang.MINER_REQUIRE_REPLACE, "Require replace: %s");
        this.add((IHasTranslationKey)MekanismLang.MINER_REQUIRE_REPLACE_INVERSE, "Inverse mode requires replacement: %s");
        this.add((IHasTranslationKey)MekanismLang.MINER_RADIUS, "Radi: %s");
        this.add((IHasTranslationKey)MekanismLang.MINER_IDLE, "Not ready");
        this.add((IHasTranslationKey)MekanismLang.MINER_SEARCHING, "Searching");
        this.add((IHasTranslationKey)MekanismLang.MINER_PAUSED, "Paused");
        this.add((IHasTranslationKey)MekanismLang.MINER_READY, "Ready");
        this.add((IHasTranslationKey)MekanismLang.BOILER, "Thermoelectric Boiler");
        this.add((IHasTranslationKey)MekanismLang.BOILER_STATS, "Boiler Statistics");
        this.add((IHasTranslationKey)MekanismLang.BOILER_MAX_WATER, "Max Water: %s mB");
        this.add((IHasTranslationKey)MekanismLang.BOILER_MAX_STEAM, "Max Steam: %s mB");
        this.add((IHasTranslationKey)MekanismLang.BOILER_HEAT_TRANSFER, "Heat Transfer");
        this.add((IHasTranslationKey)MekanismLang.BOILER_HEATERS, "Superheaters: %s");
        this.add((IHasTranslationKey)MekanismLang.BOILER_CAPACITY, "Boil Capacity: %s mB/t");
        this.add((IHasTranslationKey)MekanismLang.BOIL_RATE, "Boil Rate: %s mB/t");
        this.add((IHasTranslationKey)MekanismLang.MAX_BOIL_RATE, "Max Boil: %s mB/t");
        this.add((IHasTranslationKey)MekanismLang.BOILER_VALVE_MODE_CHANGE, "Valve mode changed to: %s");
        this.add((IHasTranslationKey)MekanismLang.BOILER_VALVE_MODE_INPUT, "input only");
        this.add((IHasTranslationKey)MekanismLang.BOILER_VALVE_MODE_OUTPUT_COOLANT, "output coolant");
        this.add((IHasTranslationKey)MekanismLang.BOILER_VALVE_MODE_OUTPUT_STEAM, "output steam");
        this.add((IHasTranslationKey)MekanismLang.BOILER_WATER_TANK, "Water Tank");
        this.add((IHasTranslationKey)MekanismLang.BOILER_STEAM_TANK, "Steam Tank");
        this.add((IHasTranslationKey)MekanismLang.BOILER_HEATED_COOLANT_TANK, "Heated Coolant Tank");
        this.add((IHasTranslationKey)MekanismLang.BOILER_COOLANT_TANK, "Coolant Tank");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE, "Temp: %s");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE_LONG, "Temperature: %s");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE_KELVIN, "Kelvin");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE_KELVIN_SHORT, "K");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE_CELSIUS, "Celsius");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE_CELSIUS_SHORT, "C");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE_RANKINE, "Rankine");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE_RANKINE_SHORT, "R");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE_FAHRENHEIT, "Fahrenheit");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE_FAHRENHEIT_SHORT, "F");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE_AMBIENT, "Ambient");
        this.add((IHasTranslationKey)MekanismLang.TEMPERATURE_AMBIENT_SHORT, "STP");
        this.add((IHasTranslationKey)MekanismLang.ENERGY_JOULES, "Joule");
        this.add((IHasTranslationKey)MekanismLang.ENERGY_JOULES_PLURAL, "Joules");
        this.add((IHasTranslationKey)MekanismLang.ENERGY_JOULES_SHORT, "J");
        this.add((IHasTranslationKey)MekanismLang.ENERGY_FORGE, "Forge Energy");
        this.add((IHasTranslationKey)MekanismLang.ENERGY_FORGE_SHORT, "FE");
        this.add((IHasTranslationKey)MekanismLang.ENERGY_EU, "Electrical Unit");
        this.add((IHasTranslationKey)MekanismLang.ENERGY_EU_PLURAL, "Electrical Units");
        this.add((IHasTranslationKey)MekanismLang.ENERGY_EU_SHORT, "EU");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_READER_BORDER, "%s %s %1$s");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_READER_TEMPERATURE, " *Temperature: %s");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_READER_TRANSMITTERS, " *Transmitters: %s");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_READER_ACCEPTORS, " *Acceptors: %s");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_READER_NEEDED, " *Needed: %s");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_READER_BUFFER, " *Buffer: %s");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_READER_THROUGHPUT, " *Throughput: %s");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_READER_CAPACITY, " *Capacity: %s");
        this.add((IHasTranslationKey)MekanismLang.NETWORK_READER_CONNECTED_SIDES, " *Connected sides: %s");
        this.add((IHasTranslationKey)MekanismLang.SORTER_DEFAULT, "Default:");
        this.add((IHasTranslationKey)MekanismLang.SORTER_SINGLE_ITEM, "Single:");
        this.add((IHasTranslationKey)MekanismLang.SORTER_ROUND_ROBIN, "RR:");
        this.add((IHasTranslationKey)MekanismLang.SORTER_AUTO_EJECT, "Auto:");
        this.add((IHasTranslationKey)MekanismLang.SORTER_SINGLE_ITEM_DESCRIPTION, "Sends a single item instead of a whole stack each time (overrides min and max set in ItemStack filters).");
        this.add((IHasTranslationKey)MekanismLang.SORTER_ROUND_ROBIN_DESCRIPTION, "Cycles between all connected inventories when sending items.");
        this.add((IHasTranslationKey)MekanismLang.SORTER_AUTO_EJECT_DESCRIPTION, "Ejects unfiltered items automatically to connected inventories, using the default configuration.");
        this.add((IHasTranslationKey)MekanismLang.SIDE_DATA_NONE, "None");
        this.add((IHasTranslationKey)MekanismLang.SIDE_DATA_INPUT, "Input");
        this.add((IHasTranslationKey)MekanismLang.SIDE_DATA_INPUT_1, "Input (1)");
        this.add((IHasTranslationKey)MekanismLang.SIDE_DATA_INPUT_2, "Input (2)");
        this.add((IHasTranslationKey)MekanismLang.SIDE_DATA_OUTPUT, "Output");
        this.add((IHasTranslationKey)MekanismLang.SIDE_DATA_OUTPUT_1, "Output (1)");
        this.add((IHasTranslationKey)MekanismLang.SIDE_DATA_OUTPUT_2, "Output (2)");
        this.add((IHasTranslationKey)MekanismLang.SIDE_DATA_INPUT_OUTPUT, "Input/Output");
        this.add((IHasTranslationKey)MekanismLang.SIDE_DATA_ENERGY, "Energy");
        this.add((IHasTranslationKey)MekanismLang.SIDE_DATA_EXTRA, "Extra");
        this.add((IHasTranslationKey)MekanismLang.FREE_RUNNER_MODE_CHANGE, "Free runner mode changed to: %s");
        this.add((IHasTranslationKey)MekanismLang.FREE_RUNNER_NORMAL, "Regular");
        this.add((IHasTranslationKey)MekanismLang.FREE_RUNNER_DISABLED, "Disabled");
        this.add((IHasTranslationKey)MekanismLang.JETPACK_MODE_CHANGE, "Jetpack mode changed to: %s");
        this.add((IHasTranslationKey)MekanismLang.JETPACK_NORMAL, "Regular");
        this.add((IHasTranslationKey)MekanismLang.JETPACK_HOVER, "Hover");
        this.add((IHasTranslationKey)MekanismLang.JETPACK_DISABLED, "Disabled");
        this.add((IHasTranslationKey)MekanismLang.DISASSEMBLER_MODE_CHANGE, "Mode toggled to: %s (%s)");
        this.add((IHasTranslationKey)MekanismLang.DISASSEMBLER_EFFICIENCY, "Efficiency: %s");
        this.add((IHasTranslationKey)MekanismLang.DISASSEMBLER_NORMAL, "normal");
        this.add((IHasTranslationKey)MekanismLang.DISASSEMBLER_SLOW, "slow");
        this.add((IHasTranslationKey)MekanismLang.DISASSEMBLER_FAST, "fast");
        this.add((IHasTranslationKey)MekanismLang.DISASSEMBLER_VEIN, "vein");
        this.add((IHasTranslationKey)MekanismLang.DISASSEMBLER_OFF, "off");
        this.add((IHasTranslationKey)MekanismLang.FLAMETHROWER_MODE_CHANGE, "Flamethrower mode changed to: %s");
        this.add((IHasTranslationKey)MekanismLang.FLAMETHROWER_COMBAT, "Combat");
        this.add((IHasTranslationKey)MekanismLang.FLAMETHROWER_HEAT, "Heat");
        this.add((IHasTranslationKey)MekanismLang.FLAMETHROWER_INFERNO, "Inferno");
        this.add((IHasTranslationKey)MekanismLang.CONFIGURE_STATE, "Configure State: %s");
        this.add((IHasTranslationKey)MekanismLang.STATE, "State: %s");
        this.add((IHasTranslationKey)MekanismLang.TOGGLE_COLOR, "Color bumped to: %s");
        this.add((IHasTranslationKey)MekanismLang.CURRENT_COLOR, "Current color: %s");
        this.add((IHasTranslationKey)MekanismLang.PUMP_RESET, "Reset Electric Pump calculation");
        this.add((IHasTranslationKey)MekanismLang.PLENISHER_RESET, "Reset Fluidic Plenisher calculation");
        this.add((IHasTranslationKey)MekanismLang.REDSTONE_SENSITIVITY, "Redstone sensitivity turned: %s");
        this.add((IHasTranslationKey)MekanismLang.CONNECTION_TYPE, "Connection type changed to: %s");
        this.add((IHasTranslationKey)MekanismLang.CONFIGURATOR_VIEW_MODE, "Current %s behavior: %s (%s)");
        this.add((IHasTranslationKey)MekanismLang.CONFIGURATOR_TOGGLE_MODE, "%s behavior bumped to: %s (%s)");
        this.add((IHasTranslationKey)MekanismLang.CONFIGURATOR_CONFIGURATE, "Configurate (%s)");
        this.add((IHasTranslationKey)MekanismLang.CONFIGURATOR_EMPTY, "Empty");
        this.add((IHasTranslationKey)MekanismLang.CONFIGURATOR_ROTATE, "Rotate");
        this.add((IHasTranslationKey)MekanismLang.CONFIGURATOR_WRENCH, "Wrench");
        this.add((IHasTranslationKey)MekanismLang.ROBIT, "Robit");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_NAME, "Name: %s");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_SMELTING, "Robit Smelting");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_CRAFTING, "Robit Crafting");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_INVENTORY, "Robit Inventory");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_REPAIR, "Robit Repair");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_TELEPORT, "Teleport back home");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_TOGGLE_PICKUP, "Toggle 'drop pickup' mode");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_RENAME, "Rename this Robit");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_SKIN, "Skin: %s");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_SKIN_SELECT, "Change this Robit's appearance");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_TOGGLE_FOLLOW, "Toggle 'follow' mode");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_GREETING, "Hi, I'm %s!");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_OWNER, "Owner: %s");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_FOLLOWING, "Following: %s");
        this.add((IHasTranslationKey)MekanismLang.ROBIT_DROP_PICKUP, "Drop pickup: %s");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_QIO_DRIVE_ARRAY, "The foundation of any Quantum Item Orchestration system. QIO Drives are stored here.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_QIO_DASHBOARD, "A placeable monitor used to access an Quantum Item Orchestration system's contents.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_QIO_IMPORTER, "A QIO-linked item import unit. Place on a block and import its contents to your QIO system.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_QIO_EXPORTER, "A QIO-linked item export unit. Place on a block and export contents from your QIO system to the block.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_QIO_REDSTONE_ADAPTER, "A QIO-linked redstone adapter. Use to monitor your QIO system's contents.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_DICTIONARY, "A tool used for viewing the tags of various components such as: items, blocks, and fluids.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_SEISMIC_READER, "A portable machine that uses seismic vibrations to provide information on differing layers of the world.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_BIN, "A block used to store large quantities of a single type of item.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_TELEPORTER_FRAME, "The frame used to construct the Teleporter multiblock, allowing a portal to be generated within the structure.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_STEEL_CASING, "A sturdy, steel-based casing used as a foundation for machinery.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_DYNAMIC_TANK, "The casing used in the Dynamic Tank multiblock, a structure capable of storing great amounts of fluid and chemicals.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_STRUCTURAL_GLASS, "An advanced, reinforced material of glass that drops when broken and can be used in the structure of any applicable multiblock.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_DYNAMIC_VALVE, "A valve that can be placed on a Dynamic Tank multiblock, allowing for fluids and chemicals to be inserted and extracted via external piping.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_THERMAL_EVAPORATION_CONTROLLER, "The controller for a Thermal Evaporation Plant, acting as the master block of the structure. Only one of these should be placed on a multiblock.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_THERMAL_EVAPORATION_VALVE, "A valve that can be placed on a Thermal Evaporation Plant multiblock, allowing for fluids to be inserted and extracted via external piping.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_THERMAL_EVAPORATION_BLOCK, "A copper-alloyed casing used in the structure of a Thermal Evaporation Plant, using its advanced material to conduct the great amounts of heat necessary for processing.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_INDUCTION_CASING, "A type of energy-resistant casing used in the creation of an Energized Induction Matrix multiblock.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_INDUCTION_PORT, "A port that can be placed on an Energized Induction Matrix multiblock, allowing for energy to be inserted from and output to external cabling.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_INDUCTION_CELL, "A highly conductive energy capacitor capable of storing massive amounts of energy in a single block. Housed in an Energized Induction Matrix to expand the multiblock's energy storage.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_INDUCTION_PROVIDER, "An advanced complex of coolant systems, conductors and transformers capable of expanding the Energized Induction Matrix's maximum rate of energy transfer.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_SUPERHEATING_ELEMENT, "A modular, somewhat dangerous radiator that is capable of emitting massive amounts of heat to its surroundings.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_PRESSURE_DISPERSER, "A block used to disperse steam throughout a multiblock structure. These should form a gapless, horizontal plane in order to properly control steam flow.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_BOILER_CASING, "A pressure-resistant, dense casing used in the creation of a Thermoelectric Boiler multiblock.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_BOILER_VALVE, "A valve that can be placed on a Thermoelectric Boiler multiblock, allowing for the insertion of energy and water along with the extraction of produced steam.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_SECURITY_DESK, "A central control hub for managing the security of all your owned machinery.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_ENRICHMENT_CHAMBER, "A simple machine used to enrich ores into two of their dust counterparts, as well as perform many other operations.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_OSMIUM_COMPRESSOR, "A fairly advanced machine used to compress osmium into various dusts in order to create their ingot counterparts.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_COMBINER, "A machine used to combine items together. For example, dusts and cobblestone to form their ore counterparts.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_CRUSHER, "A machine used to crush ingots into their dust counterparts, as well as perform many other operations.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_DIGITAL_MINER, "A highly-advanced, filter-based, auto-miner that can mine whatever block you tell it to within a 32 block (max) radius.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_METALLURGIC_INFUSER, "A machine used to infuse various materials into (generally) metals to create metal alloys and other compounds.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_PURIFICATION_CHAMBER, "An advanced machine capable of processing ores into three clumps, serving as the initial stage of 300% ore processing.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_ENERGIZED_SMELTER, "A simple machine that serves as a Mekanism-based furnace that runs off of energy.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_TELEPORTER, "A machine capable of teleporting players to various locations defined by another teleporter.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_ELECTRIC_PUMP, "An advanced, upgradeable pump, capable of extracting any type of fluid.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_PERSONAL_CHEST, "A 54-slot chest that can be opened anywhere- even from your own inventory.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_CHARGEPAD, "A universal chargepad that can charge any energized item from any mod.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_LOGISTICAL_SORTER, "A filter-based, advanced sorting machine that can auto-eject specified items out of and into adjacent inventories and Logistical Transporters.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_ROTARY_CONDENSENTRATOR, "A machine capable of converting gases into their fluid form and vice versa.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_CHEMICAL_INJECTION_CHAMBER, "An elite machine capable of processing ores into four shards, serving as the initial stage of 400% ore processing.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_ELECTROLYTIC_SEPARATOR, "A machine that uses the process of electrolysis to split apart a certain gas into two different gases.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_PRECISION_SAWMILL, "A machine used to process logs and other wood-based items more efficiently, as well as to obtain sawdust.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_CHEMICAL_DISSOLUTION_CHAMBER, "An ultimate machine used to chemically dissolve all impurities of an ore, leaving an unprocessed slurry behind.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_CHEMICAL_WASHER, "An ultimate machine that cleans unprocessed slurry and prepares it for crystallization.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_CHEMICAL_CRYSTALLIZER, "An ultimate machine used to crystallize purified ore slurry into ore crystals.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_CHEMICAL_OXIDIZER, "A machine capable of oxidizing solid materials into gas phase.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_CHEMICAL_INFUSER, "A machine that produces a new gas by infusing two others.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_SEISMIC_VIBRATOR, "A machine that uses seismic vibrations to provide information on differing layers of the world.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_PRESSURIZED_REACTION_CHAMBER, "An advanced machine that processes a solid, liquid and gaseous mixture and creates both a gaseous and solid product.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_FLUID_TANK, "A handy, sturdy, portable tank that lets you carry multiple buckets of fluid wherever you please. Also doubles as a bucket!");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_FLUIDIC_PLENISHER, "A machine that is capable of creating entire lakes by filling ravines with fluids.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_LASER, "An advanced form of linear energy transfer that utilizes an extremely collimated beam of light.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_LASER_AMPLIFIER, "A block that can be used to merge, redirect and amplify laser beams, with fine controls over when to fire.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_LASER_TRACTOR_BEAM, "A block used to merge and redirect laser beams. Collects drops from blocks it has broken.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_SOLAR_NEUTRON_ACTIVATOR, "A machine that directs the neutron radiation of the sun into its internal reservoir, allowing for the slow creation of various isotopes.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_OREDICTIONIFICATOR, "A machine used to unify and translate between various items and blocks using the Ore Dictionary.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_FACTORY, "A machine that serves as an upgrade to regular machinery, allowing for multiple processing operations to occur at once.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_RESISTIVE_HEATER, "A condensed, coiled resistor capable of converting electrical energy directly into heat energy.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_FORMULAIC_ASSEMBLICATOR, "A machine that uses energy to rapidly craft items and blocks from Crafting Formulas. Doubles as an advanced crafting bench.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_FUELWOOD_HEATER, "A machine that is capable of producing large quantities of heat energy by burning combustible items.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_MODIFICATION_STATION, "An advanced workbench capable of installing and removing modules from modular equipment (i.e. MekaSuit!)");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_ISOTOPIC_CENTRIFUGE, "A machine with one single purpose: to spin its contents really, REALLY fast.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_QUANTUM_ENTANGLOPORTER, "A highly-advanced block capable of transmitting any practical resource across long distances and dimensions.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_NUTRITIONAL_LIQUIFIER, "A machine that is capable of processing any foods into non-dangerous, easily-digestible Nutritional Paste.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_ANTIPROTONIC_NUCLEOSYNTHESIZER, "A machine which uses bits of antimatter and mass amounts of energy to atomically transmute various resources.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_PIGMENT_EXTRACTOR, "A machine used to extract pigments from blocks and items.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_PIGMENT_MIXER, "A sturdy machine capable of mixing two pigments together to produce a new pigment.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_PAINTING_MACHINE, "A machine used to color blocks and items via a careful application of a stored pigment.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_RADIOACTIVE_WASTE_BARREL, "A barrel that can be used to 'safely' store radioactive waste. WARNING: breaking this barrel will release its contents into the atmosphere.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_INDUSTRIAL_ALARM, "Not just your everyday alarm... this is an 'industrial' alarm!");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_ENERGY_CUBE, "An advanced device for storing and distributing energy.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_CHEMICAL_TANK, "A portable tank that lets you carry chemicals wherever you please.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_DIVERSION, "- Controllable by redstone");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_RESTRICTIVE, "- Only used if no other paths available");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_SPS_CASING, "Reinforced casing capable of resisting intense chemical and thermal effects from phase-shifting reactions.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_SPS_PORT, "A port used for the transfer of energy and substances in the Supercritical Phase Shifter.");
        this.add((IHasTranslationKey)MekanismLang.DESCRIPTION_SUPERCHARGED_COIL, "Used in Supercritical Phase Shifter multiblock to supply large quantities of energy. Must be attached to a SPS Port.");
        this.add((IHasTranslationKey)MekanismLang.MODULE_ENABLED, "Enabled");
        this.add((IHasTranslationKey)MekanismLang.MODULE_ENABLED_LOWER, "enabled");
        this.add((IHasTranslationKey)MekanismLang.MODULE_DISABLED_LOWER, "disabled");
        this.add((IHasTranslationKey)MekanismLang.MODULE_DAMAGE, "Damage: %s");
        this.add((IHasTranslationKey)MekanismLang.MODULE_TWEAKER, "Module Tweaker");
        this.add((IHasTranslationKey)MekanismLang.MODULE_INSTALLED, "Installed: %s");
        this.add((IHasTranslationKey)MekanismLang.MODULE_STACKABLE, "Stackable: %s");
        this.add((IHasTranslationKey)MekanismLang.MODULE_EXCLUSIVE, "(Exclusive Module)");
        this.add((IHasTranslationKey)MekanismLang.MODULE_HANDLE_MODE_CHANGE, "Handle Mode Key");
        this.add((IHasTranslationKey)MekanismLang.MODULE_RENDER_HUD, "Show in HUD");
        this.add((IHasTranslationKey)MekanismLang.MODULE_MODE, "Mode");
        this.add((IHasTranslationKey)MekanismLang.MODULE_ATTACK_DAMAGE, "Attack Damage");
        this.add((IHasTranslationKey)MekanismLang.MODULE_FARMING_RADIUS, "Farming Radius");
        this.add((IHasTranslationKey)MekanismLang.MODULE_JUMP_BOOST, "Jump Boost");
        this.add((IHasTranslationKey)MekanismLang.MODULE_STEP_ASSIST, "Step Assist");
        this.add((IHasTranslationKey)MekanismLang.MODULE_RANGE, "Range");
        this.add((IHasTranslationKey)MekanismLang.MODULE_SPRINT_BOOST, "Sprint Boost");
        this.add((IHasTranslationKey)MekanismLang.MODULE_EXTENDED_MODE, "Extended Mode");
        this.add((IHasTranslationKey)MekanismLang.MODULE_EXTENDED_ENABLED, "Extended Vein Mining: %s");
        this.add((IHasTranslationKey)MekanismLang.MODULE_EXCAVATION_RANGE, "Excavation Range");
        this.add((IHasTranslationKey)MekanismLang.MODULE_EFFICIENCY, "Efficiency");
        this.add((IHasTranslationKey)MekanismLang.MODULE_MODE_CHANGE, "%s bumped to: %s");
        this.add((IHasTranslationKey)MekanismLang.MODULE_JETPACK_MODE, "Jetpack Mode");
        this.add((IHasTranslationKey)MekanismLang.MODULE_GRAVITATIONAL_MODULATION, "Gravitational Modulation");
        this.add((IHasTranslationKey)MekanismLang.MODULE_MAGNETIC_ATTRACTION, "Magnetic Attraction");
        this.add((IHasTranslationKey)MekanismLang.MODULE_CHARGE_SUIT, "Charge Suit");
        this.add((IHasTranslationKey)MekanismLang.MODULE_CHARGE_INVENTORY, "Charge Inventory");
        this.add((IHasTranslationKey)MekanismLang.MODULE_SPEED_BOOST, "Speed Boost");
        this.add((IHasTranslationKey)MekanismLang.MODULE_VISION_ENHANCEMENT, "Vision Enhancement");
        this.add((IHasTranslationKey)MekanismLang.MODULE_BREATHING_HELD, "Fill Held");
        this.add((IHasTranslationKey)MekanismLang.MODULE_PURIFICATION_BENEFICIAL, "Remove Beneficial");
        this.add((IHasTranslationKey)MekanismLang.MODULE_PURIFICATION_NEUTRAL, "Remove Neutral");
        this.add((IHasTranslationKey)MekanismLang.MODULE_PURIFICATION_HARMFUL, "Remove Harmful");
        this.add((IHasTranslationKey)MekanismLang.MODULE_TELEPORT_REQUIRES_BLOCK, "Requires Block Target");
        this.add((IModuleDataProvider<?>)MekanismModules.ENERGY_UNIT, "Energy Unit", "Increases maximum energy capacity.");
        this.add((IModuleDataProvider<?>)MekanismModules.LASER_DISSIPATION_UNIT, "Laser Dissipation Unit", "Refracts and safely dissipates lasers that hit any MekaSuit armor piece.");
        this.add((IModuleDataProvider<?>)MekanismModules.RADIATION_SHIELDING_UNIT, "Radiation Shielding Unit", "Provides thick, radiation-proof metal plating to any MekaSuit armor piece.");
        this.add((IModuleDataProvider<?>)MekanismModules.EXCAVATION_ESCALATION_UNIT, "Excavation Escalation Unit", "Increases digging speed on any block.");
        this.add((IModuleDataProvider<?>)MekanismModules.ATTACK_AMPLIFICATION_UNIT, "Attack Amplification Unit", "Amplifies melee attacks on players or mobs.");
        this.add((IModuleDataProvider<?>)MekanismModules.SILK_TOUCH_UNIT, "Silk Touch Unit", "Allows all mined blocks to drop as themselves.");
        this.add((IModuleDataProvider<?>)MekanismModules.VEIN_MINING_UNIT, "Vein Mining Unit", "Allows for quick mining of ore deposits and rapid felling of trees.");
        this.add((IModuleDataProvider<?>)MekanismModules.FARMING_UNIT, "Farming Unit", "Allows for soil tilling, log stripping, and soil flattening.");
        this.add((IModuleDataProvider<?>)MekanismModules.SHEARING_UNIT, "Shearing Unit", "Allows the creation of energy blades for precise cutting jobs. Does not add laser swords.");
        this.add((IModuleDataProvider<?>)MekanismModules.TELEPORTATION_UNIT, "Teleportation Unit", "Provides for quick travel to nearby blocks.");
        this.add((IModuleDataProvider<?>)MekanismModules.ELECTROLYTIC_BREATHING_UNIT, "Electrolytic Breathing Unit", "Uses electrolysis to create breathable oxygen from water. Will also fill a jetpack module with hydrogen when necessary.");
        this.add((IModuleDataProvider<?>)MekanismModules.INHALATION_PURIFICATION_UNIT, "Inhalation Purification Unit", "Applies a miniature electromagnetic field around the breathing apparatus, preventing selected potion effect types.");
        this.add((IModuleDataProvider<?>)MekanismModules.VISION_ENHANCEMENT_UNIT, "Vision Enhancement Unit", "Brightens the surrounding environment, allowing the user to see through darkness. Install multiple for more effective night vision.");
        this.add((IModuleDataProvider<?>)MekanismModules.SOLAR_RECHARGING_UNIT, "Solar Recharging Unit", "Harnesses the power of the sun to charge your MekaSuit. Install multiple for faster charging. Requires Mekanism: Generators.");
        this.add((IModuleDataProvider<?>)MekanismModules.NUTRITIONAL_INJECTION_UNIT, "Nutritional Injection Unit", "Automatically feeds the player Nutritional Paste when hungry.");
        this.add((IModuleDataProvider<?>)MekanismModules.JETPACK_UNIT, "Jetpack Unit", "Applies a hydrogen-fueled jetpack to the MekaSuit.");
        this.add((IModuleDataProvider<?>)MekanismModules.GRAVITATIONAL_MODULATING_UNIT, "Gravitational Modulating Unit", "Using experimental technologies and the tremendous energy of antimatter, allows the user to defy gravity.");
        this.add((IModuleDataProvider<?>)MekanismModules.ELYTRA_UNIT, "Elytra Unit", "Applies an HDPE Reinforced Elytra to the MekaSuit.");
        this.add((IModuleDataProvider<?>)MekanismModules.CHARGE_DISTRIBUTION_UNIT, "Charge Distribution Unit", "Evenly distributes charge throughout all worn MekaSuit armor.");
        this.add((IModuleDataProvider<?>)MekanismModules.DOSIMETER_UNIT, "Dosimeter Unit", "Displays the user's current radiation dose in the HUD.");
        this.add((IModuleDataProvider<?>)MekanismModules.GEIGER_UNIT, "Geiger Unit", "Displays the ambient radiation level in the HUD.");
        this.add((IModuleDataProvider<?>)MekanismModules.LOCOMOTIVE_BOOSTING_UNIT, "Locomotive Boosting Unit", "Increases the user's sprinting speed (and jumping distance).");
        this.add((IModuleDataProvider<?>)MekanismModules.HYDRAULIC_PROPULSION_UNIT, "Hydraulic Propulsion Unit", "Allows the user to both step and jump higher.");
        this.add((IModuleDataProvider<?>)MekanismModules.MAGNETIC_ATTRACTION_UNIT, "Magnetic Attraction Unit", "Uses powerful magnets to draw distant items towards the player. Install multiple for a greater range.");
        this.add((IModuleDataProvider<?>)MekanismModules.FROST_WALKER_UNIT, "Frost Walker Unit", "Uses liquid hydrogen to freeze any water the player walks on. Install multiple for a greater range.");
    }

    private void addOre(OreType type, String description) {
        BlockRegistryObject oreRO = (BlockRegistryObject)MekanismBlocks.ORES.get(type);
        this.add((IHasTranslationKey)oreRO, MekanismLangProvider.formatAndCapitalize(type.getResource().getRegistrySuffix()) + " Ore");
        this.add(((BlockOre)oreRO.getBlock()).getDescriptionTranslationKey(), description);
    }

    private void addTiered(IItemProvider basic, IItemProvider advanced, IItemProvider elite, IItemProvider ultimate, String name) {
        this.add((IHasTranslationKey)basic, "Basic " + name);
        this.add((IHasTranslationKey)advanced, "Advanced " + name);
        this.add((IHasTranslationKey)elite, "Elite " + name);
        this.add((IHasTranslationKey)ultimate, "Ultimate " + name);
    }

    private void addTiered(IItemProvider basic, IItemProvider advanced, IItemProvider elite, IItemProvider ultimate, IItemProvider creative, String name) {
        this.addTiered(basic, advanced, elite, ultimate, name);
        this.add((IHasTranslationKey)creative, "Creative " + name);
    }
}

