/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen.lang;

import igentuman.bfr.common.datagen.lang.ConvertibleLanguageProvider;
import igentuman.bfr.common.datagen.lang.FormatSplitter;
import igentuman.bfr.common.datagen.lang.UpsideDownLanguageProvider;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.IHasTranslationKey;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.registration.impl.FluidRegistryObject;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class BaseLanguageProvider
extends LanguageProvider {
    private final ConvertibleLanguageProvider[] altProviders;
    private final String modid;

    public BaseLanguageProvider(DataGenerator gen, String modid) {
        super(gen, modid, "en_us");
        this.modid = modid;
        this.altProviders = new ConvertibleLanguageProvider[]{new UpsideDownLanguageProvider(gen, modid)};
    }

    @Nonnull
    public String func_200397_b() {
        return super.func_200397_b() + ": " + this.modid;
    }

    protected void add(IHasTranslationKey key, String value) {
        Block block;
        if (key instanceof IBlockProvider && Attribute.has((Block)(block = ((IBlockProvider)key).getBlock()), AttributeGui.class)) {
            this.add(Util.func_200697_a((String)"container", (ResourceLocation)block.getRegistryName()), value);
        }
        this.add(key.getTranslationKey(), value);
    }

    protected void add(IModuleDataProvider<?> moduleDataProvider, String name, String description) {
        ModuleData moduleData = moduleDataProvider.getModuleData();
        this.add(moduleData.getTranslationKey(), name);
        this.add(moduleData.getDescriptionTranslationKey(), description);
    }

    protected void addFluid(FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, FlowingFluidBlock, BucketItem> fluidRO, String name) {
        this.add(((ForgeFlowingFluid.Source)fluidRO.getStillFluid()).getAttributes().getTranslationKey(), name);
        this.add(((ForgeFlowingFluid.Flowing)fluidRO.getFlowingFluid()).getAttributes().getTranslationKey(), "Flowing " + name);
        this.add((Block)fluidRO.getBlock(), name);
        this.add((Item)fluidRO.getBucket(), name + " Bucket");
    }

    public void add(@Nonnull String key, @Nonnull String value) {
        super.add(key, value);
        if (this.altProviders.length > 0) {
            List<FormatSplitter.Component> splitEnglish = FormatSplitter.split(value);
            for (ConvertibleLanguageProvider provider : this.altProviders) {
                provider.convert(key, splitEnglish);
            }
        }
    }

    public void func_200398_a(@Nonnull DirectoryCache cache) throws IOException {
        super.func_200398_a(cache);
        if (this.altProviders.length > 0) {
            for (ConvertibleLanguageProvider provider : this.altProviders) {
                provider.func_200398_a(cache);
            }
        }
    }
}

