/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.datagen;

import igentuman.bfr.common.datagen.recipe.BaseRecipeProvider;
import igentuman.bfr.common.datagen.recipe.builder.ExtendedShapedRecipeBuilder;
import igentuman.bfr.common.datagen.recipe.pattern.RecipePattern;
import igentuman.bfr.common.registries.BfrBlocks;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.resource.ResourceType;
import mekanism.common.tags.MekanismTags;
import mekanism.generators.common.MekanismGenerators;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;

@ParametersAreNonnullByDefault
public class BfrRecipeProvider
extends BaseRecipeProvider {
    private static final char GLASS_CHAR = 'G';
    private static final char FRAME_CHAR = 'F';

    public BfrRecipeProvider(DataGenerator gen, ExistingFileHelper existingFileHelper) {
        super(gen, existingFileHelper, "bfr");
    }

    @Override
    protected void addRecipes(Consumer<IFinishedRecipe> consumer) {
        this.addFusionReactorRecipes(consumer);
    }

    private void addFusionReactorRecipes(Consumer<IFinishedRecipe> consumer) {
        ExtendedShapedRecipeBuilder.shapedRecipe(BfrBlocks.LASER_FOCUS_MATRIX, 2).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of(' ', 'G', ' '), RecipePattern.TripleLine.of('G', 'R', 'G'), RecipePattern.TripleLine.of(' ', 'G', ' '))).key('G', (IItemProvider)BfrBlocks.REACTOR_GLASS).key('R', (ITag<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE).build(consumer);
        ExtendedShapedRecipeBuilder.shapedRecipe(BfrBlocks.FUSION_REACTOR_FRAME, 4).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('A', '#', 'A'), RecipePattern.TripleLine.of('#', 'X', '#'), RecipePattern.TripleLine.of('A', '#', 'A'))).key('X', (IItemProvider)MekanismBlocks.STEEL_CASING).key('A', (ITag<Item>)MekanismTags.Items.ALLOYS_ULTIMATE).key('#', (ITag<Item>)MekanismTags.Items.PELLETS_POLONIUM).build(consumer, MekanismGenerators.rl((String)"reactor/frame"));
        ExtendedShapedRecipeBuilder.shapedRecipe(BfrBlocks.REACTOR_GLASS, 4).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('S', 'I', 'S'), RecipePattern.TripleLine.of('I', 'G', 'I'), RecipePattern.TripleLine.of('S', 'I', 'S'))).key('G', (ITag<Item>)Tags.Items.GLASS).key('I', (ITag<Item>)((ITag)MekanismTags.Items.PROCESSED_RESOURCES.get((Object)ResourceType.INGOT, (Object)PrimaryResource.LEAD))).key('S', (IItemProvider)MekanismItems.ENRICHED_IRON).build(consumer, MekanismGenerators.rl((String)"reactor/glass"));
        ExtendedShapedRecipeBuilder.shapedRecipe(BfrBlocks.FUSION_REACTOR_PORT, 2).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of(' ', 'F', ' '), RecipePattern.TripleLine.of('F', 'C', 'F'), RecipePattern.TripleLine.of(' ', 'F', ' '))).key('C', (ITag<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('F', (IItemProvider)BfrBlocks.FUSION_REACTOR_FRAME).build(consumer, MekanismGenerators.rl((String)"reactor/port"));
        ExtendedShapedRecipeBuilder.shapedRecipe(BfrBlocks.FUSION_REACTOR_LOGIC_ADAPTER).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of(' ', 'R', ' '), RecipePattern.TripleLine.of('R', 'F', 'R'), RecipePattern.TripleLine.of(' ', 'R', ' '))).key('F', (IItemProvider)BfrBlocks.FUSION_REACTOR_FRAME).key('R', (ITag<Item>)Tags.Items.DUSTS_REDSTONE).build(consumer, MekanismGenerators.rl((String)"reactor/logic_adapter"));
        ExtendedShapedRecipeBuilder.shapedRecipe(BfrBlocks.FUSION_REACTOR_CONTROLLER).pattern(RecipePattern.createPattern(RecipePattern.TripleLine.of('C', 'G', 'C'), RecipePattern.TripleLine.of('F', 'T', 'F'), RecipePattern.TripleLine.of('F', 'F', 'F'))).key('C', (ITag<Item>)MekanismTags.Items.CIRCUITS_ULTIMATE).key('G', (ITag<Item>)Tags.Items.GLASS_PANES).key('F', (IItemProvider)BfrBlocks.FUSION_REACTOR_FRAME).key('T', (IItemProvider)MekanismBlocks.BASIC_CHEMICAL_TANK).build(consumer, MekanismGenerators.rl((String)"reactor/controller"));
    }
}

