/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.content.fusion;

import igentuman.bfr.common.config.BetterFusionReactorConfig;
import igentuman.bfr.common.slot.ReactorInventorySlot;
import igentuman.bfr.common.tile.fusion.TileEntityFusionReactorBlock;
import igentuman.bfr.common.tile.fusion.TileEntityFusionReactorPort;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.MultiblockFluidTank;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.capabilities.heat.MultiblockHeatCapacitor;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.GeneratorTags;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.item.ItemHohlraum;
import mekanism.generators.common.registries.GeneratorsGases;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class FusionReactorMultiblockData
extends MultiblockData {
    private static final FloatingLong MAX_ENERGY = FloatingLong.createConst((long)1000000000L);
    private static final int MAX_WATER = 1000000;
    private static final long MAX_STEAM = 100000000L;
    private static final long MAX_FUEL = 1000L;
    public static final int MAX_INJECTION = 98;
    private static final double burnTemperature = 1.0E8;
    private static final double burnRatio = 1.0;
    private static final double plasmaHeatCapacity = 100.0;
    private static final double caseHeatCapacity = 1.0;
    private static final double inverseInsulation = 100000.0;
    private static final double plasmaCaseConductivity = 0.2;
    private final Set<ITileHeatHandler> heatHandlers = new ObjectOpenHashSet();
    @ContainerSync
    private boolean burning = false;
    @ContainerSync
    public IEnergyContainer energyContainer;
    public IHeatCapacitor heatCapacitor;
    @ContainerSync(tags={"heat"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getWater", "getWaterCapacity", "getWaterNeeded", "getWaterFilledPercentage"})
    public IExtendedFluidTank waterTank;
    @ContainerSync(tags={"heat"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getSteam", "getSteamCapacity", "getSteamNeeded", "getSteamFilledPercentage"})
    public IGasTank steamTank;
    private double biomeAmbientTemp;
    @ContainerSync(tags={"heat"})
    @SyntheticComputerMethod(getter="getPlasmaTemperature")
    private double lastPlasmaTemperature;
    @ContainerSync
    @SyntheticComputerMethod(getter="getCaseTemperature")
    private double lastCaseTemperature;
    @ContainerSync(tags={"fuel"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getDeuterium", "getDeuteriumCapacity", "getDeuteriumNeeded", "getDeuteriumFilledPercentage"})
    public IGasTank deuteriumTank;
    @ContainerSync(tags={"fuel"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getTritium", "getTritiumCapacity", "getTritiumNeeded", "getTritiumFilledPercentage"})
    public IGasTank tritiumTank;
    @ContainerSync(tags={"fuel"})
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getDTFuel", "getDTFuelCapacity", "getDTFuelNeeded", "getDTFuelFilledPercentage"})
    public IGasTank fuelTank;
    @ContainerSync(tags={"fuel", "heat"}, getter="getInjectionRate", setter="setInjectionRate")
    private int injectionRate = 2;
    public double plasmaTemperature;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getHohlraum"})
    private final ReactorInventorySlot reactorSlot;
    private boolean clientBurning;
    private double clientTemp;
    private AxisAlignedBB deathZone;
    protected int laserShootCountdown = 0;
    protected int laserShootEnergyDuration = 12000;
    public double laserShootMinEnergy = 5.0E8;
    protected float currentReactivity = 0.0f;
    protected float targetReactivity = 0.0f;
    protected float errorLevel = 0.0f;
    protected float adjustment = 0.0f;
    protected int reactivityUpdateTicks = 10000;
    protected int currentReactivityTick = 0;
    protected int adjustmentTicks = 100;
    protected float difficulty = 10.0f;
    public boolean explodeFlag = false;

    public float getTargetReactivity() {
        return this.targetReactivity;
    }

    @ComputerMethod
    public float getEfficiency() {
        if (!this.isBurning()) {
            return 0.0f;
        }
        return (float)Math.min(100.0, Math.max(0.0, 1.0 / ((double)(Math.abs(this.targetReactivity - this.currentReactivity) / 100.0f) + 0.2) * 22.0) - 10.0);
    }

    public void setAdjustment(float val) {
        this.adjustment = val;
    }

    public float getAdjustment() {
        return this.adjustment;
    }

    public float getCurrentReactivity() {
        return this.currentReactivity;
    }

    public void setTargetReactivity(float val) {
        this.targetReactivity = Math.abs(val);
    }

    public void setCurrentReactivity(float val) {
        this.currentReactivity = Math.abs(val);
    }

    @ComputerMethod
    public float getErrorLevel() {
        return this.errorLevel;
    }

    protected void setErrorLevel(float val) {
        this.errorLevel = val;
    }

    public int getLaserShootCountdown() {
        return this.laserShootCountdown;
    }

    protected void setLaserShootCountdown(int val) {
        this.laserShootCountdown = val;
    }

    public void processLaserShoot(FloatingLong laserEnergy) {
        if (laserEnergy.greaterOrEqual(FloatingLong.create((double)this.laserShootMinEnergy)) && this.laserShootCountdown == 0) {
            this.laserShootCountdown = this.laserShootEnergyDuration;
        }
    }

    protected void laserShootCount() {
        if (this.laserShootCountdown > 0) {
            --this.laserShootCountdown;
        }
    }

    public float getKt() {
        if (this.laserShootEnergyDuration - this.getLaserShootCountdown() < 1200) {
            return 0.0f;
        }
        float tDevide = 20.0f;
        if (this.isActiveCooled()) {
            tDevide = 30.0f;
        }
        return (float)Math.pow((float)Math.abs(Math.sqrt((float)this.getLastPlasmaTemp() / 2000000.0f) - 40.0) / tDevide, 2.0);
    }

    protected void updateErrorLevel() {
        if (this.isBurning()) {
            float shift = (80.0f - this.getEfficiency()) * ((this.getKt() + 1.0f) / 2.0f) * 5.0E-4f;
            if (shift > 0.0f) {
                shift *= this.difficulty / 10.0f;
            }
            this.errorLevel += shift;
        } else {
            this.errorLevel = (float)((double)this.errorLevel - 0.1);
        }
        this.errorLevel = Math.min(100.0f, Math.max(0.0f, this.errorLevel));
        if (this.errorLevel > 0.0f) {
            this.markDirty();
        }
        if (this.errorLevel >= 100.0f) {
            this.currentReactivity = 0.0f;
            this.targetReactivity = 0.0f;
            this.adjustment = 0.0f;
            this.setBurning(false);
            if (BetterFusionReactorConfig.bfr.reactorMeltdown.get()) {
                this.explodeFlag = true;
            }
        }
    }

    public boolean adjustReactivity(float rate) {
        if (this.adjustment != 0.0f) {
            return false;
        }
        this.adjustment = rate / (float)this.adjustmentTicks;
        return true;
    }

    protected void updateAdjustment() {
        if (this.adjustment == 0.0f) {
            return;
        }
        this.markDirty();
        this.currentReactivity += this.adjustment;
        this.currentReactivity = Math.min(100.0f, Math.max(0.0f, this.currentReactivity));
        --this.adjustmentTicks;
        if (this.adjustmentTicks < 1) {
            this.adjustmentTicks = 100;
            this.adjustment = 0.0f;
        }
    }

    public int reactivityUpdateTicksScaled() {
        return (int)((double)this.reactivityUpdateTicks / ((double)this.getKt() + 0.25) * (double)(this.difficulty / 10.0f));
    }

    public void updateReactivity() {
        float low = 0.0f;
        float high = 100.0f;
        ++this.currentReactivityTick;
        if (this.reactivityUpdateTicksScaled() < this.currentReactivityTick) {
            this.currentReactivityTick = 0;
            this.setTargetReactivity(low + new Random().nextFloat() * (high - low));
        }
    }

    protected boolean isActiveCooled() {
        return !((IExtendedFluidTank)this.fluidTanks.get(0)).isEmpty();
    }

    @ComputerMethod(nameOverride="adjustReactivity")
    private void computerAdjustReactivity(float val) throws ComputerException {
        if (val > 100.0f || val < -100.0f) {
            throw new ComputerException("Adjustment must be float value in range [-100 .. 100]");
        }
        this.adjustReactivity(val);
    }

    public FusionReactorMultiblockData(TileEntityFusionReactorBlock tile) {
        super((TileEntity)tile);
        this.lastPlasmaTemperature = this.biomeAmbientTemp = HeatAPI.getAmbientTemp((IWorldReader)tile.func_145831_w(), (BlockPos)tile.getTilePos());
        this.lastCaseTemperature = this.biomeAmbientTemp;
        this.plasmaTemperature = this.biomeAmbientTemp;
        this.deuteriumTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, (TileEntityMultiblock)tile, () -> 1000L, gas -> gas.isIn((ITag)GeneratorTags.Gases.DEUTERIUM));
        this.gasTanks.add(this.deuteriumTank);
        this.tritiumTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, (TileEntityMultiblock)tile, () -> 1000L, gas -> gas.isIn((ITag)GeneratorTags.Gases.TRITIUM));
        this.gasTanks.add(this.tritiumTank);
        this.fuelTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.input((MultiblockData)this, (TileEntityMultiblock)tile, () -> 1000L, gas -> gas.isIn((ITag)GeneratorTags.Gases.FUSION_FUEL));
        this.gasTanks.add(this.fuelTank);
        this.steamTank = (IGasTank)MultiblockChemicalTankBuilder.GAS.output((MultiblockData)this, (TileEntityMultiblock)tile, this::getMaxSteam, gas -> gas == MekanismGases.STEAM.getChemical());
        this.gasTanks.add(this.steamTank);
        this.waterTank = MultiblockFluidTank.input((MultiblockData)this, (TileEntityMultiblock)tile, this::getMaxWater, fluid -> fluid.getFluid().func_207185_a((ITag)FluidTags.field_206959_a));
        this.fluidTanks.add(this.waterTank);
        this.energyContainer = BasicEnergyContainer.output((FloatingLong)MAX_ENERGY, (IContentsListener)this);
        this.energyContainers.add(this.energyContainer);
        this.heatCapacitor = MultiblockHeatCapacitor.create((MultiblockData)this, (TileEntityMultiblock)tile, (double)1.0, FusionReactorMultiblockData::getInverseConductionCoefficient, () -> 100000.0, () -> this.biomeAmbientTemp);
        this.heatCapacitors.add(this.heatCapacitor);
        this.reactorSlot = ReactorInventorySlot.at(stack -> stack.func_77973_b() instanceof ItemHohlraum, (IContentsListener)this, 80, 39);
        this.inventorySlots.add(this.reactorSlot);
        this.difficulty = BetterFusionReactorConfig.bfr.reactionDifficulty.get();
    }

    public void onCreated(World world) {
        super.onCreated(world);
        for (IValveHandler.ValveData data : this.valves) {
            TileEntity tile = WorldUtils.getTileEntity((IBlockReader)world, (BlockPos)data.location);
            if (!(tile instanceof TileEntityFusionReactorPort)) continue;
            this.heatHandlers.add((ITileHeatHandler)tile);
        }
        this.biomeAmbientTemp = this.calculateAverageAmbientTemperature(world);
        this.deathZone = new AxisAlignedBB((double)(this.getMinPos().func_177958_n() + 1), (double)(this.getMinPos().func_177956_o() + 1), (double)(this.getMinPos().func_177952_p() + 1), (double)this.getMaxPos().func_177958_n(), (double)this.getMaxPos().func_177956_o(), (double)this.getMaxPos().func_177952_p());
    }

    public void readUpdateTag(CompoundNBT tag) {
        super.readUpdateTag(tag);
        NBTUtils.setDoubleIfPresent((CompoundNBT)tag, (String)"plasmaTemp", this::setLastPlasmaTemp);
        NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"current_reactivity", this::setCurrentReactivity);
        NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"target_reactivity", this::setTargetReactivity);
        NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"error_level", this::setErrorLevel);
        NBTUtils.setFloatIfPresent((CompoundNBT)tag, (String)"adjustment", this::setAdjustment);
        NBTUtils.setIntIfPresent((CompoundNBT)tag, (String)"laser_shoot_countdown", this::setLaserShootCountdown);
        NBTUtils.setBooleanIfPresent((CompoundNBT)tag, (String)"burning", this::setBurning);
    }

    public void writeUpdateTag(CompoundNBT tag) {
        super.writeUpdateTag(tag);
        tag.func_74780_a("plasmaTemp", this.getLastPlasmaTemp());
        tag.func_74776_a("current_reactivity", this.getCurrentReactivity());
        tag.func_74776_a("target_reactivity", this.getTargetReactivity());
        tag.func_74776_a("error_level", this.getErrorLevel());
        tag.func_74776_a("adjustment", this.getAdjustment());
        tag.func_74768_a("laser_shoot_countdown", this.getLaserShootCountdown());
        tag.func_74757_a("burning", this.isBurning());
    }

    public void addTemperatureFromEnergyInput(FloatingLong energyAdded) {
        if (this.isBurning()) {
            this.setPlasmaTemp(this.getPlasmaTemp() + energyAdded.divide(100.0).doubleValue());
        } else {
            this.setPlasmaTemp(this.getPlasmaTemp() + energyAdded.divide(100.0).multiply(10L).doubleValue());
        }
    }

    private boolean hasHohlraum() {
        IGasHandler gasHandlerItem;
        Optional capability;
        ItemStack hohlraum;
        if (!this.reactorSlot.isEmpty() && (hohlraum = this.reactorSlot.getStack()).func_77973_b() instanceof ItemHohlraum && (capability = hohlraum.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve()).isPresent() && (gasHandlerItem = (IGasHandler)capability.get()).getTanks() > 0) {
            return ((GasStack)gasHandlerItem.getChemicalInTank(0)).getAmount() == gasHandlerItem.getTankCapacity(0);
        }
        return false;
    }

    public boolean tick(World world) {
        boolean needsPacket = super.tick(world);
        if (this.getPlasmaTemp() >= 1.0E8) {
            if (!this.burning && this.hasHohlraum()) {
                this.vaporiseHohlraum();
                float low = 0.0f;
                float high = 100.0f;
                this.setCurrentReactivity(low + new Random().nextFloat() * (high - low));
                this.setTargetReactivity(low + new Random().nextFloat() * (high - low));
            }
            this.updateErrorLevel();
            if (this.isBurning()) {
                this.laserShootCount();
                this.updateReactivity();
                this.updateAdjustment();
                this.injectFuel();
                long fuelBurned = this.burnFuel();
                if (fuelBurned == 0L) {
                    this.setBurning(false);
                }
            }
        } else {
            this.currentReactivity = 0.0f;
            this.targetReactivity = 0.0f;
            this.adjustment = 0.0f;
            this.setBurning(false);
        }
        this.transferHeat();
        this.updateHeatCapacitors(null);
        this.updateTemperatures();
        if (this.isBurning()) {
            this.kill(world);
        }
        if (this.isBurning() != this.clientBurning || Math.abs(this.getLastPlasmaTemp() - this.clientTemp) > 1000000.0 || this.getAdjustment() > 0.0f || this.getTargetReactivity() != this.targetReactivity || this.getErrorLevel() > 0.0f) {
            this.clientBurning = this.isBurning();
            this.clientTemp = this.getLastPlasmaTemp();
            this.targetReactivity = this.getTargetReactivity();
            this.errorLevel = this.getErrorLevel();
            needsPacket = true;
        }
        return needsPacket;
    }

    public void updateTemperatures() {
        this.lastPlasmaTemperature = this.getPlasmaTemp();
        this.lastCaseTemperature = this.heatCapacitor.getTemperature();
    }

    private void kill(World world) {
        if (world.func_201674_k().nextInt() % 20 != 0) {
            return;
        }
        List entitiesToDie = this.getWorld().func_217357_a(Entity.class, this.deathZone);
        for (Entity entity : entitiesToDie) {
            entity.func_70097_a(DamageSource.field_76376_m, 50000.0f);
        }
    }

    private void vaporiseHohlraum() {
        IGasHandler gasHandlerItem;
        ItemStack hohlraum = this.reactorSlot.getStack();
        Optional capability = hohlraum.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve();
        if (capability.isPresent() && (gasHandlerItem = (IGasHandler)capability.get()).getTanks() > 0) {
            this.fuelTank.insert(gasHandlerItem.getChemicalInTank(0), Action.EXECUTE, AutomationType.INTERNAL);
            this.lastPlasmaTemperature = this.getPlasmaTemp();
            this.reactorSlot.setEmpty();
            this.setBurning(true);
        }
    }

    private void injectFuel() {
        long amountNeeded = this.fuelTank.getNeeded();
        long amountAvailable = 2L * Math.min(this.deuteriumTank.getStored(), this.tritiumTank.getStored());
        long amountToInject = Math.min(amountNeeded, Math.min(amountAvailable, (long)this.injectionRate));
        amountToInject -= amountToInject % 2L;
        long injectingAmount = amountToInject / 2L;
        MekanismUtils.logMismatchedStackSize((long)this.deuteriumTank.shrinkStack(injectingAmount, Action.EXECUTE), (long)injectingAmount);
        MekanismUtils.logMismatchedStackSize((long)this.tritiumTank.shrinkStack(injectingAmount, Action.EXECUTE), (long)injectingAmount);
        this.fuelTank.insert((ChemicalStack)GeneratorsGases.FUSION_FUEL.getStack(amountToInject), Action.EXECUTE, AutomationType.INTERNAL);
    }

    private long burnFuel() {
        long fuelBurned = (long)Math.min((double)this.fuelTank.getStored(), Math.max(0.0, this.lastPlasmaTemperature - 1.0E8) * 1.0);
        MekanismUtils.logMismatchedStackSize((long)this.fuelTank.shrinkStack(fuelBurned, Action.EXECUTE), (long)fuelBurned);
        this.setPlasmaTemp(this.getPlasmaTemp() + ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).multiply(fuelBurned).divide(100.0).doubleValue());
        return fuelBurned;
    }

    private void transferHeat() {
        double plasmaCaseHeat = 0.2 * (this.lastPlasmaTemperature - this.lastCaseTemperature);
        this.setPlasmaTemp(this.getPlasmaTemp() - plasmaCaseHeat / 100.0);
        this.heatCapacitor.handleHeat(plasmaCaseHeat);
        double caseWaterHeat = MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() * (this.lastCaseTemperature - this.biomeAmbientTemp);
        int waterToVaporize = (int)(HeatUtils.getSteamEnergyEfficiency() * caseWaterHeat / HeatUtils.getWaterThermalEnthalpy());
        waterToVaporize = Math.min(waterToVaporize, Math.min(this.waterTank.getFluidAmount(), MathUtils.clampToInt((long)this.steamTank.getNeeded())));
        if (waterToVaporize > 0) {
            MekanismUtils.logMismatchedStackSize((long)this.waterTank.shrinkStack(waterToVaporize, Action.EXECUTE), (long)waterToVaporize);
            this.steamTank.insert((ChemicalStack)MekanismGases.STEAM.getStack((long)waterToVaporize), Action.EXECUTE, AutomationType.INTERNAL);
            caseWaterHeat = (double)waterToVaporize * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
            this.heatCapacitor.handleHeat(-caseWaterHeat);
        }
        for (ITileHeatHandler source : this.heatHandlers) {
            source.simulate();
        }
        double caseAirHeat = MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get() * (this.lastCaseTemperature - this.biomeAmbientTemp);
        this.heatCapacitor.handleHeat(-caseAirHeat);
        this.energyContainer.insert(FloatingLong.create((double)(caseAirHeat * MekanismGeneratorsConfig.generators.fusionThermocoupleEfficiency.get())), Action.EXECUTE, AutomationType.INTERNAL);
    }

    public void setLastPlasmaTemp(double temp) {
        this.lastPlasmaTemperature = temp;
    }

    public double getLastPlasmaTemp() {
        return this.lastPlasmaTemperature;
    }

    public double getLastCaseTemp() {
        return this.lastCaseTemperature;
    }

    public double getPlasmaTemp() {
        return this.plasmaTemperature;
    }

    public void setPlasmaTemp(double temp) {
        if (this.plasmaTemperature != temp) {
            this.plasmaTemperature = temp;
            this.markDirty();
        }
    }

    @ComputerMethod
    public int getInjectionRate() {
        return this.injectionRate;
    }

    public void setInjectionRate(int rate) {
        if (this.injectionRate != rate) {
            this.injectionRate = rate;
            if (this.getWorld() != null && !this.isRemote()) {
                if (!this.waterTank.isEmpty()) {
                    this.waterTank.setStackSize(Math.min(this.waterTank.getFluidAmount(), this.waterTank.getCapacity()), Action.EXECUTE);
                }
                if (!this.steamTank.isEmpty()) {
                    this.steamTank.setStackSize(Math.min(this.steamTank.getStored(), this.steamTank.getCapacity()), Action.EXECUTE);
                }
            }
            this.markDirty();
        }
    }

    public int getMaxWater() {
        return 1000000 * this.injectionRate;
    }

    public long getMaxSteam() {
        return 100000000L * (long)this.injectionRate;
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burn) {
        if (this.burning != burn) {
            this.burning = burn;
            this.markDirty();
        }
    }

    public double getCaseTemp() {
        return this.heatCapacitor.getTemperature();
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fuelTank.getStored(), (long)this.fuelTank.getCapacity());
    }

    @ComputerMethod
    public int getMinInjectionRate(boolean active) {
        double k = active ? MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() : 0.0;
        double caseAirConductivity = MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get();
        double aMin = 2.0E7 * (k + caseAirConductivity) / (((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).doubleValue() * 1.0 * (0.2 + k + caseAirConductivity) - 0.2 * (k + caseAirConductivity));
        return (int)(2.0 * Math.ceil(aMin / 2.0));
    }

    @ComputerMethod
    public double getMaxPlasmaTemperature(boolean active) {
        double k = active ? MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() : 0.0;
        double caseAirConductivity = MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get();
        return (double)this.injectionRate * ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).doubleValue() / 0.2 * (0.2 + k + caseAirConductivity) / (k + caseAirConductivity);
    }

    @ComputerMethod
    public double getMaxCasingTemperature(boolean active) {
        double k = active ? MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() : 0.0;
        return ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).multiply((long)this.injectionRate).divide(k + MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get()).doubleValue();
    }

    @ComputerMethod
    public double getIgnitionTemperature(boolean active) {
        double k = active ? MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() : 0.0;
        double caseAirConductivity = MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get();
        double energyPerFusionFuel = ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).doubleValue();
        return 1.0E8 * energyPerFusionFuel * 1.0 * (0.2 + k + caseAirConductivity) / (energyPerFusionFuel * 1.0 * (0.2 + k + caseAirConductivity) - 0.2 * (k + caseAirConductivity));
    }

    public FloatingLong getPassiveGeneration(boolean active, boolean current) {
        double temperature = current ? this.getLastCaseTemp() : this.getMaxCasingTemperature(active);
        return FloatingLong.create((double)(MekanismGeneratorsConfig.generators.fusionThermocoupleEfficiency.get() * MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get() * temperature * (double)((this.getEfficiency() / 100.0f + 2.0f) / 3.0f)));
    }

    public long getSteamPerTick(boolean current) {
        double temperature = current ? this.getLastCaseTemp() : this.getMaxCasingTemperature(true);
        return MathUtils.clampToLong((double)(HeatUtils.getSteamEnergyEfficiency() * MekanismGeneratorsConfig.generators.fusionWaterHeatingRatio.get() * (temperature / HeatUtils.getWaterThermalEnthalpy()) * (double)((this.getEfficiency() / 100.0f + 2.0f) / 3.0f)));
    }

    private static double getInverseConductionCoefficient() {
        return 1.0 / MekanismGeneratorsConfig.generators.fusionCasingThermalConductivity.get();
    }

    @ComputerMethod(nameOverride="setInjectionRate")
    private void computerSetInjectionRate(int rate) throws ComputerException {
        if (rate < 0 || rate > 98) {
            throw new ComputerException("Injection Rate '%d' is out of range must be an even number between 0 and %d. (Inclusive)", new Object[]{rate, 98});
        }
        if (rate % 2 != 0) {
            throw new ComputerException("Injection Rate '%d' must be an even number between 0 and %d. (Inclusive)", new Object[]{rate, 98});
        }
        this.setInjectionRate(rate);
    }

    @ComputerMethod
    private FloatingLong getPassiveGeneration(boolean active) {
        return this.getPassiveGeneration(active, false);
    }

    @ComputerMethod
    private FloatingLong getProductionRate() {
        return this.getPassiveGeneration(false, false);
    }
}

