/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common.content.fusion;

import igentuman.bfr.common.content.fusion.FusionReactorMultiblockData;
import java.util.List;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class FusionReactorCache
extends MultiblockCache<FusionReactorMultiblockData> {
    private double plasmaTemperature = -1.0;
    private int injectionRate = -1;
    private boolean burning;
    private float currentReactivity;
    private float targetReactivity;
    private float adjustment;
    private float errorLevel;
    private int laserCountdown;

    private int getInjectionRate() {
        if (this.injectionRate == -1) {
            return 2;
        }
        return this.injectionRate;
    }

    public void merge(MultiblockCache<FusionReactorMultiblockData> mergeCache, List<ItemStack> rejectedItems) {
        super.merge(mergeCache, rejectedItems);
        this.plasmaTemperature = Math.max(this.plasmaTemperature, ((FusionReactorCache)mergeCache).plasmaTemperature);
        this.currentReactivity = Math.max(this.currentReactivity, ((FusionReactorCache)mergeCache).currentReactivity);
        this.targetReactivity = Math.max(this.targetReactivity, ((FusionReactorCache)mergeCache).targetReactivity);
        this.adjustment = Math.max(this.adjustment, ((FusionReactorCache)mergeCache).adjustment);
        this.errorLevel = Math.max(this.errorLevel, ((FusionReactorCache)mergeCache).errorLevel);
        this.injectionRate = Math.max(this.injectionRate, ((FusionReactorCache)mergeCache).injectionRate);
        this.laserCountdown = Math.min(this.laserCountdown, ((FusionReactorCache)mergeCache).laserCountdown);
        this.burning |= ((FusionReactorCache)mergeCache).burning;
    }

    public void apply(FusionReactorMultiblockData data) {
        super.apply((MultiblockData)data);
        if (this.plasmaTemperature >= 0.0) {
            data.plasmaTemperature = this.plasmaTemperature;
        }
        data.setInjectionRate(this.getInjectionRate());
        data.setBurning(this.burning);
        data.setAdjustment(this.adjustment);
        data.setCurrentReactivity(this.currentReactivity);
        data.setTargetReactivity(this.targetReactivity);
        data.setErrorLevel(this.errorLevel);
        data.setLaserShootCountdown(this.laserCountdown);
        data.updateTemperatures();
    }

    public void sync(FusionReactorMultiblockData data) {
        super.sync((MultiblockData)data);
        this.plasmaTemperature = data.plasmaTemperature;
        this.injectionRate = data.getInjectionRate();
        this.currentReactivity = data.getCurrentReactivity();
        this.targetReactivity = data.getTargetReactivity();
        this.errorLevel = data.getErrorLevel();
        this.adjustment = data.getAdjustment();
        this.laserCountdown = data.getLaserShootCountdown();
        this.burning = data.isBurning();
    }

    public void load(CompoundNBT nbtTags) {
        super.load(nbtTags);
        this.plasmaTemperature = nbtTags.func_74769_h("plasmaTemp");
        this.injectionRate = nbtTags.func_74762_e("injectionRate");
        this.burning = nbtTags.func_74767_n("burning");
        this.adjustment = nbtTags.func_74760_g("adjustment");
        this.currentReactivity = nbtTags.func_74760_g("current_reactivity");
        this.targetReactivity = nbtTags.func_74760_g("target_reactivity");
        this.errorLevel = nbtTags.func_74760_g("error_level");
        this.laserCountdown = nbtTags.func_74762_e("laser_shoot_countdown");
    }

    public void save(CompoundNBT nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74780_a("plasmaTemp", this.plasmaTemperature);
        nbtTags.func_74768_a("injectionRate", this.getInjectionRate());
        nbtTags.func_74768_a("laser_shoot_countdown", this.laserCountdown);
        nbtTags.func_74776_a("current_reactivity", this.currentReactivity);
        nbtTags.func_74776_a("target_reactivity", this.targetReactivity);
        nbtTags.func_74776_a("error_level", this.errorLevel);
        nbtTags.func_74776_a("adjustment", this.adjustment);
        nbtTags.func_74757_a("burning", this.burning);
    }
}

