/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.common;

import igentuman.bfr.common.BfrLang;
import igentuman.bfr.common.config.BetterFusionReactorConfig;
import igentuman.bfr.common.content.fusion.FusionReactorCache;
import igentuman.bfr.common.content.fusion.FusionReactorMultiblockData;
import igentuman.bfr.common.content.fusion.FusionReactorValidator;
import igentuman.bfr.common.network.BfrPacketHandler;
import igentuman.bfr.common.registries.BfrBlocks;
import igentuman.bfr.common.registries.BfrBuilders;
import igentuman.bfr.common.registries.BfrContainerTypes;
import igentuman.bfr.common.registries.BfrModules;
import igentuman.bfr.common.registries.BfrTileEntityTypes;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.base.IModModule;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.config.MekanismModConfig;
import mekanism.common.lib.Version;
import mekanism.common.lib.multiblock.MultiblockManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="bfr")
public class BetterFusionReactor
implements IModModule {
    public static final String MODID = "bfr";
    public static BetterFusionReactor instance;
    public final Version versionNumber;
    public static final BfrPacketHandler packetHandler;
    public static final MultiblockManager<FusionReactorMultiblockData> fusionReactorManager;

    public BetterFusionReactor() {
        instance = this;
        Mekanism.modulesLoaded.add(instance);
        BetterFusionReactorConfig.registerConfigs(ModLoadingContext.get());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addListener(this::imcQueue);
        BfrBlocks.BLOCKS.register(modEventBus);
        BfrContainerTypes.CONTAINER_TYPES.register(modEventBus);
        BfrTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        BfrModules.MODULES.register(modEventBus);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BuildCommand.register((String)"fusion", (ILangEntry)BfrLang.FUSION_REACTOR, (StructureBuilder)new BfrBuilders.FusionReactorBuilder());
        packetHandler.initialize();
        Mekanism.logger.info("Loaded 'Mekanism Generators' module.");
    }

    private void imcQueue(InterModEnqueueEvent event) {
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Better Fusion Reactor";
    }

    public void resetClient() {
    }

    private void onConfigLoad(ModConfig.ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof MekanismModConfig) {
            ((MekanismModConfig)config).clearCache();
        }
    }

    static {
        packetHandler = new BfrPacketHandler();
        fusionReactorManager = new MultiblockManager("fusionReactor", FusionReactorCache::new, FusionReactorValidator::new);
    }
}

