/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.client.jei;

import igentuman.bfr.client.jei.FusionReactorRecipeCategory;
import igentuman.bfr.common.BetterFusionReactor;
import igentuman.bfr.common.registries.BfrBlocks;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mekanism.api.providers.IItemProvider;
import mekanism.client.jei.CatalystRegistryHelper;
import mekanism.client.jei.MekanismJEI;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class GeneratorsJEI
implements IModPlugin {
    private static final ResourceLocation FUSION = BetterFusionReactor.rl("fusion");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return BetterFusionReactor.rl("jei_plugin");
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registry) {
        MekanismJEI.registerItemSubtypes((ISubtypeRegistration)registry, (List)BfrBlocks.BLOCKS.getAllBlocks());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new FusionReactorRecipeCategory(guiHelper, FUSION)});
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registry) {
        CatalystRegistryHelper.register((IRecipeCatalystRegistration)registry, (ResourceLocation)FUSION, (IItemProvider[])new IItemProvider[]{BfrBlocks.FUSION_REACTOR_CONTROLLER, BfrBlocks.FUSION_REACTOR_PORT});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(FusionReactorRecipeCategory.getFusionRecipes(), FUSION);
        Collection collection = Arrays.asList(GeneratorsBlocks.LASER_FOCUS_MATRIX, GeneratorsBlocks.FUSION_REACTOR_CONTROLLER, GeneratorsBlocks.FUSION_REACTOR_FRAME, GeneratorsBlocks.FUSION_REACTOR_PORT, GeneratorsBlocks.FUSION_REACTOR_LOGIC_ADAPTER, GeneratorsBlocks.REACTOR_GLASS).stream().map(ItemStack::new).collect(Collectors.toList());
        registry.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, collection);
    }
}

