/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.client.gui.element.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import igentuman.bfr.common.BetterFusionReactor;
import igentuman.bfr.common.base.IReactorLogic;
import igentuman.bfr.common.base.IReactorLogicMode;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ReactorLogicButton<TYPE extends Enum<TYPE>>
extends MekanismButton {
    private static final ResourceLocation TEXTURE = BetterFusionReactor.rl(MekanismUtils.ResourceType.GUI_BUTTON.getPrefix() + "reactor_logic.png");
    @Nonnull
    private final IReactorLogic<TYPE> tile;
    private final int index;
    private final IntSupplier indexSupplier;
    private final Supplier<TYPE[]> modeList;
    private final Consumer<TYPE> onPress;

    public ReactorLogicButton(IGuiWrapper gui, int x, int y, int index, @Nonnull IReactorLogic<TYPE> tile, IntSupplier indexSupplier, Supplier<TYPE[]> listSupplier, Consumer<TYPE> onPress) {
        super(gui, x, y, 128, 22, StringTextComponent.field_240750_d_, null, null);
        this.index = index;
        this.indexSupplier = indexSupplier;
        this.modeList = listSupplier;
        this.tile = tile;
        this.onPress = onPress;
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        TYPE mode = this.getMode();
        if (mode != null) {
            this.onPress.accept(mode);
        }
    }

    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        super.func_230443_a_(matrix, mouseX, mouseY);
        TYPE mode = this.getMode();
        if (mode != null) {
            this.displayTooltip(matrix, ((IReactorLogicMode)mode).getDescription(), mouseX, mouseY);
        }
    }

    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        TYPE mode = this.getMode();
        if (mode == null) {
            return;
        }
        MekanismRenderer.bindTexture((ResourceLocation)TEXTURE);
        MekanismRenderer.color((EnumColor)((IReactorLogicMode)mode).getColor());
        ReactorLogicButton.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)(mode == this.tile.getMode() ? 22.0f : 0.0f), (int)this.field_230688_j_, (int)this.field_230689_k_, (int)128, (int)44);
        MekanismRenderer.resetColor();
    }

    private TYPE getMode() {
        int i = this.indexSupplier.getAsInt() + this.index;
        return (TYPE)(i >= 0 && i < ((Enum[])this.modeList.get()).length ? ((Enum[])this.modeList.get())[i] : null);
    }

    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        TYPE mode = this.getMode();
        if (mode != null) {
            int typeOffset = 22 * this.index;
            this.gui().renderItem(matrix, ((IReactorLogicMode)mode).getRenderStack(), 20, 35 + typeOffset);
            this.drawString(matrix, (ITextComponent)TextComponentUtil.build((Object[])new Object[]{EnumColor.WHITE, mode}), 39, 34 + typeOffset, this.titleTextColor());
            super.renderForeground(matrix, mouseX, mouseY);
        }
    }
}

