/*
 * Decompiled with CFR 0.152.
 */
package igentuman.bfr.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import igentuman.bfr.client.gui.GuiFusionReactorInfo;
import igentuman.bfr.client.gui.element.GuiFusionReactorTab;
import igentuman.bfr.common.BetterFusionReactor;
import igentuman.bfr.common.BfrLang;
import igentuman.bfr.common.content.fusion.FusionReactorMultiblockData;
import igentuman.bfr.common.network.to_server.PacketBfrGuiInteract;
import igentuman.bfr.common.tile.fusion.TileEntityFusionReactorController;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiFusionReactorEfficiency
extends GuiFusionReactorInfo {
    private MekanismButton reactivityUpButton;
    private MekanismButton reactivityDownButton;

    public GuiFusionReactorEfficiency(EmptyTileContainer<TileEntityFusionReactorController> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        final FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
        this.func_230480_a_((Widget)new GuiEnergyTab((IGuiWrapper)this, () -> Arrays.asList(MekanismLang.STORING.translate(new Object[]{EnergyDisplay.of((IEnergyContainer)multiblock.energyContainer)}), BfrLang.PRODUCING_AMOUNT.translate(new Object[]{EnergyDisplay.of((FloatingLong)multiblock.getPassiveGeneration(false, true))}))));
        this.func_230480_a_((Widget)new GuiVerticalPowerBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public ITextComponent getTooltip() {
                return BfrLang.REACTOR_CURRENT_REACTIVITY.translate(new Object[]{String.format("%.2f", Float.valueOf(multiblock.getCurrentReactivity()))});
            }

            public double getLevel() {
                return multiblock.getCurrentReactivity() / 100.0f;
            }
        }, 30, 55));
        this.func_230480_a_((Widget)new GuiVerticalPowerBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public ITextComponent getTooltip() {
                return BfrLang.REACTOR_TARGET_REACTIVITY.translate(new Object[]{String.format("%.2f", Float.valueOf(multiblock.getTargetReactivity()))});
            }

            public double getLevel() {
                return multiblock.getTargetReactivity() / 100.0f;
            }
        }, 64, 55));
        this.func_230480_a_((Widget)new GuiVerticalPowerBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public ITextComponent getTooltip() {
                return BfrLang.REACTOR_EFFICIENCY.translate(new Object[]{String.format("%.2f", Float.valueOf(multiblock.getEfficiency())) + "%"});
            }

            public double getLevel() {
                return multiblock.getEfficiency() / 100.0f;
            }
        }, 102, 55));
        this.func_230480_a_((Widget)new GuiVerticalPowerBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public ITextComponent getTooltip() {
                return BfrLang.REACTOR_ERROR_LEVEL.translate(new Object[]{String.format("%.2f", Float.valueOf(multiblock.getErrorLevel())) + "%"});
            }

            public double getLevel() {
                return multiblock.getErrorLevel() / 100.0f;
            }
        }, 142, 55));
        this.func_230480_a_((Widget)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.HEAT));
        this.func_230480_a_((Widget)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.FUEL));
        this.func_230480_a_((Widget)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.STAT));
        this.reactivityUpButton = (MekanismButton)this.func_230480_a_((Widget)new TranslationButton((IGuiWrapper)this, 8, 56, 20, 20, (ILangEntry)BfrLang.REACTOR_BUTTON_REACTIVITY_UP, () -> BetterFusionReactor.packetHandler.sendToServer(new PacketBfrGuiInteract(PacketBfrGuiInteract.BfrGuiInteraction.REACTIVITY_UP, (TileEntity)this.tile))));
        this.reactivityDownButton = (MekanismButton)this.func_230480_a_((Widget)new TranslationButton((IGuiWrapper)this, 8, 90, 20, 20, (ILangEntry)BfrLang.REACTOR_BUTTON_REACTIVITY_DOWN, () -> BetterFusionReactor.packetHandler.sendToServer(new PacketBfrGuiInteract(PacketBfrGuiInteract.BfrGuiInteraction.REACTIVITY_DOWN, (TileEntity)this.tile))));
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
        this.reactivityUpButton.field_230693_o_ = multiblock.getAdjustment() == 0.0f;
        this.reactivityDownButton.field_230693_o_ = multiblock.getAdjustment() == 0.0f;
    }

    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, (ITextComponent)BfrLang.FUSION_REACTOR.translate(new Object[0]), this.field_238743_q_);
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
        this.drawString(matrix, (ITextComponent)BfrLang.REACTOR_CR.translate(new Object[0]), 30, 35, this.titleTextColor());
        this.drawString(matrix, (ITextComponent)BfrLang.REACTOR_TR.translate(new Object[0]), 64, 35, this.titleTextColor());
        this.drawString(matrix, (ITextComponent)BfrLang.REACTOR_EF.translate(new Object[0]), 102, 35, this.titleTextColor());
        this.drawString(matrix, (ITextComponent)BfrLang.REACTOR_ER.translateColored(EnumColor.DARK_RED, new Object[0]), 142, 35, this.titleTextColor());
        if (multiblock.isFormed()) {
            this.drawTextScaledBound(matrix, (ITextComponent)BfrLang.REACTOR_HEAT_MULTIPLIER.translate(new Object[]{String.format("%.2f", Float.valueOf(multiblock.getKt() * 10.0f))}), 8.0f, 120.0f, this.titleTextColor(), 156.0f);
            if (multiblock.getLaserShootCountdown() == 0) {
                this.drawTextScaledBound(matrix, (ITextComponent)BfrLang.REACTOR_LASER_MIN_ENERGY.translate(new Object[]{EnergyDisplay.of((FloatingLong)FloatingLong.create((double)multiblock.laserShootMinEnergy))}), 8.0f, 130.0f, this.titleTextColor(), 156.0f);
                this.drawTextScaledBound(matrix, (ITextComponent)BfrLang.REACTOR_LASER_MIN_ENERGY_DESCR.translate(new Object[0]), 8.0f, 140.0f, this.titleTextColor(), 156.0f);
            }
        }
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

