/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor.small_dungeon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeons;
import com.yungnickyoung.minecraft.betterdungeons.config.BDConfig;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModProcessors;
import com.yungnickyoung.minecraft.betterdungeons.util.Banner;
import com.yungnickyoung.minecraft.betterdungeons.world.DungeonContext;
import com.yungnickyoung.minecraft.betterdungeons.world.DungeonType;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

@MethodsReturnNonnullByDefault
public class SmallDungeonBannerProcessor
extends StructureProcessor {
    public static final Codec<SmallDungeonBannerProcessor> CODEC = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.STRING.fieldOf("dungeon_type").forGetter(smallDungeonBannerProcessor -> smallDungeonBannerProcessor.getDungeonType().getName())).apply((Applicative)codecBuilder, codecBuilder.stable(SmallDungeonBannerProcessor::new)));
    private final DungeonType dungeonType;
    public static final Banner SMALL_DUNGEON_SKELETON_BANNER = new Banner.Builder().blockState(Blocks.field_196873_hy.func_176223_P()).pattern("cbo", 0).pattern("cs", 0).pattern("bs", 15).pattern("ts", 0).pattern("cre", 0).pattern("gra", 15).customName("betterdungeons.small_dungeon.banner.skeleton").customColor("dark_gray").build();
    public static final Banner SMALL_DUNGEON_ZOMBIE_BANNER = new Banner.Builder().blockState(Blocks.field_196871_hx.func_176223_P()).pattern("bt", 6).pattern("mc", 7).pattern("gra", 15).pattern("tts", 0).pattern("bts", 0).pattern("bo", 13).customName("betterdungeons.small_dungeon.banner.zombie").customColor("dark_green").build();
    public static final Banner SMALL_DUNGEON_SPIDER_BANNER = new Banner.Builder().blockState(Blocks.field_196871_hx.func_176223_P()).pattern("flo", 7).pattern("bo", 7).pattern("sc", 7).pattern("hh", 7).pattern("bs", 7).pattern("gra", 15).customName("betterdungeons.small_dungeon.banner.spider").customColor("dark_red").build();

    private SmallDungeonBannerProcessor(String dungeonType) {
        this.dungeonType = DungeonType.fromString(dungeonType);
    }

    public DungeonType getDungeonType() {
        return this.dungeonType;
    }

    @ParametersAreNonnullByDefault
    public Template.BlockInfo process(IWorldReader worldReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, Template.BlockInfo blockInfoLocal, Template.BlockInfo blockInfoGlobal, PlacementSettings structurePlacementData, @Nullable Template template) {
        if (blockInfoGlobal.field_186243_b.func_177230_c() instanceof AbstractBannerBlock && blockInfoGlobal.field_186243_b.func_177230_c() == Blocks.field_196871_hx && (blockInfoGlobal.field_186244_c.func_74781_a("Patterns") == null || blockInfoGlobal.field_186244_c.func_150295_c("Patterns", 10).size() == 0)) {
            DungeonContext context = DungeonContext.peek();
            if (context.getBannerCount() >= (Integer)BDConfig.smallDungeons.bannerMaxCount.get()) {
                return new Template.BlockInfo(blockInfoGlobal.field_186242_a, Blocks.field_201941_jj.func_176223_P(), blockInfoGlobal.field_186244_c);
            }
            Random random = structurePlacementData.func_189947_a(blockInfoGlobal.field_186242_a);
            if (random.nextFloat() > 0.1f) {
                return new Template.BlockInfo(blockInfoGlobal.field_186242_a, Blocks.field_201941_jj.func_176223_P(), blockInfoGlobal.field_186244_c);
            }
            Banner banner = this.getBannerForType();
            Direction facing = (Direction)blockInfoGlobal.field_186243_b.func_177229_b((Property)BlockStateProperties.field_208157_J);
            BlockState newState = (BlockState)banner.getState().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)facing);
            CompoundNBT newNBT = this.copyNBT(banner.getNbt());
            blockInfoGlobal = new Template.BlockInfo(blockInfoGlobal.field_186242_a, newState, newNBT);
            context.incrementBannerCount();
        }
        return blockInfoGlobal;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return BDModProcessors.SMALL_DUNGEON_BANNER_PROCESSOR;
    }

    private Banner getBannerForType() {
        switch (this.dungeonType) {
            case SKELETON: {
                return SMALL_DUNGEON_SKELETON_BANNER;
            }
            case ZOMBIE: {
                return SMALL_DUNGEON_ZOMBIE_BANNER;
            }
            case SPIDER: {
                return SMALL_DUNGEON_SPIDER_BANNER;
            }
        }
        BetterDungeons.LOGGER.warn("Invalid DungeonType {} for BannerProcessor! This shouldn't happen!", (Object)this.dungeonType);
        return SMALL_DUNGEON_SKELETON_BANNER;
    }

    private CompoundNBT copyNBT(CompoundNBT other) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_197643_a(other);
        return nbt;
    }
}

