/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.init;

import com.google.common.collect.ImmutableMap;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeons;
import com.yungnickyoung.minecraft.betterdungeons.config.BDConfig;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModConfiguredStructures;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModStructurePieces;
import com.yungnickyoung.minecraft.betterdungeons.mixin.ChunkGeneratorAccessor;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.skeleton_dungeon.SkeletonDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.small_dungeon.SmallDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.SpiderDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.zombie_dungeon.ZombieDungeonStructure;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.util.TriConsumer;

public class BDModStructures {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"betterdungeons");
    public static final RegistryObject<Structure<NoFeatureConfig>> SMALL_DUNGEON = DEFERRED_REGISTRY.register("small_dungeon", SmallDungeonStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> SPIDER_DUNGEON = DEFERRED_REGISTRY.register("spider_dungeon", SpiderDungeonStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> SKELETON_DUNGEON = DEFERRED_REGISTRY.register("skeleton_dungeon", SkeletonDungeonStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> ZOMBIE_DUNGEON = DEFERRED_REGISTRY.register("zombie_dungeon", ZombieDungeonStructure::new);

    public static void init() {
        DEFERRED_REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BDModStructures::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(BDModStructures::addDimensionalSpacing);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, BDModStructures::onBiomeLoad);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Structure.field_236365_a_.put((Object)"Small Dungeon".toLowerCase(Locale.ROOT), (Object)SMALL_DUNGEON.get());
            Structure.field_236365_a_.put((Object)"Spider Dungeon".toLowerCase(Locale.ROOT), (Object)SPIDER_DUNGEON.get());
            Structure.field_236365_a_.put((Object)"Skeleton Dungeon".toLowerCase(Locale.ROOT), (Object)SKELETON_DUNGEON.get());
            Structure.field_236365_a_.put((Object)"Zombie Dungeon".toLowerCase(Locale.ROOT), (Object)ZOMBIE_DUNGEON.get());
            DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put((Object)SMALL_DUNGEON.get(), (Object)new StructureSeparationSettings(((Integer)BDConfig.smallDungeons.smallDungeonSeparationDistance.get()).intValue(), ((Integer)BDConfig.smallDungeons.smallDungeonDistanceVariation.get()).intValue(), 34239823)).put((Object)SPIDER_DUNGEON.get(), (Object)new StructureSeparationSettings(((Integer)BDConfig.spiderDungeons.spiderDungeonSeparationDistance.get()).intValue(), (Integer)BDConfig.spiderDungeons.spiderDungeonSeparationDistance.get() / 2, 596523129)).put((Object)SKELETON_DUNGEON.get(), (Object)new StructureSeparationSettings(((Integer)BDConfig.skeletonDungeons.skeletonDungeonSeparationDistance.get()).intValue(), (Integer)BDConfig.skeletonDungeons.skeletonDungeonSeparationDistance.get() / 2, 732581671)).put((Object)ZOMBIE_DUNGEON.get(), (Object)new StructureSeparationSettings(((Integer)BDConfig.zombieDungeons.zombieDungeonSeparationDistance.get()).intValue(), (Integer)BDConfig.zombieDungeons.zombieDungeonSeparationDistance.get() / 2, 280667671)).build();
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("betterdungeons", "small_dungeon"), BDModConfiguredStructures.CONFIGURED_SMALL_DUNGEON);
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("betterdungeons", "spider_dungeon"), BDModConfiguredStructures.CONFIGURED_SPIDER_DUNGEON);
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("betterdungeons", "skeleton_dungeon"), BDModConfiguredStructures.CONFIGURED_SKELETON_DUNGEON);
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("betterdungeons", "zombie_dungeon"), BDModConfiguredStructures.CONFIGURED_ZOMBIE_DUNGEON);
            FlatGenerationSettings.field_202247_j.put(SMALL_DUNGEON.get(), BDModConfiguredStructures.CONFIGURED_SMALL_DUNGEON);
            FlatGenerationSettings.field_202247_j.put(SPIDER_DUNGEON.get(), BDModConfiguredStructures.CONFIGURED_SPIDER_DUNGEON);
            FlatGenerationSettings.field_202247_j.put(SKELETON_DUNGEON.get(), BDModConfiguredStructures.CONFIGURED_SKELETON_DUNGEON);
            FlatGenerationSettings.field_202247_j.put(ZOMBIE_DUNGEON.get(), BDModConfiguredStructures.CONFIGURED_ZOMBIE_DUNGEON);
            BDModStructurePieces.init();
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(structureMap);
                    tempMap.put(SMALL_DUNGEON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)SMALL_DUNGEON.get()));
                    tempMap.put(SPIDER_DUNGEON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)SPIDER_DUNGEON.get()));
                    tempMap.put(SKELETON_DUNGEON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)SKELETON_DUNGEON.get()));
                    tempMap.put(ZOMBIE_DUNGEON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ZOMBIE_DUNGEON.get()));
                    ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
                } else {
                    structureMap.put(SMALL_DUNGEON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)SMALL_DUNGEON.get()));
                    structureMap.put(SPIDER_DUNGEON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)SPIDER_DUNGEON.get()));
                    structureMap.put(SKELETON_DUNGEON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)SKELETON_DUNGEON.get()));
                    structureMap.put(ZOMBIE_DUNGEON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)ZOMBIE_DUNGEON.get()));
                }
            });
        });
    }

    private static void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            BetterDungeons.LOGGER.error("Missing biome name! This is a critical error and should not occur.");
            BetterDungeons.LOGGER.error("Try running the game with the Blame mod for a more detailed breakdown.");
            BetterDungeons.LOGGER.error("Please report this issue!");
            return;
        }
        if (((Boolean)BDConfig.general.removeVanillaDungeons.get()).booleanValue()) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(s -> ((ConfiguredFeature)s.get()).field_222737_a.equals(Features.field_243797_W.field_222737_a));
        }
        TriConsumer blacklistHandler = (blacklist, isDungeonEnabled, configuredStructure) -> {
            if (isDungeonEnabled.booleanValue() && !blacklist.contains(event.getName().toString())) {
                event.getGeneration().getStructures().add(() -> configuredStructure);
            }
        };
        blacklistHandler.accept(SmallDungeonStructure.blacklistedBiomes, BDConfig.smallDungeons.enableSmallDungeons.get(), BDModConfiguredStructures.CONFIGURED_SMALL_DUNGEON);
        blacklistHandler.accept(SpiderDungeonStructure.blacklistedBiomes, BDConfig.spiderDungeons.enableSpiderDungeons.get(), BDModConfiguredStructures.CONFIGURED_SPIDER_DUNGEON);
        blacklistHandler.accept(SkeletonDungeonStructure.blacklistedBiomes, BDConfig.skeletonDungeons.enableSkeletonDungeons.get(), BDModConfiguredStructures.CONFIGURED_SKELETON_DUNGEON);
        blacklistHandler.accept(ZombieDungeonStructure.blacklistedBiomes, BDConfig.zombieDungeons.enableZombieDungeons.get(), BDModConfiguredStructures.CONFIGURED_ZOMBIE_DUNGEON);
    }

    private static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation chunkGenResourceLocation = Registry.field_239690_aB_.func_177774_c(((ChunkGeneratorAccessor)serverWorld.func_72863_F().field_186029_c).betterdungeons_getCodec());
                if (chunkGenResourceLocation != null && chunkGenResourceLocation.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                BetterDungeons.LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            HashMap tempMap = new HashMap(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            String dimensionName = serverWorld.func_234923_W_().func_240901_a_().toString();
            BiConsumer<List, Structure> whitelistHandler = (whitelist, structure) -> {
                if (!whitelist.contains(dimensionName) || serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                    tempMap.keySet().remove(structure);
                } else {
                    tempMap.put(structure, DimensionStructuresSettings.field_236191_b_.get(structure));
                }
            };
            whitelistHandler.accept(SmallDungeonStructure.whitelistedDimensions, (Structure)SMALL_DUNGEON.get());
            whitelistHandler.accept(SpiderDungeonStructure.whitelistedDimensions, (Structure)SPIDER_DUNGEON.get());
            whitelistHandler.accept(SkeletonDungeonStructure.whitelistedDimensions, (Structure)SKELETON_DUNGEON.get());
            whitelistHandler.accept(ZombieDungeonStructure.whitelistedDimensions, (Structure)ZOMBIE_DUNGEON.get());
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

