/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettercontrols.player;

import chylex.bettercontrols.BetterControlsCommon;
import chylex.bettercontrols.config.BetterControlsConfig;
import chylex.bettercontrols.gui.BetterControlsScreen;
import chylex.bettercontrols.input.SprintMode;
import chylex.bettercontrols.input.ToggleTracker;
import chylex.bettercontrols.input.ToggleTrackerForStickyKey;
import chylex.bettercontrols.mixin.AccessCameraFields;
import chylex.bettercontrols.mixin.AccessClientPlayerFields;
import chylex.bettercontrols.mixin.AccessPlayerFields;
import chylex.bettercontrols.mixin.AccessStickyKeyBindingStateGetter;
import chylex.bettercontrols.player.FlightHelper;
import chylex.bettercontrols.player.SprintPressGetter;
import java.lang.ref.WeakReference;
import java.util.function.BooleanSupplier;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_7172;
import net.minecraft.class_744;
import net.minecraft.class_746;

public final class PlayerTicker {
    private static final class_310 MINECRAFT = class_310.method_1551();
    private static final class_315 OPTIONS = PlayerTicker.MINECRAFT.field_1690;
    private static final class_304 KEY_SPRINT = PlayerTicker.OPTIONS.field_1867;
    private static final class_304 KEY_SNEAK = PlayerTicker.OPTIONS.field_1832;
    private static final class_304 KEY_FORWARD = PlayerTicker.OPTIONS.field_1894;
    private static final class_304 KEY_JUMP = PlayerTicker.OPTIONS.field_1903;
    private static PlayerTicker ticker = new PlayerTicker(null);
    private final WeakReference<class_746> ref;
    private final ToggleTracker toggleSprint;
    private final ToggleTracker toggleSneak;
    private final ToggleTracker toggleWalkForward;
    private final ToggleTracker toggleJump;
    private boolean waitingForSprintKeyRelease;
    private boolean stopSprintingAfterReleasingSprintKey;
    private boolean wasHittingObstacle;
    private boolean wasSprintingBeforeHittingObstacle;
    private int temporarySprintTimer;
    private boolean wasSneakingBeforeTouchingGround;
    private boolean holdingSneakWhileTouchingGround;
    private int temporaryFlyOnGroundTimer;

    public static PlayerTicker get(class_746 player) {
        if (PlayerTicker.ticker.ref.get() != player) {
            ticker = new PlayerTicker(player);
        }
        return ticker;
    }

    private static BetterControlsConfig cfg() {
        return BetterControlsCommon.getConfig();
    }

    private PlayerTicker(class_746 player) {
        this.toggleSprint = new ToggleTrackerForStickyKey(PlayerTicker.cfg().keyToggleSprint, KEY_SPRINT, arg_0 -> ((class_7172)OPTIONS.method_42450()).method_41748(arg_0));
        this.toggleSneak = new ToggleTrackerForStickyKey(PlayerTicker.cfg().keyToggleSneak, KEY_SNEAK, arg_0 -> ((class_7172)OPTIONS.method_42449()).method_41748(arg_0));
        this.toggleWalkForward = new ToggleTracker(PlayerTicker.cfg().keyToggleWalkForward, KEY_FORWARD);
        this.toggleJump = new ToggleTracker(PlayerTicker.cfg().keyToggleJump, KEY_JUMP);
        this.waitingForSprintKeyRelease = false;
        this.stopSprintingAfterReleasingSprintKey = false;
        this.wasHittingObstacle = false;
        this.wasSprintingBeforeHittingObstacle = false;
        this.temporarySprintTimer = 0;
        this.wasSneakingBeforeTouchingGround = false;
        this.holdingSneakWhileTouchingGround = false;
        this.temporaryFlyOnGroundTimer = 0;
        this.ref = new WeakReference<class_746>(player);
        this.setup();
    }

    private void setup() {
        AccessStickyKeyBindingStateGetter sprint = (AccessStickyKeyBindingStateGetter)KEY_SPRINT;
        BooleanSupplier getter = sprint.getNeedsToggle();
        if (getter instanceof SprintPressGetter) {
            SprintPressGetter g = (SprintPressGetter)getter;
            getter = g.wrapped();
        }
        sprint.setNeedsToggle(new SprintPressGetter(getter, () -> this.temporarySprintTimer > 0));
    }

    public void atHead(class_746 player) {
        if (FlightHelper.shouldFlyOnGround(player)) {
            player.method_24830(false);
        }
        if (!PlayerTicker.cfg().doubleTapForwardToSprint) {
            ((AccessClientPlayerFields)player).setSprintTriggerTime(0);
        }
        if (!PlayerTicker.cfg().doubleTapJumpToToggleFlight) {
            ((AccessPlayerFields)player).setJumpTriggerTime(0);
        }
        SprintMode sprintMode = PlayerTicker.cfg().sprintMode;
        boolean wasSprintToggled = Boolean.TRUE.equals(OPTIONS.method_42450().method_41753());
        boolean isSprintToggled = this.toggleSprint.tick();
        if (this.temporarySprintTimer > 0) {
            this.stopSprintingAfterReleasingSprintKey = false;
            this.waitingForSprintKeyRelease = false;
            int nextTemporarySprintTimer = this.temporarySprintTimer - 1;
            this.temporarySprintTimer = 0;
            if (!KEY_SPRINT.method_1434() && KEY_FORWARD.method_1434()) {
                this.temporarySprintTimer = nextTemporarySprintTimer;
            } else if (sprintMode == SprintMode.TAP_TO_TOGGLE) {
                this.stopSprintingAfterReleasingSprintKey = true;
            }
        }
        if (isSprintToggled) {
            this.stopSprintingAfterReleasingSprintKey = false;
            this.waitingForSprintKeyRelease = false;
        } else if (wasSprintToggled) {
            this.stopSprintingAfterReleasingSprintKey = true;
            this.waitingForSprintKeyRelease = true;
        } else if (sprintMode == SprintMode.TAP_TO_TOGGLE) {
            if (KEY_SPRINT.method_1434()) {
                if (!this.waitingForSprintKeyRelease) {
                    this.waitingForSprintKeyRelease = true;
                    this.stopSprintingAfterReleasingSprintKey = player.method_5624();
                }
            } else {
                if (player.method_5624() && !this.waitingForSprintKeyRelease) {
                    this.stopSprintingAfterReleasingSprintKey = false;
                }
                this.waitingForSprintKeyRelease = false;
            }
        } else if (sprintMode == SprintMode.HOLD && KEY_SPRINT.method_1434()) {
            this.stopSprintingAfterReleasingSprintKey = true;
        }
        if (this.stopSprintingAfterReleasingSprintKey && !KEY_SPRINT.method_1434()) {
            this.stopSprintingAfterReleasingSprintKey = false;
            this.waitingForSprintKeyRelease = false;
            player.method_5728(false);
        }
        this.toggleSneak.tick();
    }

    public void afterInputAssignsPressingForward(class_744 input) {
        if (PlayerTicker.MINECRAFT.field_1755 == null) {
            input.field_3910 |= this.toggleWalkForward.tick();
        }
    }

    public void afterInputTick(class_746 player) {
        class_744 input = player.field_3913;
        if (PlayerTicker.MINECRAFT.field_1755 == null && !player.method_31549().field_7479) {
            input.field_3904 |= this.toggleJump.tick();
        }
        if (PlayerTicker.cfg().resumeSprintingAfterHittingObstacle) {
            if (this.wasHittingObstacle != player.field_5976) {
                if (!this.wasHittingObstacle) {
                    this.wasSprintingBeforeHittingObstacle = player.method_5624() || KEY_SPRINT.method_1434();
                } else if (this.wasSprintingBeforeHittingObstacle) {
                    this.wasSprintingBeforeHittingObstacle = false;
                    this.temporarySprintTimer = 10;
                }
                this.wasHittingObstacle = player.field_5976;
            }
        } else {
            this.wasHittingObstacle = player.field_5976;
            this.wasSprintingBeforeHittingObstacle = false;
        }
    }

    public void afterSuperCall(class_746 player) {
        class_4184 camera;
        if (FlightHelper.shouldFlyOnGround(player)) {
            boolean isSneaking = player.method_5715();
            boolean isOnGround = player.method_24828();
            if (!isSneaking) {
                this.wasSneakingBeforeTouchingGround = false;
            } else if (!isOnGround) {
                this.wasSneakingBeforeTouchingGround = true;
            }
            if (!isOnGround) {
                this.holdingSneakWhileTouchingGround = false;
            } else {
                boolean cancelLanding = true;
                if (!this.wasSneakingBeforeTouchingGround) {
                    if (isSneaking) {
                        this.holdingSneakWhileTouchingGround = true;
                    } else if (this.holdingSneakWhileTouchingGround) {
                        player.method_31549().field_7479 = false;
                        player.method_7355();
                        cancelLanding = false;
                    }
                }
                if (cancelLanding) {
                    player.method_24830(false);
                }
            }
        } else {
            this.wasSneakingBeforeTouchingGround = false;
            this.holdingSneakWhileTouchingGround = false;
        }
        if (FlightHelper.isFlyingCreativeOrSpectator(player) && PlayerTicker.cfg().disableFlightInertia) {
            class_744 input = player.field_3913;
            if (input.field_3905 == 0.0f && input.field_3907 == 0.0f) {
                player.method_18799(player.method_18798().method_18805(0.0, 1.0, 0.0));
            }
            if (!input.field_3904 && !input.field_3903) {
                player.method_18799(player.method_18798().method_18805(1.0, 0.0, 1.0));
            }
        }
        if (player.method_7337()) {
            if (PlayerTicker.cfg().keyToggleFlight.method_1436()) {
                boolean isFlying;
                player.method_31549().field_7479 = isFlying = !player.method_31549().field_7479;
                player.method_7355();
                if (isFlying) {
                    this.temporaryFlyOnGroundTimer = 10;
                }
            }
            if (this.temporaryFlyOnGroundTimer > 0) {
                if (player.method_5715()) {
                    this.temporaryFlyOnGroundTimer = 0;
                } else {
                    --this.temporaryFlyOnGroundTimer;
                    player.method_24830(false);
                }
            }
        } else {
            this.temporaryFlyOnGroundTimer = 0;
        }
        if (!PlayerTicker.cfg().sneakingMovesCameraSmoothly && (camera = PlayerTicker.MINECRAFT.field_1773.method_19418()).method_19331() == player) {
            ((AccessCameraFields)camera).setEyeHeight(player.method_5751());
        }
        if (PlayerTicker.cfg().keyResetAllToggles.method_1436()) {
            this.toggleSprint.reset();
            this.toggleSneak.reset();
            this.toggleWalkForward.reset();
            this.toggleJump.reset();
        }
        if (PlayerTicker.cfg().keyOpenMenu.method_1434()) {
            MINECRAFT.method_1507((class_437)new BetterControlsScreen(null));
        }
    }

    public boolean shouldResetFOV(class_746 player) {
        return PlayerTicker.cfg().disableChangingFovWhileFlying && FlightHelper.isFlyingCreativeOrSpectator(player);
    }
}

