/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettercontrols.gui;

import chylex.bettercontrols.BetterControlsCommon;
import chylex.bettercontrols.config.BetterControlsConfig;
import chylex.bettercontrols.gui.OptionListWidget;
import chylex.bettercontrols.gui.elements.DiscreteValueSliderWidget;
import chylex.bettercontrols.gui.elements.KeyBindingWidget;
import chylex.bettercontrols.gui.elements.Option;
import chylex.bettercontrols.gui.elements.TextWidget;
import chylex.bettercontrols.input.KeyBindingWithModifier;
import chylex.bettercontrols.input.ModifierKey;
import chylex.bettercontrols.input.SprintMode;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BetterControlsScreen
extends class_4667 {
    public static final class_2561 TITLE = BetterControlsScreen.text("Better Controls");
    private static final int BOTTOM_PADDING = 3;
    private static final int TEXT_PADDING_RIGHT = 4;
    private static final int TITLE_MARGIN_TOP = 3;
    private static final int ROW_HEIGHT = 22;
    private final List<Option<SprintMode>> SPRINT_MODE_OPTIONS = Arrays.asList(new Option<SprintMode>(SprintMode.TAP_TO_START, BetterControlsScreen.text("Tap To Start Sprinting")), new Option<SprintMode>(SprintMode.TAP_TO_TOGGLE, BetterControlsScreen.text("Tap To Start / Stop Sprinting")), new Option<SprintMode>(SprintMode.HOLD, BetterControlsScreen.text("Hold To Sprint")));
    private static final List<Option<ModifierKey>> MODIFIER_OPTIONS = Arrays.asList(new Option<Object>(null, BetterControlsScreen.text("(No Modifier)")), new Option<ModifierKey>(ModifierKey.CONTROL, BetterControlsScreen.text("Control")), new Option<ModifierKey>(ModifierKey.SHIFT, BetterControlsScreen.text("Shift")), new Option<ModifierKey>(ModifierKey.ALT, BetterControlsScreen.text("Alt")));
    private OptionListWidget optionsWidget;
    private KeyBindingWidget editingKeyBinding;
    private final List<KeyBindingWidget> allKeyBindings = new ArrayList<KeyBindingWidget>();

    private static class_2561 text(String text) {
        return class_2561.method_43470((String)text);
    }

    private int generateSprintingOptions(int y, List<class_364> elements) {
        BetterControlsConfig cfg = BetterControlsCommon.getConfig();
        this.generateKeyBindingWithModifierRow(y, elements, BetterControlsScreen.text("Toggle Sprint"), cfg.keyToggleSprint);
        BetterControlsScreen.generateCycleOptionRow(y += 22, elements, BetterControlsScreen.text("Sprint Key Mode"), this.SPRINT_MODE_OPTIONS, cfg.sprintMode, value -> {
            cfg.sprintMode = value;
        });
        BetterControlsScreen.generateBooleanOptionRow(y += 22, elements, BetterControlsScreen.text("Double Tap 'Walk Forwards' To Sprint"), cfg.doubleTapForwardToSprint, value -> {
            cfg.doubleTapForwardToSprint = value;
        });
        BetterControlsScreen.generateBooleanOptionRow(y += 22, elements, BetterControlsScreen.text("Resume Sprinting After Hitting Obstacle"), cfg.resumeSprintingAfterHittingObstacle, value -> {
            cfg.resumeSprintingAfterHittingObstacle = value;
        });
        return y += 22;
    }

    private int generateSneakingOptions(int y, List<class_364> elements) {
        BetterControlsConfig cfg = BetterControlsCommon.getConfig();
        this.generateKeyBindingWithModifierRow(y, elements, BetterControlsScreen.text("Toggle Sneak"), cfg.keyToggleSneak);
        BetterControlsScreen.generateBooleanOptionRow(y += 22, elements, BetterControlsScreen.text("Move Camera Smoothly"), cfg.sneakingMovesCameraSmoothly, value -> {
            cfg.sneakingMovesCameraSmoothly = value;
        });
        return y += 22;
    }

    private int generateFlightOptions(int y, List<class_364> elements) {
        BetterControlsConfig cfg = BetterControlsCommon.getConfig();
        ImmutableList flightSpeedOptions = ImmutableList.of(new Option<Float>(Float.valueOf(0.25f), BetterControlsScreen.text("0.25x")), new Option<Float>(Float.valueOf(0.5f), BetterControlsScreen.text("0.5x")), new Option<Float>(Float.valueOf(0.75f), BetterControlsScreen.text("0.75x")), new Option<Float>(Float.valueOf(1.0f), BetterControlsScreen.text("1x")), new Option<Float>(Float.valueOf(1.5f), BetterControlsScreen.text("1.5x")), new Option<Float>(Float.valueOf(2.0f), BetterControlsScreen.text("2x")), new Option<Float>(Float.valueOf(3.0f), BetterControlsScreen.text("3x")), new Option<Float>(Float.valueOf(4.0f), BetterControlsScreen.text("4x")), new Option<Float>(Float.valueOf(5.0f), BetterControlsScreen.text("5x")), new Option<Float>(Float.valueOf(6.0f), BetterControlsScreen.text("6x")), new Option<Float>(Float.valueOf(7.0f), BetterControlsScreen.text("7x")), new Option<Float>(Float.valueOf(8.0f), BetterControlsScreen.text("8x")), (Object[])new Option[0]);
        this.generateKeyBindingWithModifierRow(y, elements, BetterControlsScreen.text("Toggle Flight (Creative)"), cfg.keyToggleFlight);
        BetterControlsScreen.generateBooleanOptionRow(y += 22, elements, BetterControlsScreen.text("Double Tap 'Jump' To Fly (Creative)"), cfg.doubleTapJumpToToggleFlight, value -> {
            cfg.doubleTapJumpToToggleFlight = value;
        });
        BetterControlsScreen.generateBooleanOptionRow(y += 22, elements, BetterControlsScreen.text("Disable Flight Inertia"), cfg.disableFlightInertia, value -> {
            cfg.disableFlightInertia = value;
        });
        BetterControlsScreen.generateBooleanOptionRow(y += 22, elements, BetterControlsScreen.text("Disable Field Of View Changing"), cfg.disableChangingFovWhileFlying, value -> {
            cfg.disableChangingFovWhileFlying = value;
        });
        BetterControlsScreen.generateBooleanOptionRow(y += 22, elements, BetterControlsScreen.text("Fly On Ground (Creative Mode)"), cfg.flyOnGroundInCreative, value -> {
            cfg.flyOnGroundInCreative = value;
        });
        y += 22;
        elements.add(new TextWidget(OptionListWidget.col4(2), y += 7, 96, BetterControlsScreen.text("Creative"), 1));
        elements.add(new TextWidget(OptionListWidget.col4(3), y, 96, BetterControlsScreen.text("Spectator"), 1));
        BetterControlsScreen.generateLeftSideText(y += 19, elements, BetterControlsScreen.text("Horizontal Speed Multiplier (Default)"));
        elements.add((class_364)new DiscreteValueSliderWidget<Float>(OptionListWidget.col4(2), y, 100, BetterControlsScreen.text("Horizontal Speed Multiplier in Creative Mode"), flightSpeedOptions, Float.valueOf(cfg.flightHorizontalSpeedMpCreativeDefault), value -> {
            cfg.flightHorizontalSpeedMpCreativeDefault = value.floatValue();
        }));
        elements.add((class_364)new DiscreteValueSliderWidget<Float>(OptionListWidget.col4(3), y, 100, BetterControlsScreen.text("Horizontal Speed Multiplier in Spectator Mode"), flightSpeedOptions, Float.valueOf(cfg.flightHorizontalSpeedMpSpectatorDefault), value -> {
            cfg.flightHorizontalSpeedMpSpectatorDefault = value.floatValue();
        }));
        BetterControlsScreen.generateLeftSideText(y += 22, elements, BetterControlsScreen.text("Horizontal Speed Multiplier (Sprinting)"));
        elements.add((class_364)new DiscreteValueSliderWidget<Float>(OptionListWidget.col4(2), y, 100, BetterControlsScreen.text("Horizontal Speed Multiplier when Sprinting in Creative Mode"), flightSpeedOptions, Float.valueOf(cfg.flightHorizontalSpeedMpCreativeSprinting), value -> {
            cfg.flightHorizontalSpeedMpCreativeSprinting = value.floatValue();
        }));
        elements.add((class_364)new DiscreteValueSliderWidget<Float>(OptionListWidget.col4(3), y, 100, BetterControlsScreen.text("Horizontal Speed Multiplier when Sprinting in Spectator Mode"), flightSpeedOptions, Float.valueOf(cfg.flightHorizontalSpeedMpSpectatorSprinting), value -> {
            cfg.flightHorizontalSpeedMpSpectatorSprinting = value.floatValue();
        }));
        BetterControlsScreen.generateLeftSideText(y += 22, elements, BetterControlsScreen.text("Vertical Speed Multiplier (Default)"));
        elements.add((class_364)new DiscreteValueSliderWidget<Float>(OptionListWidget.col4(2), y, 100, BetterControlsScreen.text("Vertical Speed Multiplier in Creative Mode"), flightSpeedOptions, Float.valueOf(cfg.flightVerticalSpeedMpCreativeDefault), value -> {
            cfg.flightVerticalSpeedMpCreativeDefault = value.floatValue();
        }));
        elements.add((class_364)new DiscreteValueSliderWidget<Float>(OptionListWidget.col4(3), y, 100, BetterControlsScreen.text("Vertical Speed Multiplier in Spectator Mode"), flightSpeedOptions, Float.valueOf(cfg.flightVerticalSpeedMpSpectatorDefault), value -> {
            cfg.flightVerticalSpeedMpSpectatorDefault = value.floatValue();
        }));
        BetterControlsScreen.generateLeftSideText(y += 22, elements, BetterControlsScreen.text("Vertical Speed Multiplier (Sprinting)"));
        elements.add((class_364)new DiscreteValueSliderWidget<Float>(OptionListWidget.col4(2), y, 100, BetterControlsScreen.text("Vertical Speed Multiplier when Sprinting in Creative Mode"), flightSpeedOptions, Float.valueOf(cfg.flightVerticalSpeedMpCreativeSprinting), value -> {
            cfg.flightVerticalSpeedMpCreativeSprinting = value.floatValue();
        }));
        elements.add((class_364)new DiscreteValueSliderWidget<Float>(OptionListWidget.col4(3), y, 100, BetterControlsScreen.text("Vertical Speed Multiplier when Sprinting in Spectator Mode"), flightSpeedOptions, Float.valueOf(cfg.flightVerticalSpeedMpSpectatorSprinting), value -> {
            cfg.flightVerticalSpeedMpSpectatorSprinting = value.floatValue();
        }));
        return y += 22;
    }

    private int generateMiscellaneousOptions(int y, List<class_364> elements) {
        BetterControlsConfig cfg = BetterControlsCommon.getConfig();
        this.generateKeyBindingWithModifierRow(y, elements, BetterControlsScreen.text("Toggle Walk Forwards"), cfg.keyToggleWalkForward);
        this.generateKeyBindingWithModifierRow(y += 22, elements, BetterControlsScreen.text("Toggle Jump"), cfg.keyToggleJump);
        this.generateKeyBindingWithModifierRow(y += 22, elements, BetterControlsScreen.text("Reset All Toggles"), cfg.keyResetAllToggles);
        this.generateKeyBindingWithModifierRow(y += 29, elements, BetterControlsScreen.text("Open Better Controls Menu"), cfg.keyOpenMenu);
        return y += 22;
    }

    private void generateKeyBindingWithModifierRow(int y, List<class_364> elements, class_2561 text, KeyBindingWithModifier binding) {
        class_5676<Option<ModifierKey>> modifierButton = Option.button(OptionListWidget.col4(2), y, 100, (class_2561)text.method_27662().method_27693(" Modifier"), MODIFIER_OPTIONS, binding.getModifier(), binding::setModifier);
        KeyBindingWidget bindingButton = new KeyBindingWidget(OptionListWidget.col4(3), y, 100, text, binding, this::startEditingKeyBinding);
        bindingButton.linkButtonToBoundState((class_4264)modifierButton);
        BetterControlsScreen.generateLeftSideText(y, elements, text);
        elements.add((class_364)modifierButton);
        elements.add((class_364)bindingButton);
        this.allKeyBindings.add(bindingButton);
    }

    private static <T> void generateCycleOptionRow(int y, List<class_364> elements, class_2561 text, List<Option<T>> options, T initialValue, Consumer<T> onValueChanged) {
        BetterControlsScreen.generateLeftSideText(y, elements, text);
        elements.add((class_364)Option.button(OptionListWidget.col2(1), y, 202, text, options, initialValue, onValueChanged));
    }

    private static void generateBooleanOptionRow(int y, List<class_364> elements, class_2561 text, boolean initialValue, BooleanConsumer onValueChanged) {
        BetterControlsScreen.generateLeftSideText(y, elements, text);
        elements.add((class_364)class_5676.method_32614().method_32616().method_32619((Object)initialValue).method_32617(OptionListWidget.col2(1), y, 202, 20, text, (btn, newValue) -> onValueChanged.accept(newValue.booleanValue())));
    }

    private static void generateLeftSideText(int y, List<class_364> elements, class_2561 text) {
        elements.add(new TextWidget(OptionListWidget.col2(0), y, 198, text));
    }

    public BetterControlsScreen(@Nullable class_437 parentScreen) {
        super(parentScreen, class_310.method_1551().field_1690, TITLE);
    }

    public void method_25426() {
        this.allKeyBindings.clear();
        ArrayList<class_364> elements = new ArrayList<class_364>();
        int y = 0;
        elements.add(new TextWidget(0, y, 408, 22, BetterControlsScreen.text("Sprinting"), 1));
        y = this.generateSprintingOptions(y + 22, elements) + 3;
        elements.add(new TextWidget(0, y, 408, 22, BetterControlsScreen.text("Sneaking"), 1));
        y = this.generateSneakingOptions(y + 22, elements) + 3;
        elements.add(new TextWidget(0, y, 408, 22, BetterControlsScreen.text("Flying"), 1));
        y = this.generateFlightOptions(y + 22, elements) + 3;
        elements.add(new TextWidget(0, y, 408, 22, BetterControlsScreen.text("Miscellaneous"), 1));
        y = this.generateMiscellaneousOptions(y + 22, elements) + 3;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.field_22787.method_1507(this.field_21335)).method_46433(this.field_22789 / 2 - 99, this.field_22790 - 29).method_46437(200, 20).method_46431());
        this.optionsWidget = new OptionListWidget(21, this.field_22790 - 32, this.field_22789, this.field_22790, elements, y - 3 + 3);
        this.method_25429((class_364)this.optionsWidget);
    }

    public void method_25432() {
        BetterControlsCommon.getConfig().save();
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        this.optionsWidget.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    private void startEditingKeyBinding(KeyBindingWidget widget) {
        if (this.editingKeyBinding != null) {
            this.editingKeyBinding.stopEditing();
        }
        this.editingKeyBinding = widget;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.editingKeyBinding != null) {
            this.editingKeyBinding.bindAndStopEditing(class_3675.class_307.field_1672.method_1447(button));
            this.onKeyBindingEditingFinished();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.editingKeyBinding != null) {
            if (keyCode == 256) {
                this.editingKeyBinding.bindAndStopEditing(class_3675.field_16237);
            } else {
                this.editingKeyBinding.bindAndStopEditing(class_3675.method_15985((int)keyCode, (int)scanCode));
            }
            this.onKeyBindingEditingFinished();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void onKeyBindingEditingFinished() {
        this.editingKeyBinding = null;
        class_304.method_1426();
        for (KeyBindingWidget widget : this.allKeyBindings) {
            widget.updateKeyBindingText();
        }
    }
}

