/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettercontrols.config;

import chylex.bettercontrols.input.KeyBindingWithModifier;
import chylex.bettercontrols.input.ModifierKey;
import com.google.gson.JsonObject;
import net.minecraft.class_3675;

final class Json {
    private static final String KEY_SUFFIX = ".Key";
    private static final String MOD_SUFFIX = ".Mod";

    private Json() {
    }

    static void setFloat(JsonObject obj, String key, float value) {
        obj.addProperty(key, (Number)Float.valueOf(value));
    }

    static float getFloat(JsonObject obj, String key, float defaultValue, float minValue, float maxValue) {
        float value = obj.has(key) ? obj.get(key).getAsFloat() : defaultValue;
        return Math.max(minValue, Math.min(maxValue, value));
    }

    static void setBool(JsonObject obj, String key, boolean value) {
        obj.addProperty(key, Boolean.valueOf(value));
    }

    static boolean getBool(JsonObject obj, String key, boolean defaultValue) {
        return obj.has(key) ? obj.get(key).getAsBoolean() : defaultValue;
    }

    static <T extends Enum<T>> void setEnum(JsonObject obj, String key, T value) {
        obj.addProperty(key, value.name());
    }

    static <T extends Enum<T>> T getEnum(JsonObject obj, String key, T defaultValue, Class<T> enumClass) {
        if (!obj.has(key)) {
            return defaultValue;
        }
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        if (constants != null) {
            String value = obj.get(key).getAsString();
            for (Enum constant : constants) {
                if (!constant.name().equalsIgnoreCase(value)) continue;
                return (T)constant;
            }
        }
        return defaultValue;
    }

    static void writeKeyBinding(JsonObject obj, String key, KeyBindingWithModifier keyBinding) {
        obj.addProperty(key + KEY_SUFFIX, keyBinding.method_1428());
        if (keyBinding.getModifier() != null) {
            obj.addProperty(key + MOD_SUFFIX, (Number)keyBinding.getModifier().id);
        }
    }

    static void readKeyBinding(JsonObject obj, String key, KeyBindingWithModifier keyBinding) {
        if (obj.has(key + KEY_SUFFIX)) {
            try {
                keyBinding.method_1422(class_3675.method_15981((String)obj.get(key + KEY_SUFFIX).getAsString()));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        if (obj.has(key + MOD_SUFFIX)) {
            keyBinding.setModifier(ModifierKey.getById(obj.get(key + MOD_SUFFIX).getAsInt()));
        }
    }
}

