/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettercontrols.config;

import chylex.bettercontrols.config.BetterControlsConfig;
import chylex.bettercontrols.config.Json;
import chylex.bettercontrols.input.SprintMode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.class_3532;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class ConfigSerializer
implements JsonSerializer<BetterControlsConfig>,
JsonDeserializer<BetterControlsConfig> {
    private static final Logger logger = LogManager.getLogger();
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(BetterControlsConfig.class, (Object)new ConfigSerializer()).setPrettyPrinting().create();

    private ConfigSerializer() {
    }

    public JsonElement serialize(BetterControlsConfig cfg, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        Json.writeKeyBinding(obj, "Sprint.KeyToggle", cfg.keyToggleSprint);
        Json.setEnum(obj, "Sprint.Mode", cfg.sprintMode);
        Json.setBool(obj, "Sprint.DoubleTapForward", cfg.doubleTapForwardToSprint);
        Json.setBool(obj, "Sprint.ResumeAfterHittingObstacle", cfg.resumeSprintingAfterHittingObstacle);
        Json.writeKeyBinding(obj, "Sneak.KeyToggle", cfg.keyToggleSneak);
        Json.setBool(obj, "Sneak.SmoothCamera", cfg.sneakingMovesCameraSmoothly);
        Json.writeKeyBinding(obj, "Flight.KeyToggle.Creative", cfg.keyToggleFlight);
        Json.setBool(obj, "Flight.DoubleTapJump", cfg.doubleTapJumpToToggleFlight);
        Json.setBool(obj, "Flight.DisableInertia", cfg.disableFlightInertia);
        Json.setBool(obj, "Flight.DisableChangingFOV", cfg.disableChangingFovWhileFlying);
        Json.setBool(obj, "Flight.FlyOnGround.Creative", cfg.flyOnGroundInCreative);
        Json.setFloat(obj, "Flight.SpeedMp.Creative.Default", cfg.flightHorizontalSpeedMpCreativeDefault);
        Json.setFloat(obj, "Flight.SpeedMp.Creative.Sprinting", cfg.flightHorizontalSpeedMpCreativeSprinting);
        Json.setFloat(obj, "Flight.SpeedMp.Spectator.Default", cfg.flightHorizontalSpeedMpSpectatorDefault);
        Json.setFloat(obj, "Flight.SpeedMp.Spectator.Sprinting", cfg.flightHorizontalSpeedMpSpectatorSprinting);
        Json.setFloat(obj, "Flight.VerticalSpeedMp.Creative.Default", cfg.flightVerticalSpeedMpCreativeDefault);
        Json.setFloat(obj, "Flight.VerticalSpeedMp.Creative.Sprinting", cfg.flightVerticalSpeedMpCreativeSprinting);
        Json.setFloat(obj, "Flight.VerticalSpeedMp.Spectator.Default", cfg.flightVerticalSpeedMpSpectatorDefault);
        Json.setFloat(obj, "Flight.VerticalSpeedMp.Spectator.Sprinting", cfg.flightVerticalSpeedMpSpectatorSprinting);
        Json.writeKeyBinding(obj, "Misc.KeyToggleWalkForward", cfg.keyToggleWalkForward);
        Json.writeKeyBinding(obj, "Misc.KeyToggleJump", cfg.keyToggleJump);
        Json.writeKeyBinding(obj, "Misc.KeyResetAllToggles", cfg.keyResetAllToggles);
        Json.writeKeyBinding(obj, "Misc.KeyOpenMenu", cfg.keyOpenMenu);
        return obj;
    }

    public BetterControlsConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BetterControlsConfig cfg = new BetterControlsConfig();
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("Sprint.TapToStop") && obj.get("Sprint.TapToStop").getAsBoolean()) {
            cfg.sprintMode = SprintMode.TAP_TO_TOGGLE;
        }
        Json.readKeyBinding(obj, "Sprint.KeyToggle", cfg.keyToggleSprint);
        cfg.sprintMode = Json.getEnum(obj, "Sprint.Mode", cfg.sprintMode, SprintMode.class);
        cfg.doubleTapForwardToSprint = Json.getBool(obj, "Sprint.DoubleTapForward", cfg.doubleTapForwardToSprint);
        cfg.resumeSprintingAfterHittingObstacle = Json.getBool(obj, "Sprint.ResumeAfterHittingObstacle", cfg.resumeSprintingAfterHittingObstacle);
        Json.readKeyBinding(obj, "Sneak.KeyToggle", cfg.keyToggleSneak);
        cfg.sneakingMovesCameraSmoothly = Json.getBool(obj, "Sneak.SmoothCamera", cfg.sneakingMovesCameraSmoothly);
        Json.readKeyBinding(obj, "Flight.KeyToggle.Creative", cfg.keyToggleFlight);
        cfg.doubleTapJumpToToggleFlight = Json.getBool(obj, "Flight.DoubleTapJump", cfg.doubleTapJumpToToggleFlight);
        cfg.disableFlightInertia = Json.getBool(obj, "Flight.DisableInertia", cfg.disableFlightInertia);
        cfg.disableChangingFovWhileFlying = Json.getBool(obj, "Flight.DisableChangingFOV", cfg.disableChangingFovWhileFlying);
        cfg.flyOnGroundInCreative = Json.getBool(obj, "Flight.FlyOnGround.Creative", cfg.flyOnGroundInCreative);
        cfg.flightHorizontalSpeedMpCreativeDefault = ConfigSerializer.readHorizontalSpeedMultiplier(obj, "Flight.SpeedMp.Creative.Default", cfg.flightHorizontalSpeedMpCreativeDefault);
        cfg.flightHorizontalSpeedMpCreativeSprinting = ConfigSerializer.readHorizontalSpeedMultiplier(obj, "Flight.SpeedMp.Creative.Sprinting", cfg.flightHorizontalSpeedMpCreativeSprinting);
        cfg.flightHorizontalSpeedMpSpectatorDefault = ConfigSerializer.readHorizontalSpeedMultiplier(obj, "Flight.SpeedMp.Spectator.Default", cfg.flightHorizontalSpeedMpSpectatorDefault);
        cfg.flightHorizontalSpeedMpSpectatorSprinting = ConfigSerializer.readHorizontalSpeedMultiplier(obj, "Flight.SpeedMp.Spectator.Sprinting", cfg.flightHorizontalSpeedMpSpectatorSprinting);
        cfg.flightVerticalSpeedMpCreativeDefault = ConfigSerializer.readVerticalSpeedMultiplier(obj, cfg, "Flight.VerticalSpeedMp.Creative.Default", "Flight.VerticalBoost.Creative.Default", cfg.flightVerticalSpeedMpCreativeDefault);
        cfg.flightVerticalSpeedMpCreativeSprinting = ConfigSerializer.readVerticalSpeedMultiplier(obj, cfg, "Flight.VerticalSpeedMp.Creative.Sprinting", "Flight.VerticalBoost.Creative.Sprinting", cfg.flightVerticalSpeedMpCreativeSprinting);
        cfg.flightVerticalSpeedMpSpectatorDefault = ConfigSerializer.readVerticalSpeedMultiplier(obj, cfg, "Flight.VerticalSpeedMp.Spectator.Default", "Flight.VerticalBoost.Spectator.Default", cfg.flightVerticalSpeedMpSpectatorDefault);
        cfg.flightVerticalSpeedMpSpectatorSprinting = ConfigSerializer.readVerticalSpeedMultiplier(obj, cfg, "Flight.VerticalSpeedMp.Spectator.Sprinting", "Flight.VerticalBoost.Spectator.Sprinting", cfg.flightVerticalSpeedMpSpectatorSprinting);
        Json.readKeyBinding(obj, "Misc.KeyToggleWalkForward", cfg.keyToggleWalkForward);
        Json.readKeyBinding(obj, "Misc.KeyToggleJump", cfg.keyToggleJump);
        Json.readKeyBinding(obj, "Misc.KeyResetAllToggles", cfg.keyResetAllToggles);
        Json.readKeyBinding(obj, "Misc.KeyOpenMenu", cfg.keyOpenMenu);
        return cfg;
    }

    private static float readHorizontalSpeedMultiplier(JsonObject obj, String key, float defaultValue) {
        return Json.getFloat(obj, key, defaultValue, 0.25f, 8.0f);
    }

    private static float readVerticalSpeedMultiplier(JsonObject obj, BetterControlsConfig cfg, String newKey, String legacyBoostKey, float defaultValue) {
        if (obj.has(newKey)) {
            return Json.getFloat(obj, newKey, defaultValue, 0.25f, 8.0f);
        }
        if (obj.has(legacyBoostKey)) {
            cfg.wasMigrated = true;
            float value = 1.0f + Json.getFloat(obj, legacyBoostKey, 0.0f, 0.0f, 3.0f);
            if (class_3532.method_15347((float)value, (float)1.25f) || class_3532.method_15347((float)value, (float)1.75f)) {
                return 1.5f;
            }
            if (class_3532.method_15347((float)value, (float)2.5f)) {
                return 2.0f;
            }
            if (class_3532.method_15347((float)value, (float)3.5f)) {
                return 3.0f;
            }
            return value;
        }
        return defaultValue;
    }

    static void write(Path path, BetterControlsConfig config) {
        try (JsonWriter writer = gson.newJsonWriter((Writer)Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));){
            gson.getAdapter(BetterControlsConfig.class).write(writer, (Object)config);
        }
        catch (IOException e) {
            logger.error("Error saving BetterControls configuration file!", (Throwable)e);
        }
    }

    static BetterControlsConfig read(Path path) {
        block8: {
            BetterControlsConfig betterControlsConfig;
            JsonReader jsonReader2 = new JsonReader((Reader)Files.newBufferedReader(path, StandardCharsets.UTF_8));
            try {
                betterControlsConfig = (BetterControlsConfig)gson.getAdapter(BetterControlsConfig.class).read(jsonReader2);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jsonReader2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException | NoSuchFileException jsonReader2) {
                    break block8;
                }
                catch (IOException e) {
                    logger.error("Error reading BetterControls configuration file!", (Throwable)e);
                }
            }
            jsonReader2.close();
            return betterControlsConfig;
        }
        return new BetterControlsConfig();
    }
}

