/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettercontrols.config;

import chylex.bettercontrols.config.ConfigSerializer;
import chylex.bettercontrols.input.KeyBindingWithModifier;
import chylex.bettercontrols.input.SprintMode;
import java.nio.file.Path;

public final class BetterControlsConfig {
    private Path path;
    boolean wasMigrated = false;
    public final KeyBindingWithModifier keyToggleSprint = new KeyBindingWithModifier("key.bettercontrols.toggle_sprint");
    public SprintMode sprintMode = SprintMode.TAP_TO_START;
    public boolean doubleTapForwardToSprint = true;
    public boolean resumeSprintingAfterHittingObstacle = false;
    public final KeyBindingWithModifier keyToggleSneak = new KeyBindingWithModifier("key.bettercontrols.toggle_sneak");
    public boolean sneakingMovesCameraSmoothly = true;
    public final KeyBindingWithModifier keyToggleFlight = new KeyBindingWithModifier("key.bettercontrols.toggle_flight");
    public boolean doubleTapJumpToToggleFlight = true;
    public boolean disableFlightInertia = false;
    public boolean disableChangingFovWhileFlying = false;
    public boolean flyOnGroundInCreative = false;
    public float flightHorizontalSpeedMpCreativeDefault = 1.0f;
    public float flightHorizontalSpeedMpCreativeSprinting = 2.0f;
    public float flightHorizontalSpeedMpSpectatorDefault = 1.0f;
    public float flightHorizontalSpeedMpSpectatorSprinting = 2.0f;
    public float flightVerticalSpeedMpCreativeDefault = 1.0f;
    public float flightVerticalSpeedMpCreativeSprinting = 2.0f;
    public float flightVerticalSpeedMpSpectatorDefault = 1.0f;
    public float flightVerticalSpeedMpSpectatorSprinting = 2.0f;
    public final KeyBindingWithModifier keyToggleWalkForward = new KeyBindingWithModifier("key.bettercontrols.toggle_forward");
    public final KeyBindingWithModifier keyToggleJump = new KeyBindingWithModifier("key.bettercontrols.toggle_jump");
    public final KeyBindingWithModifier keyResetAllToggles = new KeyBindingWithModifier("key.bettercontrols.reset_all_toggles");
    public final KeyBindingWithModifier keyOpenMenu = new KeyBindingWithModifier("key.bettercontrols.open_menu");

    public static BetterControlsConfig load(Path path) {
        BetterControlsConfig cfg = ConfigSerializer.read(path);
        cfg.path = path;
        if (cfg.wasMigrated) {
            cfg.save();
        }
        return cfg;
    }

    BetterControlsConfig() {
    }

    public KeyBindingWithModifier[] getAllKeyBindings() {
        return new KeyBindingWithModifier[]{this.keyToggleSprint, this.keyToggleSneak, this.keyToggleFlight, this.keyToggleWalkForward, this.keyToggleJump, this.keyResetAllToggles, this.keyOpenMenu};
    }

    public void save() {
        ConfigSerializer.write(this.path, this);
    }
}

