/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.api.IBetterAdvancementEntryGui;
import betteradvancements.api.event.IAdvancementDrawConnectionsEvent;
import betteradvancements.gui.BetterAdvancementTab;
import betteradvancements.gui.BetterAdvancementsScreen;
import betteradvancements.platform.Services;
import betteradvancements.reference.Resources;
import betteradvancements.util.CriterionGrid;
import betteradvancements.util.RenderUtil;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_185;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_455;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class BetterAdvancementWidget
implements IBetterAdvancementEntryGui {
    protected static final int ADVANCEMENT_SIZE = 26;
    private static final int CORNER_SIZE = 10;
    private static final int WIDGET_WIDTH = 256;
    private static final int WIDGET_HEIGHT = 26;
    private static final int TITLE_SIZE = 32;
    private static final int ICON_OFFSET = 128;
    private static final int ICON_SIZE = 26;
    private final BetterAdvancementTab betterAdvancementTabGui;
    private final class_161 advancement;
    protected final BetterDisplayInfo betterDisplayInfo;
    private final class_185 displayInfo;
    private final String title;
    private int width;
    private List<class_5481> description;
    private CriterionGrid criterionGrid;
    private final class_310 minecraft;
    private BetterAdvancementWidget parent;
    private final List<BetterAdvancementWidget> children = Lists.newArrayList();
    private class_167 advancementProgress;
    protected int x;
    protected int y;
    private final int screenScale;

    public BetterAdvancementWidget(BetterAdvancementTab betterAdvancementTabGui, class_310 mc, class_161 advancement, class_185 displayInfo) {
        this.betterAdvancementTabGui = betterAdvancementTabGui;
        this.advancement = advancement;
        this.betterDisplayInfo = betterAdvancementTabGui.getBetterDisplayInfo(advancement);
        this.displayInfo = displayInfo;
        this.minecraft = mc;
        this.title = displayInfo.method_811().method_10858(163);
        this.x = this.betterDisplayInfo.getPosX() != null ? this.betterDisplayInfo.getPosX() : class_3532.method_15375((float)(displayInfo.method_818() * 32.0f));
        this.y = this.betterDisplayInfo.getPosY() != null ? this.betterDisplayInfo.getPosY() : class_3532.method_15375((float)(displayInfo.method_819() * 27.0f));
        this.refreshHover();
        this.screenScale = mc.method_22683().method_4476(0, false);
    }

    private void refreshHover() {
        class_310 mc = this.minecraft;
        int k = 0;
        if (this.advancement.method_683() > 1) {
            int strLengthRequirementCount = String.valueOf(this.advancement.method_683()).length();
            k = mc.field_1772.method_1727("  ") + mc.field_1772.method_1727("0") * strLengthRequirementCount * 2 + mc.field_1772.method_1727("/");
        }
        int titleWidth = 29 + mc.field_1772.method_1727(this.title) + k;
        BetterAdvancementsScreen screen = this.betterAdvancementTabGui.getScreen();
        this.criterionGrid = CriterionGrid.findOptimalCriterionGrid(this.advancement, this.advancementProgress, screen.field_22789 / 2, mc.field_1772);
        int maxWidth = !CriterionGrid.requiresShift || class_437.method_25442() ? Math.max(titleWidth, this.criterionGrid.width) : titleWidth;
        this.description = class_2477.method_10517().method_30933(this.findOptimalLines((class_2561)class_2564.method_10889((class_5250)this.displayInfo.method_817().method_27661(), (class_2583)class_2583.field_24360.method_10977(this.displayInfo.method_815().method_830())), maxWidth));
        for (class_5481 line : this.description) {
            maxWidth = Math.max(maxWidth, mc.field_1772.method_30880(line));
        }
        this.width = maxWidth + 8;
    }

    private List<class_5348> findOptimalLines(class_2561 line, int width) {
        if (line.getString().isEmpty()) {
            return Collections.emptyList();
        }
        class_5225 stringsplitter = this.minecraft.field_1772.method_27527();
        List list = stringsplitter.method_27495((class_5348)line, width, class_2583.field_24360);
        if (list.size() > 1) {
            width = Math.max(width, this.betterAdvancementTabGui.getScreen().internalWidth / 4);
            list = stringsplitter.method_27495((class_5348)line, width, class_2583.field_24360);
        }
        while (list.size() > 5 && (double)width < 384.0 && (double)width < (double)this.betterAdvancementTabGui.getScreen().internalWidth / 2.5) {
            width += width / 4;
            list = stringsplitter.method_27495((class_5348)line, width, class_2583.field_24360);
        }
        return list;
    }

    @Nullable
    private BetterAdvancementWidget getFirstVisibleParent(class_161 advancementIn) {
        while ((advancementIn = advancementIn.method_687()) != null && advancementIn.method_686() == null) {
        }
        if (advancementIn != null && advancementIn.method_686() != null) {
            return this.betterAdvancementTabGui.getWidget(advancementIn);
        }
        return null;
    }

    public void drawConnectivity(class_332 guiGraphics, int scrollX, int scrollY, boolean drawInside) {
        if (!this.betterDisplayInfo.hideLines().booleanValue()) {
            if (this.parent != null) {
                this.drawConnection(guiGraphics, this.parent, scrollX, scrollY, drawInside);
            }
            IAdvancementDrawConnectionsEvent event = Services.PLATFORM.getEventHelper().postAdvancementDrawConnectionsEvent(this.advancement);
            for (class_161 parent : event.getExtraConnections()) {
                BetterAdvancementWidget parentGui = this.betterAdvancementTabGui.getWidget(parent);
                if (parentGui == null) continue;
                this.drawConnection(guiGraphics, parentGui, scrollX, scrollY, drawInside);
            }
        }
        for (BetterAdvancementWidget betterAdvancementWidget : this.children) {
            betterAdvancementWidget.drawConnectivity(guiGraphics, scrollX, scrollY, drawInside);
        }
    }

    public void drawConnection(class_332 guiGraphics, BetterAdvancementWidget parent, int scrollX, int scrollY, boolean drawInside) {
        int innerLineColor = this.advancementProgress != null && this.advancementProgress.method_740() ? this.betterDisplayInfo.getCompletedLineColor() : this.betterDisplayInfo.getUnCompletedLineColor();
        int borderLineColor = -16777216;
        if (this.betterDisplayInfo.drawDirectLines().booleanValue()) {
            boolean perpendicular;
            double x1 = scrollX + this.x + 13 + 3;
            double y1 = scrollY + this.y + 13;
            double x2 = scrollX + parent.x + 13 + 3;
            double y2 = scrollY + parent.y + 13;
            boolean bl = perpendicular = x1 == x2 || y1 == y2;
            if (!perpendicular) {
                double width;
                switch (this.screenScale) {
                    case 1: {
                        width = drawInside ? 1.5 : 0.5;
                        break;
                    }
                    case 2: {
                        width = drawInside ? 2.25 : 0.75;
                        break;
                    }
                    case 3: {
                        width = drawInside ? 2.0 : 0.6666666666666667;
                        break;
                    }
                    case 4: {
                        width = drawInside ? 2.125 : 0.625;
                        break;
                    }
                    default: {
                        double d = width = drawInside ? 3.0 : 1.0;
                    }
                }
                if (drawInside) {
                    RenderUtil.drawRect(x1 - 0.75, y1 - 0.75, x2 - 0.75, y2 - 0.75, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(x1, y1, x2, y2, width, innerLineColor);
                }
            } else {
                double width;
                double d = width = drawInside ? 3.0 : 1.0;
                if (drawInside) {
                    RenderUtil.drawRect(x1 - 1.0, y1 - 1.0, x2 - 1.0, y2 - 1.0, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(x1, y1, x2, y2, width, innerLineColor);
                }
            }
        } else {
            int startX = scrollX + parent.x + 13;
            int endXHalf = scrollX + parent.x + 26 + 6;
            int startY = scrollY + parent.y + 13;
            int endX = scrollX + this.x + 13;
            int endY = scrollY + this.y + 13;
            if (drawInside) {
                guiGraphics.method_25292(endXHalf, startX, startY - 1, borderLineColor);
                guiGraphics.method_25292(endXHalf + 1, startX, startY, borderLineColor);
                guiGraphics.method_25292(endXHalf, startX, startY + 1, borderLineColor);
                guiGraphics.method_25292(endX, endXHalf - 1, endY - 1, borderLineColor);
                guiGraphics.method_25292(endX, endXHalf - 1, endY, borderLineColor);
                guiGraphics.method_25292(endX, endXHalf - 1, endY + 1, borderLineColor);
                guiGraphics.method_25301(endXHalf - 1, endY, startY, borderLineColor);
                guiGraphics.method_25301(endXHalf + 1, endY, startY, borderLineColor);
            } else {
                guiGraphics.method_25292(endXHalf, startX, startY, innerLineColor);
                guiGraphics.method_25292(endX, endXHalf, endY, innerLineColor);
                guiGraphics.method_25301(endXHalf, endY, startY, innerLineColor);
            }
        }
    }

    public void draw(class_332 guiGraphics, int scrollX, int scrollY) {
        if (!this.displayInfo.method_824() || this.advancementProgress != null && this.advancementProgress.method_740()) {
            float f = this.advancementProgress == null ? 0.0f : this.advancementProgress.method_735();
            class_455 advancementState = f >= 1.0f ? class_455.field_2701 : class_455.field_2699;
            RenderUtil.setColor(this.betterDisplayInfo.getIconColor(advancementState));
            RenderSystem.enableBlend();
            guiGraphics.method_25302(Resources.Gui.WIDGETS, scrollX + this.x + 3, scrollY + this.y, this.displayInfo.method_815().method_832(), 128 + 26 * this.betterDisplayInfo.getIconYMultiplier(advancementState), 26, 26);
            guiGraphics.method_51445(this.displayInfo.method_821(), scrollX + this.x + 8, scrollY + this.y + 5);
        }
        for (BetterAdvancementWidget betterAdvancementWidget : this.children) {
            betterAdvancementWidget.draw(guiGraphics, scrollX, scrollY);
        }
    }

    public void getAdvancementProgress(class_167 advancementProgressIn) {
        this.advancementProgress = advancementProgressIn;
        this.refreshHover();
    }

    public void addGuiAdvancement(BetterAdvancementWidget betterAdvancementEntryScreen) {
        this.children.add(betterAdvancementEntryScreen);
    }

    public void drawHover(class_332 guiGraphics, int scrollX, int scrollY, float fade, int left, int top) {
        int boxHeight;
        class_455 stateIcon;
        class_455 stateTitleRight;
        class_455 stateTitleLeft;
        boolean drawTop;
        int i;
        this.refreshHover();
        boolean drawLeft = left + scrollX + this.x + this.width + 26 >= this.betterAdvancementTabGui.getScreen().internalWidth;
        String s = this.advancementProgress == null ? null : this.advancementProgress.method_728();
        int n = i = s == null ? 0 : this.minecraft.field_1772.method_1727(s);
        if (!CriterionGrid.requiresShift || class_437.method_25442()) {
            if (this.criterionGrid.height < this.betterAdvancementTabGui.getScreen().field_22790) {
                int n2 = this.description.size();
                Objects.requireNonNull(this.minecraft.field_1772);
                drawTop = top + scrollY + this.y + n2 * 9 + this.criterionGrid.height + 50 >= this.betterAdvancementTabGui.getScreen().field_22790;
            } else {
                drawTop = false;
            }
        } else {
            int n3 = this.description.size();
            Objects.requireNonNull(this.minecraft.field_1772);
            drawTop = top + scrollY + this.y + n3 * 9 + 50 >= this.betterAdvancementTabGui.getScreen().field_22790;
        }
        float percentageObtained = this.advancementProgress == null ? 0.0f : this.advancementProgress.method_735();
        int j = class_3532.method_15375((float)(percentageObtained * (float)this.width));
        if (percentageObtained >= 1.0f) {
            j = this.width / 2;
            stateTitleLeft = class_455.field_2701;
            stateTitleRight = class_455.field_2701;
            stateIcon = class_455.field_2701;
        } else if (j < 2) {
            j = this.width / 2;
            stateTitleLeft = class_455.field_2699;
            stateTitleRight = class_455.field_2699;
            stateIcon = class_455.field_2699;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            stateTitleLeft = class_455.field_2701;
            stateTitleRight = class_455.field_2701;
            stateIcon = class_455.field_2699;
        } else {
            stateTitleLeft = class_455.field_2701;
            stateTitleRight = class_455.field_2699;
            stateIcon = class_455.field_2699;
        }
        int k = this.width - j;
        RenderSystem.enableBlend();
        int drawY = scrollY + this.y;
        int drawX = drawLeft ? scrollX + this.x - this.width + 26 + 6 : scrollX + this.x;
        if (!CriterionGrid.requiresShift || class_437.method_25442()) {
            int n4 = this.description.size();
            Objects.requireNonNull(this.minecraft.field_1772);
            boxHeight = 32 + n4 * 9 + this.criterionGrid.height;
        } else {
            int n5 = this.description.size();
            Objects.requireNonNull(this.minecraft.field_1772);
            boxHeight = 32 + n5 * 9;
        }
        if (!this.description.isEmpty()) {
            if (drawTop) {
                this.render9Sprite(guiGraphics, drawX, drawY + 26 - boxHeight, this.width, boxHeight, 10, 256, 26, 0, 52);
            } else {
                this.render9Sprite(guiGraphics, drawX, drawY, this.width, boxHeight, 10, 256, 26, 0, 52);
            }
        }
        RenderUtil.setColor(this.betterDisplayInfo.getTitleColor(stateTitleLeft));
        int left_side = Math.min(j, 240);
        guiGraphics.method_25302(Resources.Gui.WIDGETS, drawX, drawY, 0, this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26, left_side, 26);
        if (left_side < j) {
            guiGraphics.method_25302(Resources.Gui.WIDGETS, drawX + left_side, drawY, 16, this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26, j - left_side, 26);
        }
        RenderUtil.setColor(this.betterDisplayInfo.getTitleColor(stateTitleRight));
        int right_side = Math.min(k, 240);
        guiGraphics.method_25302(Resources.Gui.WIDGETS, drawX + j, drawY, 256 - right_side, this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26, right_side, 26);
        if (right_side < k) {
            guiGraphics.method_25302(Resources.Gui.WIDGETS, drawX + j + right_side - 2, drawY, 256 - k + right_side - 2, this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26, k - right_side + 2, 26);
        }
        RenderUtil.setColor(this.betterDisplayInfo.getIconColor(stateIcon));
        guiGraphics.method_25302(Resources.Gui.WIDGETS, scrollX + this.x + 3, scrollY + this.y, this.displayInfo.method_815().method_832(), 128 + 26 * this.betterDisplayInfo.getIconYMultiplier(stateIcon), 26, 26);
        if (drawLeft) {
            guiGraphics.method_25303(this.minecraft.field_1772, this.title, drawX + 5, scrollY + this.y + 9, -1);
            if (s != null) {
                guiGraphics.method_25303(this.minecraft.field_1772, s, scrollX + this.x - i, scrollY + this.y + 9, -1);
            }
        } else {
            guiGraphics.method_25303(this.minecraft.field_1772, this.title, scrollX + this.x + 32, scrollY + this.y + 9, -1);
            if (s != null) {
                guiGraphics.method_25303(this.minecraft.field_1772, s, scrollX + this.x + this.width - i - 5, scrollY + this.y + 9, -1);
            }
        }
        int yOffset = drawTop ? drawY + 26 - boxHeight + 7 : scrollY + this.y + 9 + 17;
        for (int k1 = 0; k1 < this.description.size(); ++k1) {
            class_327 class_3272 = this.minecraft.field_1772;
            Objects.requireNonNull(this.minecraft.field_1772);
            guiGraphics.method_51430(class_3272, this.description.get(k1), drawX + 5, yOffset + k1 * 9, -5592406, false);
        }
        if (this.criterionGrid != null && !CriterionGrid.requiresShift || class_437.method_25442()) {
            int xOffset = drawX + 5;
            int n6 = this.description.size();
            Objects.requireNonNull(this.minecraft.field_1772);
            yOffset += n6 * 9;
            for (int colIndex = 0; colIndex < this.criterionGrid.columns.size(); ++colIndex) {
                CriterionGrid.Column col = this.criterionGrid.columns.get(colIndex);
                for (int rowIndex = 0; rowIndex < col.cells.size(); ++rowIndex) {
                    class_327 class_3273 = this.minecraft.field_1772;
                    Objects.requireNonNull(this.minecraft.field_1772);
                    guiGraphics.method_51433(class_3273, col.cells.get(rowIndex), xOffset, yOffset + rowIndex * 9, -5592406, false);
                }
                xOffset += col.width;
            }
        }
        guiGraphics.method_51445(this.displayInfo.method_821(), scrollX + this.x + 8, scrollY + this.y + 5);
    }

    protected void render9Sprite(class_332 guiGraphics, int x, int y, int width, int height, int textureHeight, int textureWidth, int textureDistance, int textureX, int textureY) {
        guiGraphics.method_25302(Resources.Gui.WIDGETS, x, y, textureX, textureY, textureHeight, textureHeight);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + textureHeight, y, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY, textureWidth - textureHeight - textureHeight, textureDistance);
        guiGraphics.method_25302(Resources.Gui.WIDGETS, x + width - textureHeight, y, textureX + textureWidth - textureHeight, textureY, textureHeight, textureHeight);
        guiGraphics.method_25302(Resources.Gui.WIDGETS, x, y + height - textureHeight, textureX, textureY + textureDistance - textureHeight, textureHeight, textureHeight);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + textureHeight, y + height - textureHeight, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY + textureDistance - textureHeight, textureWidth - textureHeight - textureHeight, textureDistance);
        guiGraphics.method_25302(Resources.Gui.WIDGETS, x + width - textureHeight, y + height - textureHeight, textureX + textureWidth - textureHeight, textureY + textureDistance - textureHeight, textureHeight, textureHeight);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + textureHeight, y + textureHeight, width - textureHeight - textureHeight, height - textureHeight - textureHeight, textureX + textureHeight, textureY + textureHeight, textureWidth - textureHeight - textureHeight, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + width - textureHeight, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX + textureWidth - textureHeight, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
    }

    public boolean isMouseOver(double scrollX, double scrollY, double mouseX, double mouseY) {
        if (!this.displayInfo.method_824() || this.advancementProgress != null && this.advancementProgress.method_740()) {
            double left = scrollX + (double)this.x;
            double right = left + 26.0;
            double top = scrollY + (double)this.y;
            double bottom = top + 26.0;
            return mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom;
        }
        return false;
    }

    public void attachToParent() {
        if (this.parent == null && this.advancement.method_687() != null) {
            this.parent = this.getFirstVisibleParent(this.advancement);
            if (this.parent != null) {
                this.parent.addGuiAdvancement(this);
            }
        }
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public class_161 getAdvancement() {
        return this.advancement;
    }
}

