/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.bukkit.Beenfo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Beehive;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class Main
extends JavaPlugin
implements Listener,
PluginMessageListener {
    public static final String MODID = "beenfo";
    public static final String C2SPacketIdentifier = "beenfo:c2s";
    public static final String S2CPacketIdentifier = "beenfo:s2c";
    public static final String S2CPacketIdentifierHud = "beenfo:s2chud";

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, S2CPacketIdentifier);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, S2CPacketIdentifierHud);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, C2SPacketIdentifier, (PluginMessageListener)this);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        BlockState state;
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.hasBlock() && (state = event.getClickedBlock().getState()) instanceof org.bukkit.block.Beehive && (event.getItem() == null || event.getItem().getType() == Material.AIR)) {
            Player player = event.getPlayer();
            Beehive hiveData = (Beehive)state.getBlockData();
            int honeyLevel = hiveData.getHoneyLevel();
            CraftWorld world = (CraftWorld)player.getWorld();
            Location l = event.getClickedBlock().getLocation();
            BlockPosition pos = new BlockPosition(l.getBlockX(), l.getBlockY(), l.getBlockZ());
            TileEntity te = world.getHandle().getBlockEntity(pos, true);
            if (te instanceof TileEntityBeehive) {
                TileEntityBeehive hive = (TileEntityBeehive)te;
                NBTTagList bees = hive.j();
                int neededSize = 8;
                for (int i = 0; i < bees.size(); ++i) {
                    NBTTagCompound beeData = bees.a(i).p("EntityData");
                    if (beeData != null && beeData.b("CustomName", 8)) {
                        String beeName = beeData.l("CustomName");
                        neededSize += beeName.length() + 1;
                        continue;
                    }
                    ++neededSize;
                }
                byte[] sendBuffer = new byte[neededSize];
                this.writeInt(sendBuffer, 0, honeyLevel);
                this.writeInt(sendBuffer, 4, bees.size());
                int bufPos = 8;
                for (int i = 0; i < bees.size(); ++i) {
                    NBTTagCompound beeData = bees.a(i).p("EntityData");
                    if (beeData != null && beeData.b("CustomName", 8)) {
                        String beeName = beeData.l("CustomName");
                        sendBuffer[bufPos++] = (byte)beeName.length();
                        System.arraycopy(beeName.getBytes(), 0, sendBuffer, bufPos, beeName.length());
                        bufPos += beeName.length();
                        continue;
                    }
                    sendBuffer[bufPos++] = 0;
                }
                player.sendPluginMessage((Plugin)this, S2CPacketIdentifier, sendBuffer);
            }
        }
    }

    private void writeInt(byte[] buffer, int pos, int val) {
        buffer[pos + 2] = 0;
        buffer[pos + 1] = 0;
        buffer[pos] = 0;
        buffer[pos + 3] = (byte)val;
    }

    public void onPluginMessageReceived(String string, Player player, byte[] bytes) {
        try {
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(bytes));
            int packetVersion = is.readInt();
            long blockPosLong = is.readLong();
            BlockPosition pos = BlockPosition.d((long)blockPosLong);
            BlockData blockData = player.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()).getState().getBlockData();
            if (!(blockData instanceof Beehive)) {
                return;
            }
            Beehive hivedata = (Beehive)blockData;
            TileEntityBeehive hive = (TileEntityBeehive)((CraftWorld)player.getWorld()).getHandle().c_(pos);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(baos);
            os.writeInt(0);
            os.writeInt(hivedata.getHoneyLevel());
            os.writeInt(hive.g());
            os.writeLong(blockPosLong);
            os.close();
            player.sendPluginMessage((Plugin)this, S2CPacketIdentifierHud, baos.toByteArray());
            baos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

