/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.registration;

import com.thenatekirby.babel.api.IBlockProvider;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class DeferredTileEntity<T extends Block, U extends TileEntity>
implements IBlockProvider {
    private final String name;
    private final RegistryObject<T> block;
    private final RegistryObject<TileEntityType<U>> tileEntity;
    private final RegistryObject<Item> item;

    public DeferredTileEntity(String name, Supplier<T> blockSupplier, Supplier<U> tileEntitySupplier, Item.Properties itemProperties, DeferredRegister<Block> blockRegister, DeferredRegister<Item> itemRegister, DeferredRegister<TileEntityType<?>> tileEntityRegister) {
        this.name = name;
        this.block = blockRegister.register(name, blockSupplier);
        this.tileEntity = tileEntityRegister.register(name, () -> TileEntityType.Builder.func_223042_a((Supplier)tileEntitySupplier, (Block[])new Block[]{(Block)this.block.get()}).func_206865_a(null));
        this.item = itemRegister.register(name, () -> new BlockItem((Block)this.block.get(), itemProperties));
    }

    public static <T extends Block, U extends TileEntity> DeferredTileEntity<T, U> create(String name, Supplier<T> blockSupplier, Supplier<U> tileEntitySupplier, Item.Properties itemProperties, DeferredRegister<Block> blockRegister, DeferredRegister<Item> itemRegister, DeferredRegister<TileEntityType<?>> tileEntityRegister) {
        return new DeferredTileEntity<T, U>(name, blockSupplier, tileEntitySupplier, itemProperties, blockRegister, itemRegister, tileEntityRegister);
    }

    public String getName() {
        return this.name;
    }

    @Nonnull
    public T asBlock() {
        return (T)((Block)this.block.get());
    }

    public TileEntityType<U> asTileEntityType() {
        return (TileEntityType)this.tileEntity.get();
    }

    public Item asItem() {
        return (Item)this.item.get();
    }
}

