/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thenatekirby.babel.condition.IRecipeCondition;
import com.thenatekirby.babel.core.RecipeIngredient;
import com.thenatekirby.babel.mod.BabelSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;

public class TaggedSmeltingRecipeBuilder {
    private final ResourceLocation recipeId;
    private RecipeIngredient input;
    private RecipeIngredient output;
    private float experience = 0.1f;
    private int cookingTime = 200;
    private List<JsonObject> conditions = new ArrayList<JsonObject>();

    private TaggedSmeltingRecipeBuilder(@Nonnull ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public static TaggedSmeltingRecipeBuilder builder(@Nonnull ResourceLocation recipeId) {
        return new TaggedSmeltingRecipeBuilder(recipeId);
    }

    public TaggedSmeltingRecipeBuilder withInput(RecipeIngredient input) {
        this.input = input;
        return this;
    }

    public TaggedSmeltingRecipeBuilder withOutput(RecipeIngredient output) {
        this.output = output;
        return this;
    }

    public TaggedSmeltingRecipeBuilder withCookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
        return this;
    }

    public TaggedSmeltingRecipeBuilder withExperience(float experience) {
        this.experience = experience;
        return this;
    }

    public TaggedSmeltingRecipeBuilder withCondition(IRecipeCondition condition) {
        this.conditions.add(condition.serializeJson());
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        consumer.accept(new Result(this.recipeId, this.input, this.output, this.experience, this.cookingTime, this.conditions));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final RecipeIngredient input;
        private final RecipeIngredient output;
        private final float experience;
        private final int cookingTime;
        private final List<JsonObject> conditions;

        public Result(ResourceLocation recipeId, RecipeIngredient input, RecipeIngredient output, float experience, int cookingTime, List<JsonObject> conditions) {
            this.id = recipeId;
            this.input = input;
            this.output = output;
            this.experience = experience;
            this.cookingTime = cookingTime;
            this.conditions = conditions;
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            if (!this.conditions.isEmpty()) {
                JsonArray conditions = new JsonArray();
                for (JsonObject condition : this.conditions) {
                    conditions.add((JsonElement)condition);
                }
                json.add("conditions", (JsonElement)conditions);
            }
            json.add("ingredient", (JsonElement)this.input.serializeJson());
            json.add("result", (JsonElement)this.output.serializeJson());
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cookingtime", (Number)this.cookingTime);
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return BabelSerializers.TAGGED_SMELTING.getAsRecipeSerializer();
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

