/*
 * Decompiled with CFR 0.152.
 */
package com.thenatekirby.babel.core;

import com.thenatekirby.babel.api.IProgress;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class Progress
implements IProgress,
INBTSerializable<CompoundNBT> {
    public static final Progress NO_PROGRESS = new Progress();
    private int min = 0;
    private int max = 0;
    private int current = 0;

    public Progress() {
        this(0, 0, 0);
    }

    public Progress(int min, int max, int current) {
        this.min = min;
        this.max = max;
        this.current = current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void advance() {
        ++this.current;
    }

    public boolean isComplete() {
        return this.current >= this.max;
    }

    public boolean canAdvance() {
        return this.max > 0;
    }

    public void reset() {
        this.current = 0;
    }

    @Override
    public int getProgressMin() {
        return this.min;
    }

    @Override
    public int getProgressMax() {
        return this.max;
    }

    @Override
    public int getProgressCurrent() {
        return this.current;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("max", this.max);
        nbt.func_74768_a("current", this.current);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.max = nbt.func_74762_e("max");
        this.current = nbt.func_74762_e("current");
    }
}

