/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.value;

import java.lang.reflect.Field;
import mod.azure.azurelib.config.ConfigUtils;
import mod.azure.azurelib.config.adapter.TypeAdapter;
import mod.azure.azurelib.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.config.format.IConfigFormat;
import mod.azure.azurelib.config.value.ConfigValue;
import mod.azure.azurelib.config.value.DecimalValue;
import mod.azure.azurelib.config.value.ValueData;
import net.minecraft.class_2540;

public class DoubleValue
extends DecimalValue<Double> {
    public DoubleValue(ValueData<Double> valueData) {
        super(valueData, DecimalValue.Range.unboundedDouble());
    }

    @Override
    public Double getCorrectedValue(Double in) {
        if (this.range == null) {
            return in;
        }
        if (!this.range.isWithin(in)) {
            double corrected = this.range.clamp(in);
            ConfigUtils.logCorrectedMessage(this.getId(), in, corrected);
            return corrected;
        }
        return in;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeDouble(this.getId(), (Double)this.get());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(format.readDouble(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new DoubleValue(ValueData.of(name, Double.valueOf((Double)value), context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, class_2540 buffer) {
            buffer.writeDouble(((Double)value.get()).doubleValue());
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, class_2540 buffer) {
            return buffer.readDouble();
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setDouble(instance, (Double)value);
        }
    }
}

