/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import vazkii.arl.network.IMessage;
import vazkii.arl.network.MessageSerializer;

public class NetworkHandler {
    public final SimpleChannel channel;
    private int i = 0;

    public NetworkHandler(String modid, int protocol) {
        this(modid, "main", protocol);
    }

    public NetworkHandler(String modid, String channelName, int protocol) {
        String protocolStr = Integer.toString(protocol);
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modid, channelName)).networkProtocolVersion(() -> protocolStr).clientAcceptedVersions(protocolStr::equals).serverAcceptedVersions(protocolStr::equals).simpleChannel();
    }

    public <T extends IMessage> void register(Class<T> clazz, NetworkDirection dir) {
        BiConsumer<IMessage, PacketBuffer> encoder = MessageSerializer::writeObject;
        Function<PacketBuffer, IMessage> decoder = buf -> {
            try {
                IMessage msg = (IMessage)clazz.newInstance();
                MessageSerializer.readObject(msg, buf);
                return msg;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        };
        BiConsumer<IMessage, Supplier> consumer = (msg, supp) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supp.get();
            if (context.getDirection() != dir) {
                return;
            }
            context.setPacketHandled(msg.receive(context));
        };
        this.channel.registerMessage(this.i, clazz, encoder, decoder, consumer);
        ++this.i;
    }

    public void sendToPlayer(IMessage msg, ServerPlayerEntity player) {
        this.channel.sendTo((Object)msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendToServer(IMessage msg) {
        this.channel.sendToServer((Object)msg);
    }
}

