/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.ash.api.options;

import com.diontryban.ash.Ash;
import com.diontryban.ash.api.modloader.ModLoader;
import com.diontryban.ash.api.options.ModOptions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;

public class ModOptionsManager<O extends ModOptions> {
    private final String modId;
    private final Class<O> optionsClass;
    private final File file;
    private O options;

    public ModOptionsManager(String modId, Class<O> optionsClass) {
        this.modId = modId;
        this.optionsClass = optionsClass;
        this.file = ModLoader.getConfigDir().resolve(modId + ".json").toFile();
        this.read();
    }

    private O defaultOptions() {
        try {
            return (O)((ModOptions)this.optionsClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Config for mod " + this.modId + " does not have an empty constructor.");
        }
    }

    public void read() {
        if (!this.file.exists()) {
            this.options = this.defaultOptions();
            this.write();
        } else {
            try (FileReader reader = new FileReader(this.file);){
                Gson gson = new Gson();
                this.options = (ModOptions)gson.fromJson((Reader)reader, this.optionsClass);
                if (((ModOptions)this.options).version < ((ModOptions)this.defaultOptions()).getVersion()) {
                    Ash.LOG.info("Found deprecated config file for mod " + this.modId + ". Updating.");
                    this.options = this.defaultOptions();
                    this.write();
                }
            }
            catch (IOException e) {
                Ash.LOG.error("Failed to read " + this.modId + "'s config file.");
                this.options = this.defaultOptions();
                this.write();
            }
        }
    }

    public void write() {
        try (FileWriter writer = new FileWriter(this.file);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.write(gson.toJson(this.options));
            writer.flush();
        }
        catch (IOException e) {
            Ash.LOG.error("Failed to write to config file for mod " + this.modId + ".");
        }
    }

    public O get() {
        return this.options;
    }

    public String getModId() {
        return this.modId;
    }
}

