/*
 * Decompiled with CFR 0.152.
 */
package artifacts.data;

import artifacts.common.init.ModItems;
import artifacts.common.init.ModLootTables;
import artifacts.common.loot.ConfigurableRandomChance;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.EntityFlagsPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.Smelt;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;

public class LootTables
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = new ArrayList<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>>();
    private final ExistingFileHelper existingFileHelper;

    public LootTables(DataGenerator dataGenerator, ExistingFileHelper existingFileHelper) {
        super(dataGenerator);
        this.existingFileHelper = existingFileHelper;
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        this.tables.clear();
        this.addDrinkingHatsLootTable();
        this.addArtifactsLootTable();
        this.addChestLootTables();
        this.addLootTable("inject/entities/cow", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.002f)).func_212840_b_(KilledByPlayer.func_215994_b()).func_216045_a((LootEntry.Builder)LootTables.createItemEntry((Item)ModItems.EVERLASTING_BEEF.get(), 1).func_212841_b_((ILootFunction.IBuilder)Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_217987_a(EntityFlagsPredicate.Builder.func_217967_a().func_217968_a(Boolean.valueOf(true)).func_217966_b())))))), LootParameterSets.field_216263_d);
        return this.tables;
    }

    private void addArtifactsLootTable() {
        this.addLootTable("artifact", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SNORKEL.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.NIGHT_VISION_GOGGLES.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.PANIC_NECKLACE.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SHOCK_PENDANT.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FLAME_PENDANT.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.THORN_PENDANT.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FLIPPERS.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.OBSIDIAN_SKULL.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FIRE_GAUNTLET.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FERAL_CLAWS.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.POCKET_PISTON.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.POWER_GLOVE.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.ANTIDOTE_VESSEL.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.LUCKY_SCARF.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SCARF_OF_INVISIBILITY.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.DIGGING_CLAWS.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.STEADFAST_SPIKES.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.UNIVERSAL_ATTRACTOR.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.KITTY_SLIPPERS.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.RUNNING_SHOES.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.BUNNY_HOPPERS.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CRYSTAL_HEART.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.VILLAGER_HAT.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.VAMPIRIC_GLOVE.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.GOLDEN_HOOK.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CHARM_OF_SINKING.get(), 8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.AQUA_DASHERS.get(), 8)).func_216045_a(LootTables.createDrinkingHatEntry(8)).func_216045_a(LootTables.createItemEntry((Item)ModItems.UMBRELLA.get(), 5)).func_216045_a(LootTables.createItemEntry((Item)ModItems.WHOOPEE_CUSHION.get(), 5)).func_216045_a(LootTables.createItemEntry((Item)ModItems.HELIUM_FLAMINGO.get(), 4)).func_216045_a(LootTables.createItemEntry((Item)ModItems.EVERLASTING_BEEF.get(), 2))));
    }

    private void addDrinkingHatsLootTable() {
        this.addLootTable("items/drinking_hat", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.PLASTIC_DRINKING_HAT.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.NOVELTY_DRINKING_HAT.get(), 1))));
    }

    private void addChestLootTables() {
        for (String biome : Arrays.asList("desert", "plains", "savanna", "snowy", "taiga")) {
            this.addLootTable(String.format("inject/chests/village/village_%s_house", biome), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.02f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.VILLAGER_HAT.get(), 1))));
        }
        this.addLootTable("inject/chests/spawn_bonus_chest", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_212840_b_(ConfigurableRandomChance.configurableRandomChance(1.0f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.WHOOPEE_CUSHION.get(), 1))));
        this.addLootTable("inject/chests/village/village_armorer", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.1f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.STEADFAST_SPIKES.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.RUNNING_SHOES.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.VAMPIRIC_GLOVE.get(), 1))));
        this.addLootTable("inject/chests/village/village_butcher", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.02f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.EVERLASTING_BEEF.get(), 1))));
        this.addLootTable("inject/chests/village/village_tannery", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.2f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.UMBRELLA.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.WHOOPEE_CUSHION.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.KITTY_SLIPPERS.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.BUNNY_HOPPERS.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SCARF_OF_INVISIBILITY.get(), 1))));
        this.addLootTable("inject/chests/village/village_temple", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.2f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.ANTIDOTE_VESSEL.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CHARM_OF_SINKING.get(), 1))));
        this.addLootTable("inject/chests/village/village_toolsmith", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.15f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.DIGGING_CLAWS.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.POCKET_PISTON.get(), 1))));
        this.addLootTable("inject/chests/village/village_weaponsmith", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.1f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FERAL_CLAWS.get(), 1))));
        this.addLootTable("inject/chests/abandoned_mineshaft", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.3f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.NIGHT_VISION_GOGGLES.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.PANIC_NECKLACE.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.OBSIDIAN_SKULL.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.DIGGING_CLAWS.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.VAMPIRIC_GLOVE.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.AQUA_DASHERS.get(), 2)).func_216045_a(LootTables.createDrinkingHatEntry(2))));
        this.addLootTable("inject/chests/bastion_hoglin_stable", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.2f)).func_216045_a(LootTables.createArtifactEntry(5)).func_216045_a(LootTables.createItemEntry((Item)ModItems.BUNNY_HOPPERS.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FLAME_PENDANT.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.EVERLASTING_BEEF.get(), 1))));
        this.addLootTable("inject/chests/bastion_treasure", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.65f)).func_216045_a(LootTables.createArtifactEntry(6)).func_216045_a(LootTables.createItemEntry((Item)ModItems.GOLDEN_HOOK.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FIRE_GAUNTLET.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.STEADFAST_SPIKES.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.PANIC_NECKLACE.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CRYSTAL_HEART.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.ANTIDOTE_VESSEL.get(), 1))));
        this.addLootTable("inject/chests/buried_treasure", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.25f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SNORKEL.get(), 5)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FLIPPERS.get(), 5)).func_216045_a(LootTables.createItemEntry((Item)ModItems.UMBRELLA.get(), 5)).func_216045_a(LootTables.createItemEntry((Item)ModItems.GOLDEN_HOOK.get(), 5)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FERAL_CLAWS.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.DIGGING_CLAWS.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.KITTY_SLIPPERS.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.BUNNY_HOPPERS.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.LUCKY_SCARF.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.AQUA_DASHERS.get(), 3)).func_216045_a(LootTables.createDrinkingHatEntry(3))));
        this.addLootTable("inject/chests/desert_pyramid", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.2f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FLAME_PENDANT.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.THORN_PENDANT.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.WHOOPEE_CUSHION.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CHARM_OF_SINKING.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SHOCK_PENDANT.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.UMBRELLA.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SCARF_OF_INVISIBILITY.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.UNIVERSAL_ATTRACTOR.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.VAMPIRIC_GLOVE.get(), 1))));
        this.addLootTable("inject/chests/end_city_treasure", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.3f)).func_216045_a(LootTables.createArtifactEntry(3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CRYSTAL_HEART.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.HELIUM_FLAMINGO.get(), 4))));
        this.addLootTable("inject/chests/jungle_temple", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.3f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.KITTY_SLIPPERS.get(), 2)).func_216045_a(LootTables.createItemEntry((Item)ModItems.BUNNY_HOPPERS.get(), 1))));
        this.addLootTable("inject/chests/nether_bridge", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.15f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.NIGHT_VISION_GOGGLES.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.POCKET_PISTON.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.RUNNING_SHOES.get(), 3)).func_216045_a(LootTables.createDrinkingHatEntry(3))));
        this.addLootTable("inject/chests/pillager_outpost", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.25f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.PANIC_NECKLACE.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.POCKET_PISTON.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.STEADFAST_SPIKES.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.POWER_GLOVE.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SCARF_OF_INVISIBILITY.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CRYSTAL_HEART.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 1))));
        this.addLootTable("inject/chests/ruined_portal", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.15f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.NIGHT_VISION_GOGGLES.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.THORN_PENDANT.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FIRE_GAUNTLET.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.POWER_GLOVE.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.UNIVERSAL_ATTRACTOR.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.OBSIDIAN_SKULL.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.LUCKY_SCARF.get(), 1))));
        this.addLootTable("inject/chests/shipwreck_treasure", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.15f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.GOLDEN_HOOK.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SNORKEL.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FLIPPERS.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SCARF_OF_INVISIBILITY.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.STEADFAST_SPIKES.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.UNIVERSAL_ATTRACTOR.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FERAL_CLAWS.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.NIGHT_VISION_GOGGLES.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.OBSIDIAN_SKULL.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.RUNNING_SHOES.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CHARM_OF_SINKING.get(), 1))));
        this.addLootTable("inject/chests/stronghold_corridor", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.3f)).func_216045_a(LootTables.createArtifactEntry(3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.POWER_GLOVE.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.ANTIDOTE_VESSEL.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.LUCKY_SCARF.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.AQUA_DASHERS.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.HELIUM_FLAMINGO.get(), 1))));
        this.addLootTable("inject/chests/underwater_ruin_big", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.45f)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SNORKEL.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FLIPPERS.get(), 3)).func_216045_a(LootTables.createItemEntry((Item)ModItems.SUPERSTITIOUS_HAT.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.LUCKY_SCARF.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.FIRE_GAUNTLET.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CROSS_NECKLACE.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.POWER_GLOVE.get(), 1)).func_216045_a(LootTables.createItemEntry((Item)ModItems.CLOUD_IN_A_BOTTLE.get(), 1))));
        this.addLootTable("inject/chests/woodland_mansion", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(ConfigurableRandomChance.configurableRandomChance(0.25f)).func_216045_a(LootTables.createArtifactEntry(1))));
    }

    private static StandaloneLootEntry.Builder<?> createItemEntry(Item item, int weight) {
        return ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight);
    }

    private static LootEntry.Builder<?> createArtifactEntry(int weight) {
        return LootTables.createLootTableEntry("artifact", weight);
    }

    private static LootEntry.Builder<?> createDrinkingHatEntry(int weight) {
        return LootTables.createLootTableEntry("items/drinking_hat", weight);
    }

    private static LootEntry.Builder<?> createLootTableEntry(String lootTable, int weight) {
        return TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("artifacts", lootTable)).func_216086_a(weight);
    }

    private void addLootTable(String location, LootTable.Builder lootTable, LootParameterSet lootParameterSet) {
        if (location.startsWith("inject/")) {
            String actualLocation = location.replace("inject/", "");
            Preconditions.checkArgument((boolean)this.existingFileHelper.exists(new ResourceLocation("loot_tables/" + actualLocation + ".json"), ResourcePackType.SERVER_DATA), (String)"Loot table %s does not exist in any known data pack", (Object)actualLocation);
            Preconditions.checkArgument((boolean)ModLootTables.LootTableEvents.LOOT_TABLE_LOCATIONS.contains(actualLocation), (String)"Loot table %s does not exist in list of injected loot tables", (Object)actualLocation);
        }
        this.tables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>)Pair.of(() -> lootBuilder -> lootBuilder.accept(new ResourceLocation("artifacts", location), lootTable), (Object)lootParameterSet));
    }

    private void addLootTable(String location, LootTable.Builder lootTable) {
        this.addLootTable(location, lootTable, LootParameterSets.field_216266_g);
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((loc, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)loc, (LootTable)table));
    }
}

