/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.hands;

import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.CurioItem;
import artifacts.common.util.DamageSourceHelper;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import top.theillusivec4.curios.api.SlotContext;

public class PowerGloveItem
extends CurioItem {
    public PowerGloveItem() {
        this.addListener(LivingAttackEvent.class, this::onLivingAttack, (T event) -> DamageSourceHelper.getAttacker(event.getSource()));
    }

    private void onLivingAttack(LivingAttackEvent event, LivingEntity wearer) {
        if (DamageSourceHelper.isMeleeAttack(event.getSource())) {
            this.damageEquippedStacks(wearer);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!ModConfig.server.isCosmetic(this)) {
            int attackDamageBonus = (Integer)ModConfig.server.powerGlove.attackDamageBonus.get();
            result.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(uuid, new ResourceLocation("artifacts", "power_glove_attack_damage").toString(), (double)attackDamageBonus, AttributeModifier.Operation.ADDITION));
        }
        return result;
    }
}

