/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.curio.renderer;

import artifacts.client.render.curio.model.BeltModel;
import artifacts.client.render.curio.renderer.CurioRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class BeltCurioRenderer
implements CurioRenderer {
    private final ResourceLocation texture;
    private final BeltModel model;

    public BeltCurioRenderer(String texturePath, BeltModel model) {
        this(new ResourceLocation("artifacts", String.format("textures/entity/curio/%s.png", texturePath)), model);
    }

    public BeltCurioRenderer(ResourceLocation texture, BeltModel model) {
        this.texture = texture;
        this.model = model;
    }

    protected ResourceLocation getTexture() {
        return this.texture;
    }

    protected BeltModel getModel() {
        return this.model;
    }

    @Override
    public final void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ticks, float headYaw, float headPitch, ItemStack stack) {
        BeltModel model = this.getModel();
        model.func_225597_a_(entity, limbSwing, limbSwingAmount, ticks, headYaw, headPitch);
        model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setCharmPosition(index);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)entity, (BipedModel[])new BipedModel[]{model});
        this.render(matrixStack, buffer, light, stack.func_77962_s());
    }

    protected void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, boolean hasFoil) {
        RenderType renderType = this.model.func_228282_a_(this.getTexture());
        IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        this.model.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

