/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.LightBlock;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class JarOfLight
extends ModItem {
    public JarOfLight() {
        super("jar_of_light");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (worldIn.field_72995_K) {
            return;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        if (this.lightExists(tag = stack.func_77978_p())) {
            if (this.getLightLocation(tag) == null) {
                this.setLightExists(tag, false);
                return;
            }
            BlockPos lightLocation = this.getLightLocation(tag);
            BlockState state = worldIn.func_180495_p(lightLocation);
            if (!(state.func_177230_c() instanceof LightBlock)) {
                this.setLightExists(tag, false);
                this.setLightLocation(tag, null);
            }
            if (BlockUtil.distanceFrom(lightLocation, entityIn.func_233580_cy_()) > 7.0) {
                Direction opposite = entityIn.func_174811_aO().func_176734_d();
                BlockPos preferredLightPos = entityIn.func_233580_cy_().func_177967_a(opposite, 1);
                this.removeLight(worldIn, tag);
                if (!this.placeLight(worldIn, preferredLightPos, tag)) {
                    this.placeLight(worldIn, preferredLightPos.func_177981_b(2), tag);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        CompoundNBT tag = playerIn.func_184586_b(handIn).func_77978_p();
        if (tag == null) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        if (this.lightExists(tag)) {
            this.removeLight(worldIn, tag);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        this.placeLight(worldIn, playerIn.func_233580_cy_(), tag);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public boolean placeLight(World world, BlockPos pos, CompoundNBT tag) {
        if (world.func_180495_p(pos).func_185904_a() == Material.field_151579_a) {
            world.func_175656_a(pos, BlockRegistry.LIGHT_BLOCK.func_176223_P());
            this.setLightExists(tag, true);
            this.setLightLocation(tag, pos);
            return true;
        }
        return false;
    }

    public void removeLight(World world, CompoundNBT tag) {
        if (this.getLightLocation(tag) == null) {
            return;
        }
        if (world.func_180495_p(this.getLightLocation(tag)).func_177230_c() instanceof LightBlock) {
            world.func_175656_a(this.getLightLocation(tag), Blocks.field_150350_a.func_176223_P());
        }
        this.setLightExists(tag, false);
    }

    public boolean lightExists(CompoundNBT tag) {
        return tag.func_74764_b("light_exists") && tag.func_74767_n("light_exists");
    }

    public void setLightExists(CompoundNBT tag, boolean lightExists) {
        tag.func_74757_a("light_exists", lightExists);
    }

    public BlockPos getLightLocation(CompoundNBT tag) {
        if (!(tag.func_74764_b("x") && tag.func_74764_b("y") && tag.func_74764_b("z"))) {
            return null;
        }
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public void setLightLocation(CompoundNBT tag, BlockPos pos) {
        if (pos == null) {
            tag.func_82580_o("x");
            tag.func_82580_o("y");
            tag.func_82580_o("z");
            return;
        }
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
    }
}

