/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs;

import com.hollingsworth.arsnouveau.common.entity.pathfinding.Node;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs.AbstractPathJob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class PathJobMoveToLocation
extends AbstractPathJob {
    public static final float DESTINATION_SLACK_NONE = 0.1f;
    public static final float DESTINATION_SLACK_ADJACENT = (float)Math.sqrt(2.0);
    public BlockPos destination;
    public float destinationSlack = 0.1f;

    public PathJobMoveToLocation(World world, BlockPos start, BlockPos end, int range, LivingEntity entity) {
        super(world, start, end, range, entity);
        this.destination = new BlockPos((Vector3i)end);
    }

    @Override
    protected Path search() {
        if (this.getGroundHeight(null, this.destination) != this.destination.func_177956_o()) {
            this.destinationSlack = DESTINATION_SLACK_ADJACENT;
        }
        return super.search();
    }

    @Override
    protected BlockPos getPathTargetPos(Node finalNode) {
        return this.destination;
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        return Math.sqrt(this.destination.func_177951_i((Vector3i)pos));
    }

    @Override
    protected boolean isAtDestination(Node n) {
        if (this.destinationSlack <= 0.1f) {
            return n.pos.func_177958_n() == this.destination.func_177958_n() && n.pos.func_177956_o() == this.destination.func_177956_o() && n.pos.func_177952_p() == this.destination.func_177952_p();
        }
        if (n.pos.func_177956_o() == this.destination.func_177956_o() - 1) {
            return this.destination.func_218141_a(new Vector3i(n.pos.func_177958_n(), this.destination.func_177956_o(), n.pos.func_177952_p()), (double)DESTINATION_SLACK_ADJACENT);
        }
        return this.destination.func_218141_a((Vector3i)n.pos, (double)DESTINATION_SLACK_ADJACENT);
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return this.destination.func_177951_i((Vector3i)n.pos);
    }
}

