/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.wealdwalker;

import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;

public class CastGoal<T extends MobEntity>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private int attackIntervalMin;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    boolean hasAnimated;
    int animatedTicks;
    int delayTicks;
    int animId;
    boolean done;
    Supplier<Boolean> canUse;

    public CastGoal(T entity, double speed, int attackInterval, float attackRange, Supplier<Boolean> canUse, int animId, int delayTicks) {
        this.mob = entity;
        this.speedModifier = speed;
        this.attackIntervalMin = attackInterval;
        this.attackRadiusSqr = attackRange * attackRange;
        this.canUse = canUse;
        this.animId = animId;
        this.delayTicks = delayTicks;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        return this.canUse.get() != false && this.mob.func_70638_az() != null;
    }

    public boolean func_75253_b() {
        return (this.func_75250_a() || !this.mob.func_70661_as().func_75500_f()) && !this.done;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.mob.func_213395_q(true);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.mob.func_213395_q(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.animatedTicks = 0;
        this.done = false;
        this.hasAnimated = false;
    }

    public void func_75246_d() {
        LivingEntity livingentity = this.mob.func_70638_az();
        if (livingentity == null) {
            return;
        }
        double d0 = this.mob.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
        boolean canSeeEnemy = this.mob.func_70635_at().func_75522_a((Entity)livingentity);
        if (canSeeEnemy != this.seeTime > 0) {
            this.seeTime = 0;
        }
        this.seeTime = canSeeEnemy ? ++this.seeTime : --this.seeTime;
        if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
            this.mob.func_70661_as().func_75499_g();
            ++this.strafingTime;
        } else {
            this.mob.func_70661_as().func_75497_a((Entity)livingentity, this.speedModifier);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.mob.func_70681_au().nextFloat() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.mob.func_70681_au().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                this.strafingBackwards = false;
            } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                this.strafingBackwards = true;
            }
            this.mob.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.mob.func_70625_a((Entity)livingentity, 30.0f, 30.0f);
        } else {
            this.mob.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
        }
        if (this.seeTime >= 40 && !this.hasAnimated) {
            this.hasAnimated = true;
            Networking.sendToNearby(((MobEntity)this.mob).field_70170_p, this.mob, (Object)new PacketAnimEntity(this.mob.func_145782_y(), this.animId));
        }
        if (this.hasAnimated) {
            ++this.animatedTicks;
            if (this.animatedTicks >= this.delayTicks) {
                ((IRangedAttackMob)this.mob).func_82196_d(this.mob.func_70638_az(), 1.0f);
                this.done = true;
            }
        }
    }
}

