/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.familiar;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.event.FamiliarSummonEvent;
import com.hollingsworth.arsnouveau.api.familiar.IFamiliar;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.goal.familiar.FamOwnerHurtByTargetGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.familiar.FamOwnerHurtTargetGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.familiar.FamiliarFollowGoal;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class FamiliarEntity
extends CreatureEntity
implements IAnimatable,
IFamiliar,
IDispellable {
    private static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(FamiliarEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    public static Set<FamiliarEntity> FAMILIAR_SET = Collections.newSetFromMap(new WeakHashMap());
    public boolean terminatedFamiliar;
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public FamiliarEntity(EntityType<? extends CreatureEntity> p_i48575_1_, World p_i48575_2_) {
        super(p_i48575_1_, p_i48575_2_);
        if (!this.field_70170_p.field_72995_K) {
            FAMILIAR_SET.add(this);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    public double getManaReserveModifier() {
        return 0.15;
    }

    public boolean func_70089_S() {
        return super.func_70089_S() && !this.terminatedFamiliar && (this.field_70170_p.field_72995_K || FAMILIAR_SET.contains(this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.terminatedFamiliar) {
            this.func_70106_y();
            FAMILIAR_SET.remove(this);
        }
        if (this.field_70170_p.func_82737_E() % 20L == 0L && !this.field_70170_p.field_72995_K && (this.getOwnerID() == null || ((ServerWorld)this.field_70170_p).func_217461_a(this.getOwnerID()) == null || this.terminatedFamiliar)) {
            this.func_70106_y();
            this.terminatedFamiliar = true;
            FAMILIAR_SET.remove(this);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_188406_j || source == DamageSource.field_76379_h) {
            return false;
        }
        if (source.func_76346_g() == null) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (Goal)new FamiliarFollowGoal(this, 2.0, 6.0f, 4.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new FamOwnerHurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new FamOwnerHurtTargetGoal(this));
    }

    public PlayState walkPredicate(AnimationEvent event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "walkController", 1.0f, this::walkPredicate));
    }

    public boolean canTeleport() {
        return this.getOwner() != null && this.getOwner().func_233570_aj_();
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        if (this.field_70170_p.field_72995_K || this.getOwnerID() == null) {
            return null;
        }
        return (LivingEntity)((ServerWorld)this.field_70170_p).func_217461_a(this.getOwnerID());
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.empty());
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.getOwnerID() != null) {
            tag.func_186854_a("ownerID", this.getOwnerID());
        }
        tag.func_74757_a("terminated", this.terminatedFamiliar);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_186855_b("ownerID")) {
            this.setOwnerID(tag.func_186857_a("ownerID"));
        }
        this.terminatedFamiliar = tag.func_74767_n("terminated");
    }

    @Override
    @Nullable
    public UUID getOwnerID() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER_UUID)).orElse(null);
    }

    @Override
    public void setOwnerID(UUID uuid) {
        this.func_184212_Q().func_187227_b(OWNER_UUID, Optional.of(uuid));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233822_e_, Attributes.field_233822_e_.func_111110_b()).func_233815_a_(Attributes.field_233819_b_, 16.0);
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    protected boolean func_184228_n(Entity p_184228_1_) {
        return false;
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (!this.field_70170_p.field_72995_K && this.getOwner() != null && this.getOwner().equals((Object)caster)) {
            this.func_70106_y();
            ParticleUtil.spawnPoof((ServerWorld)this.field_70170_p, this.func_233580_cy_());
            return true;
        }
        return false;
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
    }

    @Override
    public void onFamiliarSpawned(FamiliarSummonEvent event) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        IFamiliar.super.onFamiliarSpawned(event);
        if (!event.getEntity().equals((Object)this) && event.owner.equals((Object)this.getOwner())) {
            this.terminatedFamiliar = true;
        }
    }
}

