/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Items;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PatchouliProvider
implements IDataProvider {
    private final DataGenerator generator;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();
    List<Enchantment> enchants = new ArrayList<Enchantment>();

    public PatchouliProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path;
        this.addEntries();
        Path output = this.generator.func_200391_b();
        for (Enchantment enchantment : this.enchants) {
            path = PatchouliProvider.getPath(output, enchantment.getRegistryName().func_110623_a());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.getPage(enchantment), (Path)path);
        }
        for (AbstractRitual abstractRitual : ArsNouveauAPI.getInstance().getRitualMap().values()) {
            path = PatchouliProvider.getRitualPath(output, abstractRitual.getID());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.getRitualPage(abstractRitual), (Path)path);
        }
        for (AbstractFamiliarHolder abstractFamiliarHolder : ArsNouveauAPI.getInstance().getFamiliarHolderMap().values()) {
            path = PatchouliProvider.getFamiliarPath(output, abstractFamiliarHolder.getId());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.getFamiliarPage(abstractFamiliarHolder), (Path)path);
        }
    }

    public JsonObject getFamiliarPage(AbstractFamiliarHolder familiarHolder) {
        JsonObject object = new JsonObject();
        object.addProperty("name", "entity.ars_nouveau." + familiarHolder.getId());
        object.addProperty("icon", "ars_nouveau:familiar_" + familiarHolder.getId());
        object.addProperty("category", "familiars");
        JsonArray pages = new JsonArray();
        JsonObject page = new JsonObject();
        page.addProperty("type", "text");
        page.addProperty("text", "ars_nouveau.familiar_desc." + familiarHolder.getId());
        pages.add((JsonElement)page);
        JsonObject page2 = new JsonObject();
        page2.addProperty("type", "entity");
        page2.addProperty("entity", "ars_nouveau:" + familiarHolder.getEntityKey());
        pages.add((JsonElement)page2);
        object.add("pages", (JsonElement)pages);
        return object;
    }

    public JsonObject getRitualPage(AbstractRitual ritual) {
        JsonObject object = new JsonObject();
        object.addProperty("name", "item.ars_nouveau.ritual_" + ritual.getID());
        object.addProperty("icon", "ars_nouveau:ritual_" + ritual.getID());
        object.addProperty("category", "rituals");
        JsonArray pages = new JsonArray();
        JsonObject page = new JsonObject();
        page.addProperty("type", "text");
        page.addProperty("text", "ars_nouveau.ritual_desc." + ritual.getID());
        pages.add((JsonElement)page);
        JsonObject page2 = new JsonObject();
        page2.addProperty("type", "crafting");
        page2.addProperty("recipe", "ars_nouveau:ritual_" + ritual.getID());
        pages.add((JsonElement)page2);
        object.add("pages", (JsonElement)pages);
        return object;
    }

    public JsonObject getPage(Enchantment enchantment) {
        JsonObject object = new JsonObject();
        object.addProperty("name", enchantment.func_77320_a());
        object.addProperty("icon", Items.field_151134_bR.getRegistryName().toString());
        object.addProperty("category", "enchantments");
        JsonArray pages = new JsonArray();
        for (int i = enchantment.func_77319_d(); i <= enchantment.func_77325_b(); ++i) {
            JsonObject page = new JsonObject();
            page.addProperty("type", "enchanting_recipe");
            page.addProperty("recipe", "ars_nouveau:" + enchantment.getRegistryName().func_110623_a() + "_" + i);
            pages.add((JsonElement)page);
        }
        object.add("pages", (JsonElement)pages);
        return object;
    }

    public void addEntries() {
        this.enchants.addAll(Arrays.asList(new Enchantment[]{Enchantments.field_185299_g, Enchantments.field_180312_n, Enchantments.field_185297_d, Enchantments.field_185300_i, Enchantments.field_185305_q, Enchantments.field_180309_e, Enchantments.field_77334_n, Enchantments.field_77329_d, Enchantments.field_185311_w, Enchantments.field_185308_t, Enchantments.field_185312_x, Enchantments.field_180313_o, Enchantments.field_185304_p, Enchantments.field_222192_G, Enchantments.field_222194_I, Enchantments.field_185309_u, Enchantments.field_180308_g, Enchantments.field_180310_c, Enchantments.field_185310_v, Enchantments.field_222193_H, Enchantments.field_185298_f, Enchantments.field_185302_k, Enchantments.field_185306_r, Enchantments.field_185303_l, Enchantments.field_191530_r, Enchantments.field_92091_k, Enchantments.field_185307_s, EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, EnchantmentRegistry.MANA_REGEN_ENCHANTMENT}));
    }

    private static Path getPath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_nouveau/patchouli/enchantments/" + str + ".json");
    }

    private static Path getRitualPath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_nouveau/patchouli/rituals/" + str + ".json");
    }

    private static Path getFamiliarPath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_nouveau/patchouli/familiars/" + str + ".json");
    }

    public String func_200397_b() {
        return "Patchouli";
    }
}

