/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.setup.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CrushRecipe
implements IRecipe<IInventory> {
    public final Ingredient input;
    public final List<CrushOutput> outputs;
    public final ResourceLocation id;
    public static final String RECIPE_ID = "crush";

    public CrushRecipe(ResourceLocation id, Ingredient input, List<CrushOutput> outputs) {
        this.input = input;
        this.outputs = outputs;
        this.id = id;
    }

    public CrushRecipe(String id, Ingredient input, List<CrushOutput> outputs) {
        this(new ResourceLocation("ars_nouveau", "crush_" + id), input, outputs);
    }

    public CrushRecipe(String id, Ingredient input) {
        this(id, input, new ArrayList<CrushOutput>());
    }

    public CrushRecipe withItems(ItemStack output, float chance) {
        this.outputs.add(new CrushOutput(output, chance));
        return this;
    }

    public CrushRecipe withItems(ItemStack output) {
        this.outputs.add(new CrushOutput(output, 1.0f));
        return this;
    }

    public List<ItemStack> getRolledOutputs(Random random) {
        ArrayList<ItemStack> finalOutputs = new ArrayList<ItemStack>();
        for (CrushOutput crushRoll : this.outputs) {
            if (!(random.nextDouble() <= (double)crushRoll.chance)) continue;
            finalOutputs.add(crushRoll.stack.func_77946_l());
        }
        return finalOutputs;
    }

    public boolean func_77569_a(IInventory inventory, World world) {
        return this.input.test(inventory.func_70301_a(0));
    }

    public boolean matches(ItemStack i, World world) {
        return this.input.test(i);
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inventory) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int p_194133_1_, int p_194133_2_) {
        return true;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeRegistry.CRUSH_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return (IRecipeType)Registry.field_218367_H.func_82594_a(new ResourceLocation("ars_nouveau", RECIPE_ID));
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_nouveau:crush");
        jsonobject.add("input", this.input.func_200304_c());
        JsonArray array = new JsonArray();
        for (CrushOutput output : this.outputs) {
            JsonObject element = new JsonObject();
            element.addProperty("item", output.stack.func_77973_b().getRegistryName().toString());
            element.addProperty("chance", (Number)Float.valueOf(output.chance));
            element.addProperty("count", (Number)output.stack.func_190916_E());
            array.add((JsonElement)element);
        }
        jsonobject.add("output", (JsonElement)array);
        return jsonobject;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CrushRecipe> {
        public CrushRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = null;
            input = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"input")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            JsonArray outputs = JSONUtils.func_151214_t((JsonObject)json, (String)"output");
            ArrayList<CrushOutput> parsedOutputs = new ArrayList<CrushOutput>();
            for (JsonElement e : outputs) {
                JsonObject obj = e.getAsJsonObject();
                float chance = JSONUtils.func_151217_k((JsonObject)obj, (String)"chance");
                String itemId = JSONUtils.func_151200_h((JsonObject)obj, (String)"item");
                int count = obj.has("count") ? JSONUtils.func_151203_m((JsonObject)obj, (String)"count") : 1;
                ItemStack output = new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(new ResourceLocation(itemId)), count);
                parsedOutputs.add(new CrushOutput(output, chance));
            }
            return new CrushRecipe(recipeId, input, parsedOutputs);
        }

        public void toNetwork(PacketBuffer buf, CrushRecipe recipe) {
            buf.writeInt(recipe.outputs.size());
            recipe.input.func_199564_a(buf);
            for (CrushOutput i : recipe.outputs) {
                buf.writeFloat(i.chance);
                buf.writeItemStack(i.stack, false);
            }
        }

        @Nullable
        public CrushRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int length = buffer.readInt();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ArrayList<CrushOutput> stacks = new ArrayList<CrushOutput>();
            for (int i = 0; i < length; ++i) {
                try {
                    float chance = buffer.readFloat();
                    ItemStack outStack = buffer.func_150791_c();
                    stacks.add(new CrushOutput(outStack, chance));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            return new CrushRecipe(recipeId, input, stacks);
        }
    }

    public static class CrushOutput {
        public ItemStack stack;
        public float chance;

        public CrushOutput(ItemStack stack, float chance) {
            this.stack = stack;
            this.chance = chance;
        }
    }
}

