/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.IPlaceBlockResponder;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class BasicSpellTurretTile
extends TileEntity
implements IPickupResponder,
IPlaceBlockResponder,
ITooltipProvider,
IAnimatable,
IAnimationListener {
    @Nonnull
    public Spell spell = Spell.EMPTY;
    boolean playRecoil;
    public ParticleColor.IntWrapper color = ParticleUtil.defaultParticleColor().toWrapper();
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public BasicSpellTurretTile(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_);
    }

    public BasicSpellTurretTile() {
        super(BlockRegistry.BASIC_SPELL_TURRET_TILE);
    }

    public int getManaCost() {
        return this.spell.getCastingCost();
    }

    @Override
    @Nonnull
    public ItemStack onPickup(ItemStack stack) {
        return BlockUtil.insertItemAdjacent(this.field_145850_b, this.field_174879_c, stack);
    }

    @Override
    public ItemStack onPlaceBlock() {
        return BlockUtil.getItemAdjacent(this.field_145850_b, this.field_174879_c, stack -> stack.func_77973_b() instanceof BlockItem);
    }

    @Override
    public List<IItemHandler> getInventory() {
        return BlockUtil.getAdjacentInventories(this.field_145850_b, this.field_174879_c);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74778_a("spell", this.spell.serialize());
        tag.func_74778_a("color", this.color.serialize());
        return super.func_189515_b(tag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.spell = Spell.deserialize(tag.func_74779_i("spell"));
        if (tag.func_74764_b("color")) {
            this.color = ParticleColor.IntWrapper.deserialize(tag.func_74779_i("color"));
        }
        super.func_230337_a_(state, tag);
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(new TranslationTextComponent("ars_nouveau.spell_turret.casting").getString() + this.spell.getDisplayString());
        return list;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }

    public PlayState walkPredicate(AnimationEvent event) {
        if (this.playRecoil) {
            event.getController().clearAnimationCache();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("recoil", Boolean.valueOf(false)));
            this.playRecoil = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "castController", 0.0f, this::walkPredicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void startAnimation(int arg) {
        this.playRecoil = true;
    }

    public boolean update() {
        if (this.field_174879_c != null && this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            return true;
        }
        return false;
    }
}

