/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ScribesModel;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoBlockRenderer;

public class ScribesRenderer
extends GeoBlockRenderer<ScribesTile> {
    public ScribesRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn, (AnimatedGeoModel)new ScribesModel());
    }

    public void renderEarly(ScribesTile tile, MatrixStack matrixStack, float ticks, IRenderTypeBuffer iRenderTypeBuffer, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        try {
            if (tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177230_c() != BlockRegistry.SCRIBES_BLOCK) {
                return;
            }
            if (tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177229_b(ScribesBlock.PART) != BedPart.HEAD) {
                return;
            }
            if (tile.stack == null) {
                return;
            }
            double x = tile.func_174877_v().func_177958_n();
            double y = tile.func_174877_v().func_177956_o();
            double z = tile.func_174877_v().func_177952_p();
            if (tile.entity == null || !ItemStack.func_77989_b((ItemStack)tile.entity.func_92059_d(), (ItemStack)tile.stack)) {
                tile.entity = new ItemEntity(tile.func_145831_w(), x, y, z, tile.stack);
            }
            ItemEntity entityItem = tile.entity;
            this.renderPressedItem(tile, entityItem.func_92059_d().func_77973_b(), matrixStack, iRenderTypeBuffer, packedLightIn, packedOverlayIn);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void render(ScribesTile tile, float partialTicks, MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        try {
            if (tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177230_c() != BlockRegistry.SCRIBES_BLOCK) {
                return;
            }
            if (tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177229_b(ScribesBlock.PART) != BedPart.HEAD) {
                return;
            }
            Direction direction = (Direction)tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177229_b((Property)ScribesBlock.FACING);
            stack.func_227860_a_();
            if (direction == Direction.NORTH) {
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                stack.func_227861_a_(1.0, 0.0, -1.0);
            }
            if (direction == Direction.SOUTH) {
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                stack.func_227861_a_(-1.0, 0.0, 0.0);
            }
            if (direction == Direction.WEST) {
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                stack.func_227861_a_(-1.0, 0.0, 0.0);
            }
            if (direction == Direction.EAST) {
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                stack.func_227861_a_(0.0, 0.0, 0.0);
            }
            super.render((TileEntity)tile, partialTicks, stack, bufferIn, packedLightIn);
            stack.func_227865_b_();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void renderPressedItem(ScribesTile tile, Item itemToRender, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int i, int il) {
        Direction direction = (Direction)tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177229_b((Property)ScribesBlock.FACING);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 1.0, 0.0);
        BlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (!(state.func_177230_c() instanceof ScribesBlock)) {
            return;
        }
        float y = ((Direction)state.func_177229_b((Property)ScribesBlock.FACING)).func_176746_e().func_185119_l();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-y + 90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        if (direction == Direction.WEST) {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        }
        if (direction == Direction.EAST) {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
        }
        if (direction == Direction.SOUTH) {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
        matrixStack.func_227862_a_(0.6f, 0.6f, 0.6f);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(new ItemStack((IItemProvider)itemToRender), ItemCameraTransforms.TransformType.FIXED, i, il, matrixStack, iRenderTypeBuffer);
        matrixStack.func_227865_b_();
    }

    public static GenericItemRenderer getISTER() {
        return new GenericItemRenderer(new ScribesModel()).withTranslucency();
    }

    public RenderType getRenderType(ScribesTile animatable, float partialTicks, MatrixStack stack, @Nullable IRenderTypeBuffer renderTypeBuffer, @Nullable IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228644_e_((ResourceLocation)textureLocation);
    }

    public boolean func_188185_a(TileEntity p_188185_1_) {
        return false;
    }
}

